/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TypeCheckingFilter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CardinalityCheckingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.SingletonAtomizer;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;

public final class CardinalityChecker
extends UnaryExpression {
    private int requiredCardinality = -1;
    private RoleDiagnostic role;

    private CardinalityChecker(Expression sequence2, int cardinality, RoleDiagnostic role) {
        super(sequence2);
        this.requiredCardinality = cardinality;
        this.role = role;
    }

    public static Expression makeCardinalityChecker(Expression sequence2, int cardinality, RoleDiagnostic role) {
        UnaryExpression result2;
        if (sequence2 instanceof Literal && Cardinality.subsumes(cardinality, SequenceTool.getCardinality(((Literal)sequence2).getValue()))) {
            return sequence2;
        }
        if (sequence2 instanceof Atomizer && !Cardinality.allowsMany(cardinality)) {
            Expression base = ((Atomizer)sequence2).getBaseExpression();
            result2 = new SingletonAtomizer(base, role, Cardinality.allowsZero(cardinality));
        } else {
            result2 = new CardinalityChecker(sequence2, cardinality, role);
        }
        ExpressionTool.copyLocationInfo(sequence2, result2);
        return result2;
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    public int getRequiredCardinality() {
        return this.requiredCardinality;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        Expression base = this.getBaseExpression();
        if (this.requiredCardinality == 57344 || Cardinality.subsumes(this.requiredCardinality, base.getCardinality())) {
            return base;
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.optimizeChildren(visitor, contextInfo);
        Expression base = this.getBaseExpression();
        if (this.requiredCardinality == 57344 || Cardinality.subsumes(this.requiredCardinality, base.getCardinality())) {
            return base;
        }
        if ((base.getCardinality() & this.requiredCardinality) == 0) {
            XPathException err2 = new XPathException("The " + this.role.getMessage() + " does not satisfy the cardinality constraints", this.role.getErrorCode());
            err2.setLocation(this.getLocation());
            err2.setIsTypeError(this.role.isTypeError());
            throw err2;
        }
        if (base instanceof ItemChecker) {
            ItemChecker checker = (ItemChecker)base;
            Expression other = checker.getBaseExpression();
            this.setBaseExpression(other);
            checker.setBaseExpression(this);
            checker.setParentExpression(null);
            return checker;
        }
        return this;
    }

    public void setErrorCode(String code) {
        this.role.setErrorCode(code);
    }

    public RoleDiagnostic getRoleLocator() {
        return this.role;
    }

    public int getImplementationMethod() {
        int m = 22;
        if (!Cardinality.allowsMany(this.requiredCardinality)) {
            m |= 1;
        }
        return m;
    }

    public IntegerValue[] getIntegerBounds() {
        return this.getBaseExpression().getIntegerBounds();
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator base = this.getBaseExpression().iterate(context);
        if ((base.getProperties() & 2) != 0) {
            int count2 = ((LastPositionFinder)((Object)base)).getLength();
            if (count2 == 0 && !Cardinality.allowsZero(this.requiredCardinality)) {
                this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), context);
            } else if (count2 == 1 && this.requiredCardinality == 8192) {
                this.typeError("The only value allowed for the " + this.role.getMessage() + " is an empty sequence", this.role.getErrorCode(), context);
            } else if (count2 > 1 && !Cardinality.allowsMany(this.requiredCardinality)) {
                this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage() + CardinalityChecker.depictSequenceStart(base, 2), this.role.getErrorCode(), context);
            }
            return base;
        }
        return new CardinalityCheckingIterator(base, this.requiredCardinality, this.role, this.getLocation());
    }

    public static String depictSequenceStart(SequenceIterator seq, int max2) {
        try {
            Item next2;
            FastStringBuffer sb = new FastStringBuffer(64);
            int count2 = 0;
            sb.append(" (");
            while ((next2 = seq.next()) != null) {
                if (count2++ > 0) {
                    sb.append(", ");
                }
                if (count2 > max2) {
                    sb.append("...) ");
                    return sb.toString();
                }
                sb.append(Err.depict(next2));
            }
            sb.append(") ");
            return sb.toString();
        }
        catch (XPathException e) {
            return "";
        }
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        SequenceIterator iter2 = this.getBaseExpression().iterate(context);
        Item first = iter2.next();
        if (first == null) {
            if (!Cardinality.allowsZero(this.requiredCardinality)) {
                this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), context);
            }
            return null;
        }
        if (this.requiredCardinality == 8192) {
            this.typeError("An empty sequence is required as the " + this.role.getMessage(), this.role.getErrorCode(), context);
            return null;
        }
        Item second = iter2.next();
        if (second != null) {
            Item[] leaders = new Item[]{first, second};
            this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage() + CardinalityChecker.depictSequenceStart(new ArrayIterator(leaders), 2), this.role.getErrorCode(), context);
            return null;
        }
        return first;
    }

    public void process(XPathContext context) throws XPathException {
        Expression next2 = this.getBaseExpression();
        ItemType type = Type.ITEM_TYPE;
        if (next2 instanceof ItemChecker) {
            type = ((ItemChecker)next2).getRequiredType();
            next2 = ((ItemChecker)next2).getBaseExpression();
        }
        if ((next2.getImplementationMethod() & 4) != 0 && !(type instanceof DocumentNodeTest)) {
            SequenceReceiver out = context.getReceiver();
            TypeCheckingFilter filter2 = new TypeCheckingFilter(out);
            filter2.setRequiredType(type, this.requiredCardinality, this.role, this.getLocation());
            context.setReceiver(filter2);
            next2.process(context);
            try {
                filter2.close();
            }
            catch (XPathException e) {
                e.maybeSetLocation(this.getLocation());
                throw e;
            }
            context.setReceiver(out);
        } else {
            super.process(context);
        }
    }

    public ItemType getItemType() {
        return this.getBaseExpression().getItemType();
    }

    public int computeCardinality() {
        return this.requiredCardinality;
    }

    public int computeSpecialProperties() {
        return this.getBaseExpression().getSpecialProperties();
    }

    public Expression copy(RebindingMap rebindings) {
        CardinalityChecker c2 = new CardinalityChecker(this.getBaseExpression().copy(rebindings), this.requiredCardinality, this.role);
        ExpressionTool.copyLocationInfo(this, c2);
        return c2;
    }

    public boolean equals(Object other) {
        return super.equals(other) && this.requiredCardinality == ((CardinalityChecker)other).requiredCardinality;
    }

    public int hashCode() {
        return super.hashCode() ^ this.requiredCardinality;
    }

    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("check", this);
        String occ = Cardinality.getOccurrenceIndicator(this.requiredCardinality);
        if (occ.equals("")) {
            occ = "1";
        }
        out.emitAttribute("card", occ);
        out.emitAttribute("diag", this.role.save());
        this.getBaseExpression().export(out);
        out.endElement();
    }

    public String toString() {
        Expression operand = this.getBaseExpression();
        switch (this.requiredCardinality) {
            case 16384: {
                return "exactly-one(" + operand.toString() + ")";
            }
            case 24576: {
                return "zero-or-one(" + operand.toString() + ")";
            }
            case 49152: {
                return "one-or-more(" + operand.toString() + ")";
            }
            case 8192: {
                return "must-be-empty(" + operand.toString() + ")";
            }
        }
        return "check(" + operand.toString() + ")";
    }

    public String getExpressionName() {
        return "CheckCardinality";
    }

    public String toShortString() {
        return this.getBaseExpression().toShortString();
    }

    public String getStreamerName() {
        return "CardinalityChecker";
    }

    public void setLocation(Location id) {
        super.setLocation(id);
    }
}

