/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;

public class SequenceNormalizer
extends ProxyReceiver {
    private String separator;
    private int level = 0;
    private boolean first = true;

    public SequenceNormalizer(SequenceReceiver next2, String separator) {
        super(next2);
        this.separator = separator;
    }

    public void startDocument(int properties) throws XPathException {
        this.sep();
        ++this.level;
        this.getUnderlyingReceiver().startDocument(properties);
    }

    public void endDocument() throws XPathException {
        --this.level;
        this.getUnderlyingReceiver().endDocument();
    }

    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.sep();
        ++this.level;
        this.getUnderlyingReceiver().startElement(elemName, typeCode, location, properties);
    }

    public void endElement() throws XPathException {
        --this.level;
        super.endElement();
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.sep();
        this.getUnderlyingReceiver().characters(chars, locationId, properties);
    }

    public void processingInstruction(String target, CharSequence data2, Location locationId, int properties) throws XPathException {
        this.sep();
        this.getUnderlyingReceiver().processingInstruction(target, data2, locationId, properties);
    }

    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.sep();
        this.getUnderlyingReceiver().comment(chars, locationId, properties);
    }

    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        if (item instanceof ArrayItem) {
            for (Sequence member : (ArrayItem)item) {
                Item it;
                SequenceIterator iter2 = member.iterate();
                while ((it = iter2.next()) != null) {
                    this.append(it, locationId, copyNamespaces);
                }
            }
        } else {
            this.sep();
            if (this.level == 0 && item instanceof AtomicValue) {
                CharSequence cs = item.getStringValueCS();
                this.getUnderlyingReceiver().characters(cs, locationId, 0);
            } else {
                ((SequenceReceiver)this.getUnderlyingReceiver()).append(item, locationId, copyNamespaces);
            }
        }
    }

    public void sep() throws XPathException {
        if (this.level == 0 && !this.first) {
            this.getUnderlyingReceiver().characters(this.separator, ExplicitLocation.UNKNOWN_LOCATION, 0);
        } else {
            this.first = false;
        }
    }
}

