/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Version;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.EventSource;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.NamePoolConverter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.StandardErrorHandler;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullPushCopier;
import net.sf.saxon.pull.PullSource;
import net.sf.saxon.pull.StaxBridge;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public abstract class Sender {
    private static Class[] EMPTY_CLASS_ARRAY = new Class[0];

    private Sender() {
    }

    public static void send(Source source, Receiver receiver, ParseOptions options) throws XPathException {
        SpaceStrippingRule strippingRule;
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        options = options == null ? new ParseOptions(pipe.getParseOptions()) : new ParseOptions(options);
        String systemId = source.getSystemId();
        if (source instanceof AugmentedSource) {
            options.merge(((AugmentedSource)source).getParseOptions());
            systemId = source.getSystemId();
            source = ((AugmentedSource)source).getContainedSource();
        }
        Configuration config = pipe.getConfiguration();
        options.applyDefaults(config);
        receiver.setSystemId(systemId);
        Receiver next2 = receiver;
        int schemaValidation = options.getSchemaValidationMode();
        List<FilterFactory> filters = options.getFilters();
        if (filters != null) {
            for (int i = filters.size() - 1; i >= 0; --i) {
                ProxyReceiver filter2 = filters.get(i).makeFilter(next2);
                filter2.setSystemId(source.getSystemId());
                next2 = filter2;
            }
        }
        if ((strippingRule = options.getSpaceStrippingRule()) != null && !(strippingRule instanceof NoElementsSpaceStrippingRule)) {
            next2 = strippingRule.makeStripper(next2);
        }
        if (source instanceof TreeInfo) {
            source = ((TreeInfo)source).getRootNode();
        }
        if (source instanceof NodeInfo) {
            int kind;
            NodeInfo ns = (NodeInfo)source;
            String baseURI = ns.getBaseURI();
            if (schemaValidation != 3) {
                next2 = config.getDocumentValidator(next2, baseURI, options, null);
            }
            if ((kind = ns.getNodeKind()) != 9 && kind != 1) {
                throw new IllegalArgumentException("Sender can only handle document or element nodes");
            }
            next2.setSystemId(baseURI);
            ExplicitLocation loc = new ExplicitLocation(systemId, -1, -1);
            Sender.sendDocumentInfo(ns, next2, loc);
            return;
        }
        if (source instanceof PullSource) {
            Sender.sendPullSource((PullSource)source, next2, options);
            return;
        }
        if (source instanceof EventSource) {
            ((EventSource)source).send(next2);
            return;
        }
        if (source instanceof SAXSource) {
            Sender.sendSAXSource((SAXSource)source, next2, options);
            return;
        }
        if (source instanceof StreamSource) {
            StreamSource ss = (StreamSource)source;
            boolean dtdValidation = options.getDTDValidationMode() == 1;
            Source ps = Version.platform.getParserSource(pipe, ss, schemaValidation, dtdValidation, options.getStripSpace());
            if (ps == ss) {
                String url = source.getSystemId();
                InputSource is = new InputSource(url);
                is.setCharacterStream(ss.getReader());
                is.setByteStream(ss.getInputStream());
                boolean reuseParser = false;
                XMLReader parser = options.obtainXMLReader();
                if (parser == null) {
                    parser = config.getSourceParser();
                    if (options.getEntityResolver() != null && parser.getEntityResolver() == null) {
                        parser.setEntityResolver(options.getEntityResolver());
                    }
                    reuseParser = true;
                }
                SAXSource sax = new SAXSource(parser, is);
                sax.setSystemId(source.getSystemId());
                Sender.sendSAXSource(sax, next2, options);
                if (reuseParser) {
                    config.reuseSourceParser(parser);
                }
            } else {
                Sender.send(ps, next2, options);
            }
            return;
        }
        if (source instanceof StAXSource) {
            XMLStreamReader reader = ((StAXSource)source).getXMLStreamReader();
            if (reader == null) {
                throw new XPathException("Saxon can only handle a StAXSource that wraps an XMLStreamReader");
            }
            StaxBridge bridge2 = new StaxBridge();
            bridge2.setXMLStreamReader(reader);
            Sender.sendPullSource(new PullSource(bridge2), next2, options);
            return;
        }
        next2 = Sender.makeValidator(next2, source.getSystemId(), options);
        Source newSource = config.getSourceResolver().resolveSource(source, config);
        if (newSource instanceof StreamSource || newSource instanceof SAXSource || newSource instanceof NodeInfo || newSource instanceof PullSource || newSource instanceof AugmentedSource || newSource instanceof EventSource) {
            Sender.send(newSource, next2, options);
        }
        List<ExternalObjectModel> externalObjectModels = config.getExternalObjectModels();
        for (ExternalObjectModel externalObjectModel : externalObjectModels) {
            ExternalObjectModel model = externalObjectModel;
            boolean done = model.sendSource(source, next2);
            if (!done) continue;
            return;
        }
        throw new XPathException("A source of type " + source.getClass().getName() + " is not supported in this environment");
    }

    private static void sendDocumentInfo(NodeInfo top, Receiver receiver, Location location) throws XPathException {
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        NamePool targetNamePool = pipe.getConfiguration().getNamePool();
        if (top.getConfiguration().getNamePool() != targetNamePool) {
            receiver = new NamePoolConverter(receiver, top.getConfiguration().getNamePool(), targetNamePool);
        }
        LocationCopier copier = new LocationCopier(top.getNodeKind() == 9);
        pipe.setComponent(CopyInformee.class.getName(), copier);
        receiver.open();
        receiver.startDocument(0);
        top.copy(receiver, 6, location);
        receiver.endDocument();
        receiver.close();
    }

    /*
     * WARNING - void declaration
     */
    private static void sendSAXSource(SAXSource source, Receiver receiver, ParseOptions options) throws XPathException {
        void var13_26;
        boolean xInclude;
        ErrorHandler errorHandler;
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        XMLReader parser = source.getXMLReader();
        boolean reuseParser = false;
        Configuration config = pipe.getConfiguration();
        UnfailingErrorListener listener = options.getErrorListener();
        if (listener == null) {
            listener = pipe.getErrorListener();
        }
        if ((errorHandler = options.getErrorHandler()) == null) {
            errorHandler = new StandardErrorHandler(listener);
        }
        if (parser == null) {
            parser = options.obtainXMLReader();
        }
        if (parser == null) {
            SAXSource ss = new SAXSource();
            ss.setInputSource(source.getInputSource());
            ss.setSystemId(source.getSystemId());
            parser = config.getSourceParser();
            parser.setErrorHandler(errorHandler);
            if (options.getEntityResolver() != null && parser.getEntityResolver() == null) {
                parser.setEntityResolver(options.getEntityResolver());
            }
            ss.setXMLReader(parser);
            source = ss;
            reuseParser = true;
        } else {
            Sender.configureParser(parser);
            if (parser.getErrorHandler() == null) {
                parser.setErrorHandler(errorHandler);
            }
        }
        if (!pipe.getParseOptions().isExpandAttributeDefaults()) {
            try {
                parser.setFeature("http://xml.org/sax/features/use-attributes2", true);
            }
            catch (SAXNotRecognizedException ss) {
            }
            catch (SAXNotSupportedException ss) {
                // empty catch block
            }
        }
        boolean dtdRecover = options.getDTDValidationMode() == 2;
        Map<String, Boolean> parserFeatures = options.getParserFeatures();
        Map<String, Object> parserProperties = options.getParserProperties();
        if (parserFeatures != null) {
            for (Map.Entry<String, Object> entry2 : parserFeatures.entrySet()) {
                try {
                    String name = entry2.getKey();
                    boolean value2 = (Boolean)entry2.getValue();
                    if (name.equals("http://apache.org/xml/features/xinclude")) {
                        boolean tryAgain = false;
                        try {
                            parser.setFeature(name, value2);
                        }
                        catch (SAXNotRecognizedException err2) {
                            tryAgain = true;
                        }
                        catch (SAXNotSupportedException err3) {
                            tryAgain = true;
                        }
                        if (!tryAgain) continue;
                        try {
                            parser.setFeature(name + "-aware", value2);
                            continue;
                        }
                        catch (SAXNotRecognizedException err4) {
                            throw new XPathException(Sender.namedParser(parser) + " does not recognize request for XInclude processing", err4);
                        }
                        catch (SAXNotSupportedException err5) {
                            throw new XPathException(Sender.namedParser(parser) + " does not support XInclude processing", err5);
                        }
                    }
                    parser.setFeature(entry2.getKey(), (Boolean)entry2.getValue());
                }
                catch (SAXNotRecognizedException err6) {
                    if (!((Boolean)entry2.getValue()).booleanValue()) continue;
                    config.getLogger().warning(Sender.namedParser(parser) + " does not recognize the feature " + entry2.getKey());
                }
                catch (SAXNotSupportedException err7) {
                    if (!((Boolean)entry2.getValue()).booleanValue()) continue;
                    config.getLogger().warning(Sender.namedParser(parser) + " does not support the feature " + entry2.getKey());
                }
            }
        }
        if (parserProperties != null) {
            for (Map.Entry<String, Object> entry3 : parserProperties.entrySet()) {
                try {
                    parser.setProperty(entry3.getKey(), entry3.getValue());
                }
                catch (SAXNotRecognizedException err8) {
                    config.getLogger().warning(Sender.namedParser(parser) + " does not recognize the property " + entry3.getKey());
                }
                catch (SAXNotSupportedException err9) {
                    config.getLogger().warning(Sender.namedParser(parser) + " does not support the property " + entry3.getKey());
                }
            }
        }
        if (xInclude = options.isXIncludeAware()) {
            void var13_23;
            boolean bl = false;
            try {
                parser.setFeature("http://apache.org/xml/features/xinclude-aware", true);
            }
            catch (SAXNotRecognizedException err10) {
                boolean bl2 = true;
            }
            catch (SAXNotSupportedException err11) {
                boolean bl3 = true;
            }
            if (var13_23 != false) {
                try {
                    parser.setFeature("http://apache.org/xml/features/xinclude", true);
                }
                catch (SAXNotRecognizedException err12) {
                    throw new XPathException(Sender.namedParser(parser) + " does not recognize request for XInclude processing", err12);
                }
                catch (SAXNotSupportedException err13) {
                    throw new XPathException(Sender.namedParser(parser) + " does not support XInclude processing", err13);
                }
            }
        }
        receiver = Sender.makeValidator(receiver, source.getSystemId(), options);
        ContentHandler ch = parser.getContentHandler();
        if (ch instanceof ReceivingContentHandler && config.isCompatible(((ReceivingContentHandler)ch).getConfiguration())) {
            ReceivingContentHandler receivingContentHandler = (ReceivingContentHandler)ch;
            receivingContentHandler.reset();
        } else {
            ReceivingContentHandler receivingContentHandler = new ReceivingContentHandler();
            parser.setContentHandler(receivingContentHandler);
            parser.setDTDHandler(receivingContentHandler);
            try {
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", receivingContentHandler);
            }
            catch (SAXNotSupportedException value2) {
            }
            catch (SAXNotRecognizedException value2) {
                // empty catch block
            }
        }
        var13_26.setReceiver(receiver);
        var13_26.setPipelineConfiguration(pipe);
        try {
            parser.parse(source.getInputSource());
        }
        catch (SAXException err14) {
            XPathException de;
            Exception nested = err14.getException();
            if (nested instanceof XPathException) {
                throw (XPathException)nested;
            }
            if (nested instanceof RuntimeException) {
                throw (RuntimeException)nested;
            }
            if (errorHandler instanceof StandardErrorHandler && ((StandardErrorHandler)errorHandler).getFatalErrorCount() == 0 || err14 instanceof SAXParseException && ((SAXParseException)err14).getSystemId() == null && source.getSystemId() != null) {
                de = new XPathException("Error reported by XML parser processing " + source.getSystemId() + ": " + err14.getMessage(), err14);
                listener.fatalError(de);
                de.setHasBeenReported(true);
                throw de;
            }
            de = new XPathException(err14);
            de.setErrorCode("SXXP0003");
            de.setHasBeenReported(true);
            throw de;
        }
        catch (IOException err15) {
            throw new XPathException("I/O error reported by XML parser processing " + source.getSystemId() + ": " + err15.getMessage(), err15);
        }
        if (errorHandler instanceof StandardErrorHandler) {
            int errs = ((StandardErrorHandler)errorHandler).getFatalErrorCount();
            if (errs > 0) {
                throw new XPathException("The XML parser reported " + errs + (errs == 1 ? " error" : " errors"));
            }
            errs = ((StandardErrorHandler)errorHandler).getErrorCount();
            if (errs > 0) {
                String message = "The XML parser reported " + new Numberer_en().toWords(errs).toLowerCase() + " validation error" + (errs == 1 ? "" : "s");
                if (dtdRecover) {
                    message = message + ". Processing continues, because recovery from validation errors was requested";
                    listener.warning(new XPathException(message));
                } else {
                    throw new XPathException(message);
                }
            }
        }
        if (reuseParser) {
            config.reuseSourceParser(parser);
        }
    }

    private static String namedParser(XMLReader parser) {
        return "Selected XML parser " + parser.getClass().getName();
    }

    private static Receiver makeValidator(Receiver receiver, String systemId, ParseOptions options) throws XPathException {
        Controller controller;
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        Configuration config = pipe.getConfiguration();
        int sv = options.getSchemaValidationMode();
        if (sv != 3 && sv != 0 && (controller = pipe.getController()) != null && !controller.getExecutable().isSchemaAware() && sv != 4) {
            throw new XPathException("Cannot use schema-validated input documents when the query/stylesheet is not schema-aware");
        }
        return receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendPullSource(PullSource source, Receiver receiver, ParseOptions options) throws XPathException {
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        boolean xInclude = options.isXIncludeAware();
        if (xInclude) {
            throw new XPathException("XInclude processing is not supported with a pull parser");
        }
        receiver = Sender.makeValidator(receiver, source.getSystemId(), options);
        PullProvider provider = source.getPullProvider();
        provider.setPipelineConfiguration(pipe);
        receiver.setPipelineConfiguration(pipe);
        PullPushCopier copier = new PullPushCopier(provider, receiver);
        try {
            copier.copy();
        }
        finally {
            if (options.isPleaseCloseAfterUse()) {
                provider.close();
            }
        }
    }

    public static void configureParser(XMLReader parser) throws XPathException {
        try {
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXNotSupportedException err2) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not recognize the 'namespaces' feature", err2);
        }
        catch (SAXNotRecognizedException err3) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not support setting the 'namespaces' feature to true", err3);
        }
        try {
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotSupportedException err4) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not recognize the 'namespace-prefixes' feature", err4);
        }
        catch (SAXNotRecognizedException err5) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not support setting the 'namespace-prefixes' feature to false", err5);
        }
    }
}

