/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class ProxyReceiver
extends SequenceReceiver {
    protected Receiver nextReceiver;

    public ProxyReceiver(Receiver nextReceiver) {
        super(nextReceiver.getPipelineConfiguration());
        this.setUnderlyingReceiver(nextReceiver);
        this.setPipelineConfiguration(nextReceiver.getPipelineConfiguration());
    }

    public void setSystemId(String systemId) {
        if (systemId != this.systemId) {
            this.systemId = systemId;
            this.nextReceiver.setSystemId(systemId);
        }
    }

    public void setUnderlyingReceiver(Receiver receiver) {
        this.nextReceiver = receiver;
    }

    public Receiver getUnderlyingReceiver() {
        return this.nextReceiver;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        if (this.pipelineConfiguration != pipe) {
            this.pipelineConfiguration = pipe;
            if (this.nextReceiver.getPipelineConfiguration() != pipe) {
                this.nextReceiver.setPipelineConfiguration(pipe);
            }
        }
    }

    public NamePool getNamePool() {
        return this.pipelineConfiguration.getConfiguration().getNamePool();
    }

    public void open() throws XPathException {
        this.nextReceiver.open();
    }

    public void close() throws XPathException {
        this.nextReceiver.close();
    }

    public void startDocument(int properties) throws XPathException {
        this.nextReceiver.startDocument(properties);
    }

    public void endDocument() throws XPathException {
        this.nextReceiver.endDocument();
    }

    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.nextReceiver.startElement(elemName, typeCode, location, properties);
    }

    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        this.nextReceiver.namespace(namespaceBindings, properties);
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value2, Location locationId, int properties) throws XPathException {
        this.nextReceiver.attribute(nameCode, typeCode, value2, locationId, properties);
    }

    public void startContent() throws XPathException {
        this.nextReceiver.startContent();
    }

    public void endElement() throws XPathException {
        this.nextReceiver.endElement();
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.nextReceiver.characters(chars, locationId, properties);
    }

    public void processingInstruction(String target, CharSequence data2, Location locationId, int properties) throws XPathException {
        this.nextReceiver.processingInstruction(target, data2, locationId, properties);
    }

    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.nextReceiver.comment(chars, locationId, properties);
    }

    public void setUnparsedEntity(String name, String uri, String publicId) throws XPathException {
        this.nextReceiver.setUnparsedEntity(name, uri, publicId);
    }

    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        if (!(this.nextReceiver instanceof SequenceReceiver)) {
            throw new UnsupportedOperationException("append() method is not supported in " + this.nextReceiver.getClass());
        }
        ((SequenceReceiver)this.nextReceiver).append(item, locationId, copyNamespaces);
    }

    public boolean usesTypeAnnotations() {
        return this.nextReceiver.usesTypeAnnotations();
    }
}

