/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.Item;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelineConfiguration {
    private Configuration config;
    private URIResolver uriResolver;
    private SchemaURIResolver schemaURIResolver;
    private Controller controller;
    private Stack<Item> currentApplyStack;
    private ParseOptions parseOptions;
    private int hostLanguage = 50;
    private Map<String, Object> components;
    private boolean locationIsCodeLocation = false;

    public PipelineConfiguration(Configuration config) {
        this.config = config;
        this.parseOptions = new ParseOptions();
    }

    public PipelineConfiguration(PipelineConfiguration p) {
        this.config = p.config;
        this.uriResolver = p.uriResolver;
        this.schemaURIResolver = p.schemaURIResolver;
        this.controller = p.controller;
        this.parseOptions = new ParseOptions(p.parseOptions);
        this.hostLanguage = p.hostLanguage;
        if (p.components != null) {
            this.components = new HashMap<String, Object>(p.components);
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public UnfailingErrorListener getLocalErrorListener() {
        return this.parseOptions.getErrorListener();
    }

    public UnfailingErrorListener getErrorListener() {
        UnfailingErrorListener listener = this.parseOptions.getErrorListener();
        if (listener == null) {
            listener = this.config.getErrorListener();
        }
        return listener;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.parseOptions.setErrorListener(errorListener);
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public SchemaURIResolver getSchemaURIResolver() {
        return this.schemaURIResolver;
    }

    public void setParseOptions(ParseOptions options) {
        this.parseOptions = options;
    }

    public ParseOptions getParseOptions() {
        return this.parseOptions;
    }

    public void setUseXsiSchemaLocation(boolean recognize) {
        this.parseOptions.setUseXsiSchemaLocation(recognize);
    }

    public void setRecoverFromValidationErrors(boolean recover2) {
        this.parseOptions.setContinueAfterValidationErrors(recover2);
    }

    public boolean isRecoverFromValidationErrors() {
        return this.parseOptions.isContinueAfterValidationErrors();
    }

    public void setSchemaURIResolver(SchemaURIResolver resolver) {
        this.schemaURIResolver = resolver;
    }

    public Controller getController() {
        return this.controller;
    }

    public void pushCurrentAppliedItem(Item item) {
        if (this.currentApplyStack == null) {
            this.currentApplyStack = new Stack();
        }
        this.currentApplyStack.push(item);
    }

    public void popCurrentAppliedItem() {
        this.currentApplyStack.pop();
    }

    public Item peekCurrentAppliedItem() {
        if (this.currentApplyStack != null && this.currentApplyStack.size() > 0) {
            return this.currentApplyStack.peek();
        }
        return null;
    }

    public Stack<Item> getAppliedItemStack() {
        return this.currentApplyStack;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public void setHostLanguage(int language2) {
        this.hostLanguage = language2;
    }

    public void setExpandAttributeDefaults(boolean expand) {
        this.parseOptions.setExpandAttributeDefaults(expand);
    }

    public void setComponent(String name, Object value2) {
        if (this.components == null) {
            this.components = new HashMap<String, Object>();
        }
        this.components.put(name, value2);
    }

    public Object getComponent(String name) {
        if (this.components == null) {
            return null;
        }
        return this.components.get(name);
    }

    public boolean isLocationIsCodeLocation() {
        return this.locationIsCodeLocation;
    }

    public void setLocationIsCodeLocation(boolean locationIsCodeLocation) {
        this.locationIsCodeLocation = locationIsCodeLocation;
    }
}

