/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.trans.XPathException;

public class NoOpenStartTagException
extends XPathException {
    public static NoOpenStartTagException makeNoOpenStartTagException(int nodeKind, String name, int hostLanguage, boolean parentIsDocument, boolean isSerializing, Location startElementLocationId) {
        String errorCode;
        String message;
        String kind;
        if (parentIsDocument) {
            if (isSerializing) {
                kind = nodeKind == 2 ? "attribute" : "namespace";
                message = "Cannot serialize a free-standing " + kind + " node (" + name + ')';
                errorCode = "SENR0001";
            } else {
                kind = nodeKind == 2 ? "an attribute" : "a namespace";
                message = "Cannot create " + kind + " node (" + name + ") whose parent is a document node";
                errorCode = hostLanguage == 50 ? "XTDE0420" : "XPTY0004";
            }
        } else {
            kind = nodeKind == 2 ? "An attribute" : "A namespace";
            message = kind + " node (" + name + ") cannot be created after a child of the containing element";
            String string2 = errorCode = hostLanguage == 50 ? "XTDE0410" : "XQTY0024";
        }
        if (startElementLocationId != null) {
            message = message + ". Most recent element start tag was output at line " + startElementLocationId.getLineNumber() + " of module " + StandardErrorListener.abbreviatePath(startElementLocationId.getSystemId());
        }
        NoOpenStartTagException err2 = new NoOpenStartTagException(message);
        err2.setErrorCode(errorCode);
        return err2;
    }

    public NoOpenStartTagException(String message) {
        super(message);
    }
}

