/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class NamePoolConverter
extends ProxyReceiver {
    NamePool oldPool;
    NamePool newPool;

    public NamePoolConverter(Receiver next2, NamePool oldPool, NamePool newPool) {
        super(next2);
        this.oldPool = oldPool;
        this.newPool = newPool;
    }

    public void setUnderlyingReceiver(Receiver receiver) {
        this.nextReceiver = receiver;
    }

    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        int fp = this.newPool.allocateFingerprint(nameCode.getURI(), nameCode.getLocalPart());
        this.nextReceiver.startElement(new CodedName(fp, nameCode.getPrefix(), this.newPool), typeCode, location, properties);
    }

    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        this.nextReceiver.namespace(namespaceBindings, properties);
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value2, Location locationId, int properties) throws XPathException {
        int fp = this.newPool.allocateFingerprint(nameCode.getURI(), nameCode.getLocalPart());
        this.nextReceiver.attribute(new CodedName(fp, nameCode.getPrefix(), this.newPool), typeCode, value2, locationId, properties);
    }
}

