/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashSet;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class IDFilter
extends StartTagBuffer {
    private String requiredId;
    private int activeDepth = 0;
    private boolean matched = false;
    private HashSet<SimpleType> nonIDs;

    public IDFilter(Receiver next2, String id) {
        super(next2);
        this.requiredId = id;
    }

    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.matched = false;
        if (this.activeDepth > 0) {
            ++this.activeDepth;
        }
        super.startElement(nameCode, typeCode, location, properties);
    }

    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value2, Location locationId, int properties) throws XPathException {
        super.attribute(attName, typeCode, value2, locationId, properties);
        if ((attName.equals(StandardNames.XML_ID_NAME) || (properties & 0x800) != 0) && value2.toString().equals(this.requiredId)) {
            this.matched = true;
        }
    }

    public void startContent() throws XPathException {
        if (this.activeDepth > 0) {
            super.startContent();
        } else if (this.matched) {
            this.activeDepth = 1;
            super.startContent();
        }
    }

    protected void declareNamespacesForStartElement() throws XPathException {
        if (this.activeDepth == 1) {
            this.declareAllNamespaces();
        } else {
            super.declareNamespacesForStartElement();
        }
    }

    public void endElement() throws XPathException {
        if (this.activeDepth > 0) {
            this.nextReceiver.endElement();
            --this.activeDepth;
        } else {
            this.undeclareNamespacesForElement();
        }
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.activeDepth > 0) {
            super.characters(chars, locationId, properties);
        }
    }

    public void processingInstruction(String target, CharSequence data2, Location locationId, int properties) throws XPathException {
        if (this.activeDepth > 0) {
            super.processingInstruction(target, data2, locationId, properties);
        }
    }

    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.activeDepth > 0) {
            super.comment(chars, locationId, properties);
        }
    }

    public boolean usesTypeAnnotations() {
        return true;
    }

    private boolean isIDCode(SimpleType typeCode) {
        if (typeCode == BuiltInAtomicType.ID) {
            return true;
        }
        if (typeCode instanceof BuiltInAtomicType) {
            return false;
        }
        if (this.nonIDs == null) {
            this.nonIDs = new HashSet(20);
        }
        if (this.nonIDs.contains(typeCode)) {
            return false;
        }
        if (typeCode.isAtomicType()) {
            if (this.getConfiguration().getTypeHierarchy().isSubType((AtomicType)typeCode, BuiltInAtomicType.ID)) {
                return true;
            }
            this.nonIDs.add(typeCode);
            return false;
        }
        return false;
    }
}

