/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.InScopeNamespaces;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;

public final class ComplexContentOutputter
extends SequenceReceiver {
    private Receiver nextReceiver;
    private int pendingStartTagDepth = -2;
    private NodeName pendingStartTag = null;
    private int level = -1;
    private boolean[] currentLevelIsDocument = new boolean[20];
    private InScopeNamespaces[] copyNamespacesStack = new InScopeNamespaces[20];
    private Boolean elementIsInNullNamespace;
    private NodeName[] pendingAttCode = new NodeName[20];
    private SimpleType[] pendingAttType = new SimpleType[20];
    private String[] pendingAttValue = new String[20];
    private Location[] pendingAttLocation = new Location[20];
    private int[] pendingAttProp = new int[20];
    private int pendingAttListSize = 0;
    private NamespaceBinding[] pendingNSList = new NamespaceBinding[20];
    private int pendingNSListSize = 0;
    private SchemaType currentSimpleType = null;
    private int startElementProperties;
    private Location startElementLocationId = ExplicitLocation.UNKNOWN_LOCATION;
    private boolean declaresDefaultNamespace;
    private int hostLanguage = 50;
    private boolean serializing = false;

    public ComplexContentOutputter(PipelineConfiguration pipe) {
        super(pipe);
    }

    public static SequenceReceiver makeComplexContentReceiver(Receiver receiver, ParseOptions options) throws XPathException {
        boolean validate2;
        String systemId = receiver.getSystemId();
        boolean bl = validate2 = options != null && options.getSchemaValidationMode() != 3;
        if (receiver instanceof ComplexContentOutputter && !validate2) {
            return (ComplexContentOutputter)receiver;
        }
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        ComplexContentOutputter out = new ComplexContentOutputter(pipe);
        out.setHostLanguage(pipe.getHostLanguage());
        NamespaceReducer ne = new NamespaceReducer(receiver);
        ne.setSystemId(receiver.getSystemId());
        receiver = ne;
        if (validate2) {
            Configuration config = pipe.getConfiguration();
            receiver = config.getDocumentValidator(ne, receiver.getSystemId(), options, null);
        }
        out.setReceiver(receiver);
        out.setSystemId(systemId);
        return out;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        if (this.pipelineConfiguration != pipe) {
            this.pipelineConfiguration = pipe;
            if (this.nextReceiver != null) {
                this.nextReceiver.setPipelineConfiguration(pipe);
            }
        }
    }

    public void setSystemId(String systemId) {
        super.setSystemId(systemId);
        this.nextReceiver.setSystemId(systemId);
    }

    public void setHostLanguage(int language2) {
        this.hostLanguage = language2;
    }

    public void setSerializing(boolean serializing) {
        this.serializing = serializing;
    }

    public boolean isSerializing() {
        return this.serializing;
    }

    public void setReceiver(Receiver receiver) {
        this.nextReceiver = receiver;
    }

    public Receiver getReceiver() {
        return this.nextReceiver;
    }

    public void open() throws XPathException {
        this.nextReceiver.open();
        this.previousAtomic = false;
    }

    public void startDocument(int properties) throws XPathException {
        ++this.level;
        if (this.level == 0) {
            this.nextReceiver.startDocument(properties);
        } else if (this.pendingStartTagDepth >= 0) {
            this.startContent();
            this.pendingStartTagDepth = -2;
        }
        this.previousAtomic = false;
        if (this.currentLevelIsDocument.length < this.level + 1) {
            this.currentLevelIsDocument = Arrays.copyOf(this.currentLevelIsDocument, this.level * 2);
        }
        this.currentLevelIsDocument[this.level] = true;
    }

    public void endDocument() throws XPathException {
        if (this.level == 0) {
            this.nextReceiver.endDocument();
        }
        this.previousAtomic = false;
        --this.level;
    }

    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
        this.nextReceiver.setUnparsedEntity(name, systemID, publicID);
    }

    public void characters(CharSequence s2, Location locationId, int properties) throws XPathException {
        this.previousAtomic = false;
        if (s2 == null) {
            return;
        }
        int len = s2.length();
        if (len == 0) {
            return;
        }
        if (this.pendingStartTagDepth >= 0) {
            this.startContent();
        }
        this.nextReceiver.characters(s2, locationId, properties);
    }

    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        ++this.level;
        if (this.pendingStartTagDepth >= 0) {
            this.startContent();
        }
        this.startElementProperties = properties;
        this.startElementLocationId = location.saveLocation();
        this.pendingAttListSize = 0;
        this.pendingNSListSize = 0;
        this.pendingStartTag = elemName;
        this.pendingStartTagDepth = 1;
        this.elementIsInNullNamespace = null;
        this.declaresDefaultNamespace = false;
        this.currentSimpleType = typeCode;
        this.previousAtomic = false;
        if (this.currentLevelIsDocument.length < this.level + 1) {
            this.currentLevelIsDocument = Arrays.copyOf(this.currentLevelIsDocument, this.level * 2);
        }
        if (this.copyNamespacesStack.length < this.level + 1) {
            this.copyNamespacesStack = Arrays.copyOf(this.copyNamespacesStack, this.level * 2);
        }
        this.currentLevelIsDocument[this.level] = false;
    }

    public void namespace(NamespaceBindingSet nsBindings, int properties) throws XPathException {
        if (nsBindings instanceof InScopeNamespaces) {
            this.copyNamespacesStack[this.level] = (InScopeNamespaces)nsBindings;
            if (this.level > 1 && this.copyNamespacesStack[this.level - 1] instanceof InScopeNamespaces && this.copyNamespacesStack[this.level - 1].getElement().isSameNodeInfo(((InScopeNamespaces)nsBindings).getElement())) {
                return;
            }
        }
        for (NamespaceBinding ns : nsBindings) {
            if (this.pendingStartTagDepth < 0) {
                throw NoOpenStartTagException.makeNoOpenStartTagException(13, ns.getPrefix(), this.hostLanguage, this.pendingStartTagDepth == -2, this.isSerializing(), this.startElementLocationId);
            }
            boolean rejectDuplicates = (properties & 0x20) != 0;
            for (int i = 0; i < this.pendingNSListSize; ++i) {
                if (nsBindings.equals(this.pendingNSList[i])) {
                    return;
                }
                if (!ns.getPrefix().equals(this.pendingNSList[i].getPrefix())) continue;
                if (this.pendingNSList[i].isDefaultUndeclaration() || ns.isDefaultUndeclaration()) {
                    this.pendingNSList[i] = ns;
                    continue;
                }
                if (rejectDuplicates) {
                    String prefix = ns.getPrefix();
                    String uri1 = ns.getURI();
                    String uri2 = this.pendingNSList[i].getURI();
                    XPathException err2 = new XPathException("Cannot create two namespace nodes with the same prefix mapped to different URIs (prefix=" + (prefix.isEmpty() ? "\"\"" : prefix) + ", URI=" + (uri1.isEmpty() ? "\"\"" : uri1) + ", URI=" + (uri2.isEmpty() ? "\"\"" : uri2) + ")");
                    err2.setErrorCode(this.hostLanguage == 50 ? "XTDE0430" : "XQDY0102");
                    throw err2;
                }
                return;
            }
            if (ns.getPrefix().isEmpty() && ns.getURI().length() != 0) {
                this.declaresDefaultNamespace = true;
                if (this.elementIsInNullNamespace == null) {
                    this.elementIsInNullNamespace = this.pendingStartTag.hasURI("");
                }
                if (this.elementIsInNullNamespace.booleanValue()) {
                    XPathException err3 = new XPathException("Cannot output a namespace node for the default namespace when the element is in no namespace");
                    err3.setErrorCode(this.hostLanguage == 50 ? "XTDE0440" : "XQDY0102");
                    throw err3;
                }
            }
            if (this.pendingNSListSize + 1 > this.pendingNSList.length) {
                this.pendingNSList = Arrays.copyOf(this.pendingNSList, this.pendingNSListSize * 2);
            }
            this.pendingNSList[this.pendingNSListSize++] = ns;
            this.previousAtomic = false;
        }
    }

    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value2, Location locationId, int properties) throws XPathException {
        if (this.pendingStartTagDepth < 0) {
            NoOpenStartTagException err2 = NoOpenStartTagException.makeNoOpenStartTagException(2, attName.getDisplayName(), this.hostLanguage, this.level < 0 || this.currentLevelIsDocument[this.level], this.isSerializing(), this.startElementLocationId);
            err2.setLocator(locationId);
            throw err2;
        }
        for (int a = 0; a < this.pendingAttListSize; ++a) {
            if (!this.pendingAttCode[a].equals(attName)) continue;
            if (this.hostLanguage == 50) {
                this.pendingAttType[a] = typeCode;
                this.pendingAttValue[a] = value2.toString();
                this.pendingAttLocation[a] = locationId;
                this.pendingAttProp[a] = properties;
                return;
            }
            XPathException err3 = new XPathException("Cannot create an element having two attributes with the same name: " + Err.wrap(attName.getDisplayName(), 2));
            err3.setErrorCode("XQDY0025");
            throw err3;
        }
        if (this.level == 0 && !typeCode.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && this.currentLevelIsDocument[0] && typeCode.isNamespaceSensitive()) {
            XPathException err4 = new XPathException("Cannot copy attributes whose type is namespace-sensitive (QName or NOTATION): " + Err.wrap(attName.getDisplayName(), 2));
            err4.setErrorCode(this.hostLanguage == 50 ? "XTTE0950" : "XQTY0086");
            throw err4;
        }
        if (this.pendingAttListSize >= this.pendingAttCode.length) {
            this.pendingAttCode = Arrays.copyOf(this.pendingAttCode, this.pendingAttListSize * 2);
            this.pendingAttType = Arrays.copyOf(this.pendingAttType, this.pendingAttListSize * 2);
            this.pendingAttValue = Arrays.copyOf(this.pendingAttValue, this.pendingAttListSize * 2);
            this.pendingAttLocation = Arrays.copyOf(this.pendingAttLocation, this.pendingAttListSize * 2);
            this.pendingAttProp = Arrays.copyOf(this.pendingAttProp, this.pendingAttListSize * 2);
        }
        this.pendingAttCode[this.pendingAttListSize] = attName;
        this.pendingAttType[this.pendingAttListSize] = typeCode;
        this.pendingAttValue[this.pendingAttListSize] = value2.toString();
        this.pendingAttLocation[this.pendingAttListSize] = locationId;
        this.pendingAttProp[this.pendingAttListSize] = properties;
        ++this.pendingAttListSize;
        this.previousAtomic = false;
    }

    private NodeName checkProposedPrefix(NodeName nodeName, int seq) throws XPathException {
        NamespaceBinding binding = nodeName.getNamespaceBinding();
        String nsprefix = binding.getPrefix();
        for (int i = 0; i < this.pendingNSListSize; ++i) {
            if (!nsprefix.equals(this.pendingNSList[i].getPrefix())) continue;
            if (binding.getURI().equals(this.pendingNSList[i].getURI())) {
                return nodeName;
            }
            String prefix = this.getSubstitutePrefix(binding, seq);
            FingerprintedQName newName = new FingerprintedQName(prefix, nodeName.getURI(), nodeName.getLocalPart());
            this.namespace(newName.getNamespaceBinding(), 0);
            return newName;
        }
        if (seq > 0 && nsprefix.isEmpty()) {
            String prefix = this.getSubstitutePrefix(binding, seq);
            FingerprintedQName newName = new FingerprintedQName(prefix, nodeName.getURI(), nodeName.getLocalPart());
            this.namespace(newName.getNamespaceBinding(), 0);
            return newName;
        }
        this.namespace(binding, 0);
        return nodeName;
    }

    private String getSubstitutePrefix(NamespaceBinding nscode, int seq) {
        if (nscode.getURI().equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        return nscode.getPrefix() + '_' + seq;
    }

    public void endElement() throws XPathException {
        if (this.pendingStartTagDepth >= 0) {
            this.startContent();
        } else {
            this.pendingStartTagDepth = -2;
            this.pendingStartTag = null;
        }
        this.nextReceiver.endElement();
        --this.level;
        this.previousAtomic = false;
    }

    public void comment(CharSequence comment2, Location locationId, int properties) throws XPathException {
        if (this.pendingStartTagDepth >= 0) {
            this.startContent();
        }
        this.nextReceiver.comment(comment2, locationId, properties);
        this.previousAtomic = false;
    }

    public void processingInstruction(String target, CharSequence data2, Location locationId, int properties) throws XPathException {
        if (this.pendingStartTagDepth >= 0) {
            this.startContent();
        }
        this.nextReceiver.processingInstruction(target, data2, locationId, properties);
        this.previousAtomic = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        if (item == null) return;
        if (item instanceof AtomicValue || item instanceof ObjectValue) {
            if (this.previousAtomic) {
                this.characters(" ", locationId, 0);
            }
            this.characters(item.getStringValueCS(), locationId, 0);
            this.previousAtomic = true;
            return;
        }
        if (item instanceof ArrayItem) {
            Iterator<Sequence> iterator2 = ((ArrayItem)item).iterator();
            block0: while (true) {
                if (!iterator2.hasNext()) return;
                Sequence member = iterator2.next();
                SequenceIterator iter2 = member.iterate();
                while (true) {
                    Item it;
                    if ((it = iter2.next()) == null) continue block0;
                    this.append(it, locationId, copyNamespaces);
                }
                break;
            }
        }
        if (item instanceof Function) {
            String string2;
            if (SequenceReceiver.isTrueSequenceReceiver(this.nextReceiver)) {
                ((SequenceReceiver)this.nextReceiver).append(item);
                return;
            }
            String kind = "a function item";
            if (item instanceof MapItem) {
                kind = "a map";
            }
            boolean isXSLT = this.getPipelineConfiguration().getHostLanguage() == 50;
            String string3 = "Cannot add " + kind + " to an XML tree";
            if (isXSLT) {
                string2 = "XTDE0450";
                throw new XPathException(string3, string2, locationId);
            }
            string2 = "FOTY0013";
            throw new XPathException(string3, string2, locationId);
        }
        if (((NodeInfo)item).getNodeKind() == 9) {
            this.startDocument(0);
            AxisIterator iter3 = ((NodeInfo)item).iterateAxis((byte)3);
            while (true) {
                Item it;
                if ((it = iter3.next()) == null) {
                    this.endDocument();
                    this.previousAtomic = false;
                    return;
                }
                this.append(it, locationId, copyNamespaces);
            }
        }
        if (item instanceof Orphan && ((Orphan)item).isDisableOutputEscaping()) {
            this.characters(item.getStringValueCS(), locationId, 1);
            this.previousAtomic = false;
            return;
        }
        int copyOptions = 4;
        if (copyNamespaces == 1) {
            copyOptions |= 1;
        } else if (copyNamespaces == 2) {
            copyOptions |= 2;
        }
        ((NodeInfo)item).copy(this, copyOptions, locationId);
        this.previousAtomic = false;
    }

    public void close() throws XPathException {
        this.nextReceiver.close();
        this.previousAtomic = false;
    }

    public void startContent() throws XPathException {
        int a;
        if (this.pendingStartTagDepth < 0) {
            return;
        }
        int props = this.startElementProperties;
        NodeName elcode = this.pendingStartTag;
        if (this.declaresDefaultNamespace || this.pendingStartTag.getPrefix().length() != 0) {
            elcode = this.checkProposedPrefix(this.pendingStartTag, 0);
            props = this.startElementProperties | 0x40;
        }
        this.nextReceiver.startElement(elcode, this.currentSimpleType, this.startElementLocationId, props);
        for (a = 0; a < this.pendingAttListSize; ++a) {
            NodeName attcode = this.pendingAttCode[a];
            if (attcode.hasURI("")) continue;
            this.pendingAttCode[a] = attcode = this.checkProposedPrefix(attcode, a + 1);
        }
        for (int n = 0; n < this.pendingNSListSize; ++n) {
            this.nextReceiver.namespace(this.pendingNSList[n], 0);
        }
        for (a = 0; a < this.pendingAttListSize; ++a) {
            this.nextReceiver.attribute(this.pendingAttCode[a], this.pendingAttType[a], this.pendingAttValue[a], this.pendingAttLocation[a], this.pendingAttProp[a]);
        }
        this.nextReceiver.startContent();
        this.pendingAttListSize = 0;
        this.pendingNSListSize = 0;
        this.pendingStartTagDepth = -1;
        this.previousAtomic = false;
    }

    public boolean usesTypeAnnotations() {
        return this.nextReceiver.usesTypeAnnotations();
    }

    public void beforeBulkCopy() throws XPathException {
        ++this.level;
        if (this.pendingStartTagDepth >= 0) {
            this.startContent();
        }
    }

    public void afterBulkCopy() {
        --this.level;
        this.previousAtomic = false;
    }
}

