/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;

public class CommentStripper
extends ProxyReceiver {
    private CompressedWhitespace savedWhitespace = null;
    private FastStringBuffer buffer = new FastStringBuffer(256);

    public CommentStripper(Receiver next2) {
        super(next2);
    }

    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.flush();
        this.nextReceiver.startElement(nameCode, typeCode, location, properties);
    }

    public void endElement() throws XPathException {
        this.flush();
        this.nextReceiver.endElement();
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (chars instanceof CompressedWhitespace) {
            if (this.buffer.isEmpty() && this.savedWhitespace == null) {
                this.savedWhitespace = (CompressedWhitespace)chars;
            } else {
                ((CompressedWhitespace)chars).uncompress(this.buffer);
            }
        } else {
            if (this.savedWhitespace != null) {
                this.savedWhitespace.uncompress(this.buffer);
                this.savedWhitespace = null;
            }
            this.buffer.append(chars);
        }
    }

    public void comment(CharSequence chars, Location locationId, int properties) {
    }

    public void processingInstruction(String name, CharSequence data2, Location locationId, int properties) {
    }

    private void flush() throws XPathException {
        if (this.buffer.length() > 0) {
            this.nextReceiver.characters(this.buffer, ExplicitLocation.UNKNOWN_LOCATION, 0);
        } else if (this.savedWhitespace != null) {
            this.nextReceiver.characters(this.savedWhitespace, ExplicitLocation.UNKNOWN_LOCATION, 0);
        }
        this.savedWhitespace = null;
        this.buffer.setLength(0);
    }
}

