/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Whitespace;

public class CheckSumFilter
extends ProxyReceiver {
    private static final boolean DEBUG = false;
    int checksum = 0;
    int sequence = 0;
    boolean checkExistingChecksum = false;
    boolean checksumCorrect = false;
    boolean checksumFound = false;
    public static final String SIGMA = "\u03a3";

    public CheckSumFilter(Receiver nextReceiver) {
        super(nextReceiver);
    }

    public void setCheckExistingChecksum(boolean check2) {
        this.checkExistingChecksum = check2;
    }

    public void startDocument(int properties) throws XPathException {
        super.startDocument(properties);
    }

    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        this.checksum ^= this.hash(item.toString(), this.sequence++);
        super.append(item, locationId, copyNamespaces);
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value2, Location locationId, int properties) throws XPathException {
        this.checksum ^= this.hash(nameCode, this.sequence);
        this.checksum ^= this.hash(value2, this.sequence);
        super.attribute(nameCode, typeCode, value2, locationId, properties);
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (!Whitespace.isWhite(chars)) {
            this.checksum ^= this.hash(chars, this.sequence++);
        }
        super.characters(chars, locationId, properties);
    }

    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.checksum ^= this.hash(elemName, this.sequence++);
        this.checksumCorrect = false;
        super.startElement(elemName, typeCode, location, properties);
    }

    public void endElement() throws XPathException {
        this.checksum ^= 1;
        super.endElement();
    }

    public void processingInstruction(String target, CharSequence data2, Location locationId, int properties) throws XPathException {
        if (target.equals(SIGMA)) {
            this.checksumFound = true;
            if (this.checkExistingChecksum) {
                try {
                    int found = (int)Long.parseLong("0" + data2.toString(), 16);
                    this.checksumCorrect = found == this.checksum;
                }
                catch (NumberFormatException e) {
                    this.checksumCorrect = false;
                }
            }
        }
        super.processingInstruction(target, data2, locationId, properties);
    }

    public boolean isChecksumFound() {
        return this.checksumFound;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public boolean isChecksumCorrect() {
        return this.checksumCorrect;
    }

    private int hash(CharSequence s2, int sequence2) {
        int h = sequence2 << 8;
        for (int i = 0; i < s2.length(); ++i) {
            h = (h << 1) + s2.charAt(i);
        }
        return h;
    }

    private int hash(NodeName n, int sequence2) {
        return this.hash(n.getLocalPart(), sequence2) ^ this.hash(n.getURI(), sequence2);
    }
}

