/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.util.ArrayList;
import net.sf.saxon.dom.DOMImplementationImpl;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.tree.iter.AxisIterator;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentOverNodeInfo
extends NodeOverNodeInfo
implements Document {
    public DocumentType getDoctype() {
        return null;
    }

    public DOMImplementation getImplementation() {
        return new DOMImplementationImpl();
    }

    public Element createElement(String tagName) throws DOMException {
        DocumentOverNodeInfo.disallowUpdate();
        return null;
    }

    public DocumentFragment createDocumentFragment() {
        return null;
    }

    public Text createTextNode(String data2) {
        return null;
    }

    public Comment createComment(String data2) {
        return null;
    }

    public CDATASection createCDATASection(String data2) throws DOMException {
        DocumentOverNodeInfo.disallowUpdate();
        return null;
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data2) throws DOMException {
        DocumentOverNodeInfo.disallowUpdate();
        return null;
    }

    public Attr createAttribute(String name) throws DOMException {
        DocumentOverNodeInfo.disallowUpdate();
        return null;
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        DocumentOverNodeInfo.disallowUpdate();
        return null;
    }

    public NodeList getElementsByTagName(String tagname) {
        return DocumentOverNodeInfo.getElementsByTagName(this.node, tagname);
    }

    public Element getDocumentElement() {
        NodeInfo root2 = this.node.getRoot();
        if (root2 == null) {
            return null;
        }
        AxisIterator children = root2.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        return (Element)((Object)DocumentOverNodeInfo.wrap(children.next()));
    }

    protected static NodeList getElementsByTagName(NodeInfo node, String tagname) {
        NodeInfo next2;
        AxisIterator allElements = node.iterateAxis((byte)4);
        ArrayList<Node> nodes = new ArrayList<Node>(100);
        while ((next2 = allElements.next()) != null) {
            if (next2.getNodeKind() != 1 || !tagname.equals("*") && !tagname.equals(next2.getDisplayName())) continue;
            nodes.add(NodeOverNodeInfo.wrap(next2));
        }
        return new DOMNodeList(nodes);
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        DocumentOverNodeInfo.disallowUpdate();
        return null;
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        DocumentOverNodeInfo.disallowUpdate();
        return null;
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        DocumentOverNodeInfo.disallowUpdate();
        return null;
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return DocumentOverNodeInfo.getElementsByTagNameNS(this.node, namespaceURI, localName);
    }

    public static NodeList getElementsByTagNameNS(NodeInfo node, String namespaceURI, String localName) {
        NodeInfo next2;
        String ns = namespaceURI == null ? "" : namespaceURI;
        AxisIterator allElements = node.iterateAxis((byte)4);
        ArrayList<Node> nodes = new ArrayList<Node>(100);
        while ((next2 = allElements.next()) != null) {
            if (next2.getNodeKind() != 1 || !ns.equals("*") && !ns.equals(next2.getURI()) || !localName.equals("*") && !localName.equals(next2.getLocalPart())) continue;
            nodes.add(NodeOverNodeInfo.wrap(next2));
        }
        return new DOMNodeList(nodes);
    }

    public Element getElementById(String elementId) {
        TreeInfo doc = this.node.getTreeInfo();
        if (doc == null) {
            return null;
        }
        return (Element)((Object)DocumentOverNodeInfo.wrap(doc.selectID(elementId, false)));
    }

    public String getInputEncoding() {
        return null;
    }

    public String getXmlEncoding() {
        return null;
    }

    public boolean getXmlStandalone() {
        return false;
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        DocumentOverNodeInfo.disallowUpdate();
    }

    public String getXmlVersion() {
        return "1.0";
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
        DocumentOverNodeInfo.disallowUpdate();
    }

    public boolean getStrictErrorChecking() {
        return false;
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
    }

    public String getDocumentURI() {
        return this.node.getSystemId();
    }

    public void setDocumentURI(String documentURI) {
        DocumentOverNodeInfo.disallowUpdate();
    }

    public Node adoptNode(Node source) throws DOMException {
        DocumentOverNodeInfo.disallowUpdate();
        return null;
    }

    public DOMConfiguration getDomConfig() {
        return null;
    }

    public void normalizeDocument() {
        DocumentOverNodeInfo.disallowUpdate();
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        DocumentOverNodeInfo.disallowUpdate();
        return null;
    }
}

