/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.saxon.dom.DocumentOverNodeInfo;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Whitespace;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMWriter
extends Builder {
    private PipelineConfiguration pipe;
    private Node currentNode;
    private Document document;
    private Node nextSibling;
    private int level = 0;
    private boolean canNormalize = true;
    private String systemId;

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
        this.config = pipe.getConfiguration();
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void open() {
    }

    public void close() {
    }

    public void startDocument(int properties) throws XPathException {
        if (this.document == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                this.document = factory.newDocumentBuilder().newDocument();
                this.currentNode = this.document;
            }
            catch (ParserConfigurationException err2) {
                throw new XPathException(err2);
            }
        }
    }

    public void endDocument() throws XPathException {
    }

    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        String qname = nameCode.getDisplayName();
        String uri = nameCode.getURI();
        try {
            Element element = this.document.createElementNS("".equals(uri) ? null : uri, qname);
            if (this.nextSibling != null && this.level == 0) {
                this.currentNode.insertBefore(element, this.nextSibling);
            } else {
                this.currentNode.appendChild(element);
            }
            this.currentNode = element;
        }
        catch (DOMException err2) {
            throw new XPathException(err2);
        }
        ++this.level;
    }

    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        try {
            for (NamespaceBinding ns : namespaceBindings) {
                String prefix = ns.getPrefix();
                String uri = ns.getURI();
                Element element = (Element)this.currentNode;
                if (uri.equals("http://www.w3.org/XML/1998/namespace")) continue;
                if (prefix.isEmpty()) {
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", uri);
                    continue;
                }
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
            }
        }
        catch (DOMException err2) {
            throw new XPathException(err2);
        }
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value2, Location locationId, int properties) throws XPathException {
        String qname = nameCode.getDisplayName();
        String uri = nameCode.getURI();
        try {
            Element element = (Element)this.currentNode;
            element.setAttributeNS("".equals(uri) ? null : uri, qname, value2.toString());
            if (nameCode.equals(StandardNames.XML_ID_NAME) || (properties & 0x800) != 0 || nameCode.hasURI("http://www.w3.org/XML/1998/namespace") && nameCode.getLocalPart().equals("id")) {
                String localName = nameCode.getLocalPart();
                element.setIdAttributeNS("".equals(uri) ? null : uri, localName, true);
            }
        }
        catch (DOMException err2) {
            throw new XPathException(err2);
        }
    }

    public void startContent() throws XPathException {
    }

    public void endElement() throws XPathException {
        if (this.canNormalize) {
            try {
                this.currentNode.normalize();
            }
            catch (Throwable err2) {
                this.canNormalize = false;
            }
        }
        this.currentNode = this.currentNode.getParentNode();
        --this.level;
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.level == 0 && this.nextSibling == null && Whitespace.isWhite(chars)) {
            return;
        }
        try {
            Text text2 = this.document.createTextNode(chars.toString());
            if (this.nextSibling != null && this.level == 0) {
                this.currentNode.insertBefore(text2, this.nextSibling);
            } else {
                this.currentNode.appendChild(text2);
            }
        }
        catch (DOMException err2) {
            throw new XPathException(err2);
        }
    }

    public void processingInstruction(String target, CharSequence data2, Location locationId, int properties) throws XPathException {
        try {
            ProcessingInstruction pi = this.document.createProcessingInstruction(target, data2.toString());
            if (this.nextSibling != null && this.level == 0) {
                this.currentNode.insertBefore(pi, this.nextSibling);
            } else {
                this.currentNode.appendChild(pi);
            }
        }
        catch (DOMException err2) {
            throw new XPathException(err2);
        }
    }

    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        try {
            Comment comment2 = this.document.createComment(chars.toString());
            if (this.nextSibling != null && this.level == 0) {
                this.currentNode.insertBefore(comment2, this.nextSibling);
            } else {
                this.currentNode.appendChild(comment2);
            }
        }
        catch (DOMException err2) {
            throw new XPathException(err2);
        }
    }

    public boolean usesTypeAnnotations() {
        return false;
    }

    public void setNode(Node node) {
        if (node == null) {
            return;
        }
        this.currentNode = node;
        if (node.getNodeType() == 9) {
            this.document = (Document)node;
        } else {
            this.document = this.currentNode.getOwnerDocument();
            if (this.document == null) {
                this.document = new DocumentOverNodeInfo();
            }
        }
    }

    public void setNextSibling(Node nextSibling) {
        this.nextSibling = nextSibling;
    }

    public NodeInfo getCurrentRoot() {
        return new DocumentWrapper(this.document, this.systemId, this.config).getRootNode();
    }

    protected Document getDOMDocumentNode() {
        return this.document;
    }
}

