/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.util.ArrayList;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.dom.TextOverAttrInfo;
import net.sf.saxon.dom.TypeInfoImpl;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class AttrOverNodeInfo
extends NodeOverNodeInfo
implements Attr {
    public String getName() {
        if (this.node.getNodeKind() == 13) {
            String local = this.node.getLocalPart();
            if (local.equals("")) {
                return "xmlns";
            }
            return "xmlns:" + local;
        }
        return this.node.getDisplayName();
    }

    public String getValue() {
        return this.node.getStringValue();
    }

    public boolean hasChildNodes() {
        return true;
    }

    public Node getFirstChild() {
        return new TextOverAttrInfo(this);
    }

    public Node getLastChild() {
        return this.getFirstChild();
    }

    public NodeList getChildNodes() {
        ArrayList<Node> list2 = new ArrayList<Node>(1);
        list2.add(this.getFirstChild());
        return new DOMNodeList(list2);
    }

    public boolean getSpecified() {
        return true;
    }

    public void setValue(String value2) throws DOMException {
        AttrOverNodeInfo.disallowUpdate();
    }

    public boolean isId() {
        return this.node.isId();
    }

    public Element getOwnerElement() {
        if (this.node.getNodeKind() == 2 || this.node.getNodeKind() == 13) {
            return (Element)((Object)AttrOverNodeInfo.wrap(this.node.getParent()));
        }
        throw new UnsupportedOperationException("This method is defined only on attribute and namespace nodes");
    }

    public TypeInfo getSchemaTypeInfo() {
        SchemaType type = this.node.getSchemaType();
        if (type == null || BuiltInAtomicType.UNTYPED_ATOMIC.equals(type)) {
            return null;
        }
        return new TypeInfoImpl(this.node.getConfiguration(), type);
    }
}

