/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.io;

import eu.europeana.cloud.mcs.driver.RevisionServiceClient;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.dps.storm.io.RevisionWriterBolt;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.net.MalformedURLException;

public class ValidationRevisionWriter
extends RevisionWriterBolt {
    private String successNotificationMessage;

    public ValidationRevisionWriter(String ecloudMcsAddress, String successNotificationMessage) {
        super(ecloudMcsAddress);
        this.successNotificationMessage = successNotificationMessage;
    }

    @Override
    protected void addRevisionAndEmit(StormTaskTuple stormTaskTuple, RevisionServiceClient revisionsClient) {
        LOGGER.info("{} executed", (Object)((Object)((Object)this)).getClass().getSimpleName());
        try {
            this.addRevisionToSpecificResource(stormTaskTuple, revisionsClient, stormTaskTuple.getFileUrl());
            this.emitSuccessNotification(stormTaskTuple.getTaskId(), stormTaskTuple.getFileUrl(), this.successNotificationMessage, "", "");
        }
        catch (MalformedURLException e) {
            LOGGER.error("URL is malformed: {}", (Object)stormTaskTuple.getParameter("DPS_TASK_INPUT_DATA"));
            this.emitErrorNotification(stormTaskTuple.getTaskId(), null, e.getMessage(), stormTaskTuple.getParameters().toString());
        }
        catch (DriverException | MCSException e) {
            LOGGER.warn("Error while communicating with MCS {}", (Object)e.getMessage());
            this.emitErrorNotification(stormTaskTuple.getTaskId(), null, e.getMessage(), stormTaskTuple.getParameters().toString());
        }
    }
}

