/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.io;

import eu.europeana.cloud.common.model.Revision;
import eu.europeana.cloud.mcs.driver.RevisionServiceClient;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.commons.urls.UrlParser;
import eu.europeana.cloud.service.commons.urls.UrlPart;
import eu.europeana.cloud.service.dps.storm.AbstractDpsBolt;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevisionWriterBolt
extends AbstractDpsBolt {
    public static final Logger LOGGER = LoggerFactory.getLogger(RevisionWriterBolt.class);
    private String ecloudMcsAddress;

    public RevisionWriterBolt(String ecloudMcsAddress) {
        this.ecloudMcsAddress = ecloudMcsAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(StormTaskTuple stormTaskTuple) {
        try (RevisionServiceClient revisionsClient = new RevisionServiceClient(this.ecloudMcsAddress);){
            String authorizationHeader = stormTaskTuple.getParameter("AUTHORIZATION_HEADER");
            revisionsClient.useAuthorizationHeader(authorizationHeader);
            this.addRevisionAndEmit(stormTaskTuple, revisionsClient);
        }
    }

    protected void addRevisionAndEmit(StormTaskTuple stormTaskTuple, RevisionServiceClient revisionsClient) {
        LOGGER.info("{} executed", (Object)((Object)((Object)this)).getClass().getSimpleName());
        try {
            this.addRevisionToSpecificResource(stormTaskTuple, revisionsClient, stormTaskTuple.getParameter("OUTPUT_URL"));
            this.outputCollector.emit((List)stormTaskTuple.toStormTuple());
        }
        catch (MalformedURLException e) {
            LOGGER.error("URL is malformed: {} ", (Object)stormTaskTuple.getParameter("OUTPUT_URL"));
            this.emitErrorNotification(stormTaskTuple.getTaskId(), null, e.getMessage(), stormTaskTuple.getParameters().toString());
        }
        catch (DriverException | MCSException e) {
            LOGGER.warn("Error while communicating with MCS {}", (Object)e.getMessage());
            this.emitErrorNotification(stormTaskTuple.getTaskId(), null, e.getMessage(), stormTaskTuple.getParameters().toString());
        }
    }

    protected void addRevisionToSpecificResource(StormTaskTuple stormTaskTuple, RevisionServiceClient revisionsClient, String affectedResourceURL) throws MalformedURLException, MCSException {
        if (stormTaskTuple.hasRevisionToBeApplied()) {
            LOGGER.info("Adding revisions to representation version: {}", (Object)stormTaskTuple.getFileUrl());
            UrlParser urlParser = new UrlParser(affectedResourceURL);
            Revision revisionToBeApplied = stormTaskTuple.getRevisionToBeApplied();
            if (revisionToBeApplied.getCreationTimeStamp() == null) {
                revisionToBeApplied.setCreationTimeStamp(new Date());
            }
            this.addRevision(revisionsClient, urlParser, revisionToBeApplied);
            stormTaskTuple.setRevisionToBeApplied(null);
        } else {
            LOGGER.info("Revisions list is empty");
        }
    }

    private void addRevision(RevisionServiceClient revisionsClient, UrlParser urlParser, Revision revisionToBeApplied) throws MCSException, DriverException {
        int retries = 10;
        while (true) {
            try {
                revisionsClient.addRevision(urlParser.getPart(UrlPart.RECORDS), urlParser.getPart(UrlPart.REPRESENTATIONS), urlParser.getPart(UrlPart.VERSIONS), revisionToBeApplied);
            }
            catch (Exception e) {
                if (retries-- > 0) {
                    LOGGER.warn("Error while adding Revisions. Retries left {}", (Object)retries);
                    this.waitForSpecificTime();
                    continue;
                }
                LOGGER.error("Error while getting Revisions from data set.");
                throw e;
            }
            break;
        }
    }

    @Override
    public void prepare() {
    }
}

