/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.io;

import eu.europeana.cloud.client.uis.rest.CloudException;
import eu.europeana.cloud.client.uis.rest.UISClient;
import eu.europeana.cloud.common.exceptions.ProviderDoesNotExistException;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.mcs.driver.RecordServiceClient;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.dps.PluginParameterKeys;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.dps.storm.io.WriteRecordBolt;
import eu.europeana.cloud.service.dps.storm.utils.TaskTupleUtility;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import eu.europeana.cloud.service.uis.exception.IdHasBeenMappedException;
import eu.europeana.cloud.service.uis.exception.RecordDoesNotExistException;
import java.io.IOException;
import java.net.URI;
import org.slf4j.LoggerFactory;

public class HarvestingWriteRecordBolt
extends WriteRecordBolt {
    private String ecloudUisAddress;

    public HarvestingWriteRecordBolt(String ecloudMcsAddress, String ecloudUisAddress) {
        super(ecloudMcsAddress);
        this.ecloudUisAddress = ecloudUisAddress;
        this.LOGGER = LoggerFactory.getLogger(HarvestingWriteRecordBolt.class);
    }

    @Override
    protected URI createRepresentationAndUploadFile(StormTaskTuple stormTaskTuple, RecordServiceClient recordServiceClient) throws IOException, MCSException, CloudException, DriverException {
        String providerId = stormTaskTuple.getParameter("PROVIDER_ID");
        String localId = stormTaskTuple.getParameter("CLOUD_LOCAL_IDENTIFIER");
        String additionalLocalIdentifier = stormTaskTuple.getParameter("ADDITIONAL_LOCAL_IDENTIFIER");
        String cloudId = this.getCloudId(stormTaskTuple.getParameter("AUTHORIZATION_HEADER"), providerId, localId, additionalLocalIdentifier);
        String representationName = stormTaskTuple.getParameter("NEW_REPRESENTATION_NAME");
        if ((representationName == null || representationName.isEmpty()) && stormTaskTuple.getSourceDetails() != null && (representationName = stormTaskTuple.getParameter("SCHEMA_NAME")) == null) {
            representationName = PluginParameterKeys.PLUGIN_PARAMETERS.get("NEW_REPRESENTATION_NAME");
        }
        return this.createRepresentation(stormTaskTuple, recordServiceClient, providerId, cloudId, representationName);
    }

    private URI createRepresentation(StormTaskTuple stormTaskTuple, RecordServiceClient recordServiceClient, String providerId, String cloudId, String representationName) throws IOException, MCSException, DriverException {
        int retries = 10;
        while (true) {
            try {
                return recordServiceClient.createRepresentation(cloudId, representationName, providerId, stormTaskTuple.getFileByteDataAsStream(), stormTaskTuple.getParameter("OUTPUT_FILE_NAME"), TaskTupleUtility.getParameterFromTuple(stormTaskTuple, "OUTPUT_MIME_TYPE"));
            }
            catch (Exception e) {
                if (e.getCause() instanceof ProviderDoesNotExistException) {
                    this.LOGGER.error("Error while creating Representation.");
                    throw e;
                }
                if (retries-- > 0) {
                    this.LOGGER.warn("Error while creating Representation. Retries left: {} ", (Object)retries);
                    this.waitForSpecificTime();
                    continue;
                }
                this.LOGGER.error("Error while creating Representation.");
                throw e;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCloudId(String authorizationHeader, String providerId, String localId, String additionalLocalIdentifier) throws CloudException {
        uisClient.useAuthorizationHeader(authorizationHeader);
        try (UISClient uisClient = new UISClient(this.ecloudUisAddress);){
            CloudId cloudId = this.getCloudId(providerId, localId, uisClient);
            String result2 = cloudId != null ? cloudId.getId() : this.createCloudId(providerId, localId, uisClient);
            if (additionalLocalIdentifier != null) {
                this.attachAdditionalLocalIdentifier(additionalLocalIdentifier, result2, providerId, uisClient);
            }
            String string2 = result2;
            return string2;
        }
    }

    private boolean attachAdditionalLocalIdentifier(String additionalLocalIdentifier, String cloudId, String providerId, UISClient uisClient) throws CloudException {
        int retries = 10;
        while (true) {
            try {
                return uisClient.createMapping(cloudId, providerId, additionalLocalIdentifier);
            }
            catch (CloudException e) {
                if (e.getCause() instanceof IdHasBeenMappedException) {
                    return true;
                }
                if (e.getCause() instanceof ProviderDoesNotExistException) {
                    this.LOGGER.error("Error while mapping localId to cloudId.");
                    throw e;
                }
                if (retries-- > 0) {
                    this.LOGGER.warn("Error while mapping localId to cloudId. Retries left: {} ", (Object)retries);
                    this.waitForSpecificTime();
                    continue;
                }
                this.LOGGER.error("Error while creating CloudId.");
                throw e;
            }
            break;
        }
    }

    private CloudId getCloudId(String providerId, String localId, UISClient uisClient) throws CloudException {
        int retries = 10;
        while (true) {
            try {
                return uisClient.getCloudId(providerId, localId);
            }
            catch (CloudException e) {
                if (e.getCause() instanceof RecordDoesNotExistException) {
                    return null;
                }
                if (e.getCause() instanceof ProviderDoesNotExistException) {
                    this.LOGGER.error("Error while getting CloudId.");
                    throw e;
                }
                if (retries-- > 0) {
                    this.LOGGER.warn("Error while getting CloudId. Retries left: {}", (Object)retries);
                    this.waitForSpecificTime();
                    continue;
                }
                this.LOGGER.error("Error while getting CloudId.");
                throw e;
            }
            break;
        }
    }

    private String createCloudId(String providerId, String localId, UISClient uisClient) throws CloudException {
        int retries = 10;
        while (true) {
            try {
                return uisClient.createCloudId(providerId, localId).getId();
            }
            catch (CloudException e) {
                if (e.getCause() instanceof ProviderDoesNotExistException) {
                    this.LOGGER.error("Error while creating CloudId.");
                    throw e;
                }
                if (retries-- > 0) {
                    this.LOGGER.warn("Error while creating CloudId. Retries left: {} ", (Object)retries);
                    this.waitForSpecificTime();
                    continue;
                }
                this.LOGGER.error("Error while creating CloudId.");
                throw e;
            }
            break;
        }
    }
}

