/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.common.filter.ECloudBasicAuthFilter;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.mcs.driver.MCSClient;
import eu.europeana.cloud.mcs.driver.MCSExceptionProvider;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.mcs.exception.CannotModifyPersistentRepresentationException;
import eu.europeana.cloud.service.mcs.exception.FileNotExistsException;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.exception.WrongContentRangeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileServiceClient
extends MCSClient {
    private final Client client;
    private static final Logger logger = LoggerFactory.getLogger(FileServiceClient.class);
    private static final String filesPath = "records/{CLOUDID}/representations/{REPRESENTATIONNAME}/versions/{VERSION}/files";
    private static final String filePath = "records/{CLOUDID}/representations/{REPRESENTATIONNAME}/versions/{VERSION}/files/{FILENAME}";

    public FileServiceClient(String baseUrl) {
        super(baseUrl);
        this.client = (Client)JerseyClientBuilder.newClient().register(MultiPartFeature.class);
    }

    public FileServiceClient(String baseUrl, String username, String password) {
        super(baseUrl);
        this.client = (Client)((Client)JerseyClientBuilder.newClient().register(MultiPartFeature.class)).register(HttpAuthenticationFeature.basicBuilder().credentials(username, password).build());
    }

    public InputStream getFile(String cloudId, String representationName, String version, String fileName) throws RepresentationNotExistsException, FileNotExistsException, DriverException, MCSException, IOException {
        WebTarget target = this.client.target(this.baseUrl).path(filePath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version).resolveTemplate("FILENAME", fileName);
        Invocation.Builder requset = target.request();
        Response response = null;
        try {
            response = requset.get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                InputStream contentResponse = response.readEntity(InputStream.class);
                InputStream inputStream = this.copiedInputStream(contentResponse);
                return inputStream;
            }
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        finally {
            this.closeResponse(response);
        }
    }

    public InputStream getFile(String cloudId, String representationName, String version, String fileName, String range2) throws RepresentationNotExistsException, FileNotExistsException, WrongContentRangeException, DriverException, MCSException, IOException {
        WebTarget target = this.client.target(this.baseUrl).path(filePath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version).resolveTemplate("FILENAME", fileName);
        Invocation.Builder request = target.request().header("Range", range2);
        Response response = null;
        try {
            response = request.get();
            if (response.getStatus() == Response.Status.PARTIAL_CONTENT.getStatusCode()) {
                InputStream contentResponse = response.readEntity(InputStream.class);
                InputStream inputStream = this.copiedInputStream(contentResponse);
                return inputStream;
            }
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        finally {
            this.closeResponse(response);
        }
    }

    public InputStream getFile(String fileUrl) throws RepresentationNotExistsException, FileNotExistsException, WrongContentRangeException, DriverException, MCSException, IOException {
        Response response;
        block3: {
            response = null;
            try {
                response = this.client.target(fileUrl).request().get();
                if (response.getStatus() != Response.Status.OK.getStatusCode()) break block3;
                InputStream contentResponse = response.readEntity(InputStream.class);
                InputStream inputStream = this.copiedInputStream(contentResponse);
                this.closeResponse(response);
                return inputStream;
            }
            catch (Throwable throwable) {
                this.closeResponse(response);
                throw throwable;
            }
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI uploadFile(String cloudId, String representationName, String version, InputStream data2, String mediaType, String expectedMd5) throws IOException, RepresentationNotExistsException, CannotModifyPersistentRepresentationException, DriverException, MCSException {
        URI uRI;
        Response response = null;
        FormDataMultiPart multipart = new FormDataMultiPart();
        try {
            WebTarget target = this.client.target(this.baseUrl).path(filesPath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version);
            multipart.field("mimeType", mediaType).field("data", data2, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            Invocation.Builder request = target.request();
            response = request.post(Entity.entity(multipart, multipart.getMediaType()));
            uRI = this.handleResponse(expectedMd5, response, Response.Status.CREATED.getStatusCode());
        }
        catch (Throwable throwable) {
            this.closeOpenResources(data2, multipart, response);
            throw throwable;
        }
        this.closeOpenResources(data2, multipart, response);
        return uRI;
    }

    private URI handleResponse(String expectedMd5, Response response, int expectedStatusCode) throws IOException, MCSException {
        if (response.getStatus() == expectedStatusCode) {
            if (!expectedMd5.equals(response.getEntityTag().getValue())) {
                throw new IOException("Incorrect MD5 checksum");
            }
            return response.getLocation();
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI uploadFile(String cloudId, String representationName, String version, InputStream data2, String mediaType) throws IOException, RepresentationNotExistsException, CannotModifyPersistentRepresentationException, DriverException, MCSException {
        Response response;
        block3: {
            URI uRI;
            response = null;
            FormDataMultiPart multipart = new FormDataMultiPart();
            try {
                WebTarget target = this.client.target(this.baseUrl).path(filesPath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version);
                multipart.field("mimeType", mediaType).field("data", data2, MediaType.APPLICATION_OCTET_STREAM_TYPE);
                Invocation.Builder request = target.request();
                response = request.post(Entity.entity(multipart, multipart.getMediaType()));
                if (response.getStatus() != Response.Status.CREATED.getStatusCode()) break block3;
                uRI = response.getLocation();
            }
            catch (Throwable throwable) {
                this.closeOpenResources(data2, multipart, response);
                throw throwable;
            }
            this.closeOpenResources(data2, multipart, response);
            return uRI;
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI uploadFile(String cloudId, String representationName, String version, String fileName, InputStream data2, String mediaType) throws IOException, RepresentationNotExistsException, CannotModifyPersistentRepresentationException, DriverException, MCSException {
        Response response;
        block3: {
            URI uRI;
            response = null;
            FormDataMultiPart multipart = new FormDataMultiPart();
            try {
                WebTarget target = this.client.target(this.baseUrl).path(filesPath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version);
                multipart.field("mimeType", mediaType).field("data", data2, MediaType.APPLICATION_OCTET_STREAM_TYPE).field("fileName", fileName);
                Invocation.Builder request = target.request();
                response = request.post(Entity.entity(multipart, multipart.getMediaType()));
                if (response.getStatus() != Response.Status.CREATED.getStatusCode()) break block3;
                uRI = response.getLocation();
            }
            catch (Throwable throwable) {
                this.closeOpenResources(data2, multipart, response);
                throw throwable;
            }
            this.closeOpenResources(data2, multipart, response);
            return uRI;
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI uploadFile(String versionUrl, InputStream data2, String mediaType) throws IOException, RepresentationNotExistsException, CannotModifyPersistentRepresentationException, DriverException, MCSException {
        Response response;
        block3: {
            URI uRI;
            String filesPath = "/files";
            response = null;
            FormDataMultiPart multipart = new FormDataMultiPart();
            try {
                multipart.field("mimeType", mediaType).field("data", data2, MediaType.APPLICATION_OCTET_STREAM_TYPE);
                response = this.client.target(versionUrl + filesPath).request().post(Entity.entity(multipart, multipart.getMediaType()));
                if (response.getStatus() != Response.Status.CREATED.getStatusCode()) break block3;
                uRI = response.getLocation();
            }
            catch (Throwable throwable) {
                this.closeOpenResources(data2, multipart, response);
                throw throwable;
            }
            this.closeOpenResources(data2, multipart, response);
            return uRI;
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI modyfiyFile(String cloudId, String representationName, String version, InputStream data2, String mediaType, String fileName, String expectedMd5) throws IOException, RepresentationNotExistsException, CannotModifyPersistentRepresentationException, DriverException, MCSException {
        URI uRI;
        Response response = null;
        FormDataMultiPart multipart = new FormDataMultiPart();
        try {
            WebTarget target = this.client.target(this.baseUrl).path(filePath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version).resolveTemplate("FILENAME", fileName);
            multipart.field("mimeType", mediaType).field("data", data2, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            response = target.request().put(Entity.entity(multipart, multipart.getMediaType()));
            uRI = this.handleResponse(expectedMd5, response, Response.Status.NO_CONTENT.getStatusCode());
        }
        catch (Throwable throwable) {
            this.closeOpenResources(data2, multipart, response);
            throw throwable;
        }
        this.closeOpenResources(data2, multipart, response);
        return uRI;
    }

    public URI modifyFile(String fileUrl, InputStream data2, String mediaType) throws IOException, RepresentationNotExistsException, CannotModifyPersistentRepresentationException, DriverException, MCSException {
        Response response;
        block3: {
            URI uRI;
            WebTarget target = this.client.target(fileUrl);
            FormDataMultiPart multipart = new FormDataMultiPart();
            response = null;
            try {
                multipart.field("mimeType", mediaType).field("data", data2, MediaType.APPLICATION_OCTET_STREAM_TYPE);
                response = target.request().put(Entity.entity(multipart, multipart.getMediaType()));
                if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) break block3;
                uRI = response.getLocation();
            }
            catch (Throwable throwable) {
                this.closeOpenResources(data2, multipart, response);
                throw throwable;
            }
            this.closeOpenResources(data2, multipart, response);
            return uRI;
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    private void closeOpenResources(InputStream data2, FormDataMultiPart multipart, Response response) throws IOException {
        this.closeResponse(response);
        IOUtils.closeQuietly(data2);
        multipart.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(String cloudId, String representationName, String version, String fileName) throws RepresentationNotExistsException, FileNotExistsException, CannotModifyPersistentRepresentationException, DriverException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(filePath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version).resolveTemplate("FILENAME", fileName);
        Response response = null;
        try {
            response = target.request().delete();
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
                throw MCSExceptionProvider.generateException(errorInfo);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    public URI getFileUri(String cloudId, String representationName, String version, String fileName) {
        WebTarget target = this.client.target(this.baseUrl).path(filePath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version).resolveTemplate("FILENAME", fileName);
        return target.getUri();
    }

    public static Map<String, String> parseFileUri(String uri) {
        Pattern p = Pattern.compile(".*/records/([^/]+)/representations/([^/]+)/versions/([^/]+)/files/(.*)");
        Matcher m = p.matcher(uri);
        if (m.find()) {
            HashMap<String, String> ret = new HashMap<String, String>();
            ret.put("CLOUDID", m.group(1));
            ret.put("REPRESENTATIONNAME", m.group(2));
            ret.put("VERSION", m.group(3));
            ret.put("FILENAME", m.group(4));
            return ret;
        }
        return null;
    }

    public void useAuthorizationHeader(String headerValue) {
        this.client.register(new ECloudBasicAuthFilter(headerValue));
    }

    private InputStream copiedInputStream(InputStream originIS) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data2 = new byte[16384];
        while ((nRead = originIS.read(data2, 0, data2.length)) != -1) {
            buffer.write(data2, 0, nRead);
        }
        buffer.flush();
        IOUtils.closeQuietly(originIS);
        return new ByteArrayInputStream(buffer.toByteArray());
    }

    private void closeResponse(Response response) {
        if (response != null) {
            response.close();
        }
    }

    protected void finalize() throws Throwable {
        this.client.close();
    }

    public void close() {
        this.client.close();
    }
}

