/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.io;

import eu.europeana.cloud.common.model.Revision;
import eu.europeana.cloud.mcs.driver.RevisionServiceClient;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.commons.urls.UrlParser;
import eu.europeana.cloud.service.commons.urls.UrlPart;
import eu.europeana.cloud.service.dps.storm.AbstractDpsBolt;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevisionWriterBolt
extends AbstractDpsBolt {
    private static final long serialVersionUID = 1L;
    public static final Logger LOGGER = LoggerFactory.getLogger(RevisionWriterBolt.class);
    protected RevisionServiceClient revisionsClient;
    private String ecloudMcsAddress;

    public RevisionWriterBolt(String ecloudMcsAddress) {
        this.ecloudMcsAddress = ecloudMcsAddress;
    }

    public void execute(StormTaskTuple stormTaskTuple) {
        this.addRevisionAndEmit(stormTaskTuple);
    }

    protected void addRevisionAndEmit(StormTaskTuple stormTaskTuple) {
        LOGGER.info("{} executed", (Object)((Object)((Object)this)).getClass().getSimpleName());
        try {
            this.addRevisionToSpecificResource(stormTaskTuple, stormTaskTuple.getParameter("OUTPUT_URL"));
            this.outputCollector.emit((List)stormTaskTuple.toStormTuple());
        }
        catch (MalformedURLException e) {
            LOGGER.error("URL is malformed: {} ", (Object)stormTaskTuple.getParameter("OUTPUT_URL"));
            this.emitErrorNotification(stormTaskTuple.getTaskId(), null, e.getMessage(), "The cause of the error is:" + e.getCause());
        }
        catch (DriverException | MCSException e) {
            LOGGER.warn("Error while communicating with MCS {}", (Object)e.getMessage());
            this.emitErrorNotification(stormTaskTuple.getTaskId(), null, e.getMessage(), "The cause of the error is:" + e.getCause());
        }
    }

    protected void addRevisionToSpecificResource(StormTaskTuple stormTaskTuple, String affectedResourceURL) throws MalformedURLException, MCSException {
        if (stormTaskTuple.hasRevisionToBeApplied()) {
            LOGGER.info("Adding revisions to representation version: {}", (Object)stormTaskTuple.getFileUrl());
            UrlParser urlParser = new UrlParser(affectedResourceURL);
            Revision revisionToBeApplied = stormTaskTuple.getRevisionToBeApplied();
            if (revisionToBeApplied.getCreationTimeStamp() == null) {
                revisionToBeApplied.setCreationTimeStamp(new Date());
            }
            this.addRevision(urlParser, revisionToBeApplied, stormTaskTuple.getParameter("AUTHORIZATION_HEADER"));
            stormTaskTuple.setRevisionToBeApplied(null);
        } else {
            LOGGER.info("Revisions list is empty");
        }
    }

    private void addRevision(UrlParser urlParser, Revision revisionToBeApplied, String authenticationHeader) throws MCSException, DriverException {
        int retries = 3;
        while (true) {
            try {
                this.revisionsClient.addRevision(urlParser.getPart(UrlPart.RECORDS), urlParser.getPart(UrlPart.REPRESENTATIONS), urlParser.getPart(UrlPart.VERSIONS), revisionToBeApplied, "Authorization", authenticationHeader);
            }
            catch (Exception e) {
                if (retries-- > 0) {
                    LOGGER.warn("Error while adding Revisions. Retries left {}", (Object)retries);
                    this.waitForSpecificTime();
                    continue;
                }
                LOGGER.error("Error while getting Revisions from data set.");
                throw e;
            }
            break;
        }
    }

    public void prepare() {
        this.revisionsClient = new RevisionServiceClient(this.ecloudMcsAddress);
    }
}

