/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlPathHelper {
    private static final String WEBSPHERE_URI_ATTRIBUTE = "com.ibm.websphere.servlet.uri_non_decoded";
    private static final Log logger = LogFactory.getLog(UrlPathHelper.class);
    static volatile Boolean websphereComplianceFlag;
    private boolean alwaysUseFullPath = false;
    private boolean urlDecode = true;
    private boolean removeSemicolonContent = true;
    private String defaultEncoding = "ISO-8859-1";

    public void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
        this.alwaysUseFullPath = alwaysUseFullPath;
    }

    public void setUrlDecode(boolean urlDecode) {
        this.urlDecode = urlDecode;
    }

    public void setRemoveSemicolonContent(boolean removeSemicolonContent) {
        this.removeSemicolonContent = removeSemicolonContent;
    }

    public boolean shouldRemoveSemicolonContent() {
        return this.removeSemicolonContent;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    protected String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getLookupPathForRequest(HttpServletRequest request) {
        if (this.alwaysUseFullPath) {
            return this.getPathWithinApplication(request);
        }
        String rest = this.getPathWithinServletMapping(request);
        if (!"".equals(rest)) {
            return rest;
        }
        return this.getPathWithinApplication(request);
    }

    public String getPathWithinServletMapping(HttpServletRequest request) {
        String servletPath;
        String pathWithinApp = this.getPathWithinApplication(request);
        String path = this.getRemainingPath(pathWithinApp, servletPath = this.getServletPath(request), false);
        if (path != null) {
            return path;
        }
        String pathInfo = request.getPathInfo();
        return pathInfo != null ? pathInfo : servletPath;
    }

    public String getPathWithinApplication(HttpServletRequest request) {
        String contextPath = this.getContextPath(request);
        String requestUri = this.getRequestUri(request);
        String path = this.getRemainingPath(requestUri, contextPath, true);
        if (path != null) {
            return StringUtils.hasText(path) ? path : "/";
        }
        return requestUri;
    }

    private String getRemainingPath(String requestUri, String mapping, boolean ignoreCase) {
        int index2;
        int index1 = 0;
        for (index2 = 0; index1 < requestUri.length() && index2 < mapping.length(); ++index1, ++index2) {
            char c1 = requestUri.charAt(index1);
            char c2 = mapping.charAt(index2);
            if (c1 == ';') {
                if ((index1 = requestUri.indexOf(47, index1)) == -1) {
                    return null;
                }
                c1 = requestUri.charAt(index1);
            }
            if (c1 == c2 || ignoreCase && Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return null;
        }
        if (index2 != mapping.length()) {
            return null;
        }
        if (index1 == requestUri.length()) {
            return "";
        }
        if (requestUri.charAt(index1) == ';') {
            index1 = requestUri.indexOf(47, index1);
        }
        return index1 != -1 ? requestUri.substring(index1) : "";
    }

    public String getRequestUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.request_uri");
        if (uri == null) {
            uri = request.getRequestURI();
        }
        return this.decodeAndCleanUriString(request, uri);
    }

    public String getContextPath(HttpServletRequest request) {
        String contextPath = (String)request.getAttribute("javax.servlet.include.context_path");
        if (contextPath == null) {
            contextPath = request.getContextPath();
        }
        if ("/".equals(contextPath)) {
            contextPath = "";
        }
        return this.decodeRequestString(request, contextPath);
    }

    public String getServletPath(HttpServletRequest request) {
        String servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = request.getServletPath();
        }
        if (servletPath.length() > 1 && servletPath.endsWith("/") && this.shouldRemoveTrailingServletPathSlash(request)) {
            servletPath = servletPath.substring(0, servletPath.length() - 1);
        }
        return servletPath;
    }

    public String getOriginatingRequestUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute(WEBSPHERE_URI_ATTRIBUTE);
        if (uri == null && (uri = (String)request.getAttribute("javax.servlet.forward.request_uri")) == null) {
            uri = request.getRequestURI();
        }
        return this.decodeAndCleanUriString(request, uri);
    }

    public String getOriginatingContextPath(HttpServletRequest request) {
        String contextPath = (String)request.getAttribute("javax.servlet.forward.context_path");
        if (contextPath == null) {
            contextPath = request.getContextPath();
        }
        return this.decodeRequestString(request, contextPath);
    }

    public String getOriginatingServletPath(HttpServletRequest request) {
        String servletPath = (String)request.getAttribute("javax.servlet.forward.servlet_path");
        if (servletPath == null) {
            servletPath = request.getServletPath();
        }
        return servletPath;
    }

    public String getOriginatingQueryString(HttpServletRequest request) {
        if (request.getAttribute("javax.servlet.forward.request_uri") != null || request.getAttribute("javax.servlet.error.request_uri") != null) {
            return (String)request.getAttribute("javax.servlet.forward.query_string");
        }
        return request.getQueryString();
    }

    private String decodeAndCleanUriString(HttpServletRequest request, String uri) {
        uri = this.removeSemicolonContent(uri);
        uri = this.decodeRequestString(request, uri);
        return uri;
    }

    public String decodeRequestString(HttpServletRequest request, String source) {
        if (this.urlDecode) {
            return this.decodeInternal(request, source);
        }
        return source;
    }

    private String decodeInternal(HttpServletRequest request, String source) {
        String enc = this.determineEncoding(request);
        try {
            return UriUtils.decode(source, enc);
        }
        catch (UnsupportedEncodingException ex) {
            if (logger.isWarnEnabled()) {
                logger.warn("Could not decode request string [" + source + "] with encoding '" + enc + "': falling back to platform default encoding; exception message: " + ex.getMessage());
            }
            return URLDecoder.decode(source);
        }
    }

    protected String determineEncoding(HttpServletRequest request) {
        String enc = request.getCharacterEncoding();
        if (enc == null) {
            enc = this.getDefaultEncoding();
        }
        return enc;
    }

    public String removeSemicolonContent(String requestUri) {
        return this.removeSemicolonContent ? this.removeSemicolonContentInternal(requestUri) : this.removeJsessionid(requestUri);
    }

    private String removeSemicolonContentInternal(String requestUri) {
        int semicolonIndex = requestUri.indexOf(59);
        while (semicolonIndex != -1) {
            int slashIndex = requestUri.indexOf(47, semicolonIndex);
            String start = requestUri.substring(0, semicolonIndex);
            requestUri = slashIndex != -1 ? start + requestUri.substring(slashIndex) : start;
            semicolonIndex = requestUri.indexOf(59, semicolonIndex);
        }
        return requestUri;
    }

    private String removeJsessionid(String requestUri) {
        int startIndex = requestUri.toLowerCase().indexOf(";jsessionid=");
        if (startIndex != -1) {
            int endIndex = requestUri.indexOf(59, startIndex + 12);
            String start = requestUri.substring(0, startIndex);
            requestUri = endIndex != -1 ? start + requestUri.substring(endIndex) : start;
        }
        return requestUri;
    }

    public Map<String, String> decodePathVariables(HttpServletRequest request, Map<String, String> vars) {
        if (this.urlDecode) {
            return vars;
        }
        LinkedHashMap<String, String> decodedVars = new LinkedHashMap<String, String>(vars.size());
        for (Map.Entry<String, String> entry2 : vars.entrySet()) {
            decodedVars.put(entry2.getKey(), this.decodeInternal(request, entry2.getValue()));
        }
        return decodedVars;
    }

    public MultiValueMap<String, String> decodeMatrixVariables(HttpServletRequest request, MultiValueMap<String, String> vars) {
        if (this.urlDecode) {
            return vars;
        }
        LinkedMultiValueMap<String, String> decodedVars = new LinkedMultiValueMap<String, String>(vars.size());
        for (String key : vars.keySet()) {
            for (String value2 : (List)vars.get(key)) {
                decodedVars.add(key, this.decodeInternal(request, value2));
            }
        }
        return decodedVars;
    }

    private boolean shouldRemoveTrailingServletPathSlash(HttpServletRequest request) {
        if (request.getAttribute(WEBSPHERE_URI_ATTRIBUTE) == null) {
            return false;
        }
        if (websphereComplianceFlag == null) {
            boolean flag;
            block4: {
                ClassLoader classLoader = UrlPathHelper.class.getClassLoader();
                String className = "com.ibm.ws.webcontainer.WebContainer";
                String methodName = "getWebContainerProperties";
                String propName = "com.ibm.ws.webcontainer.removetrailingservletpathslash";
                flag = false;
                try {
                    Class<?> cl = classLoader.loadClass(className);
                    Properties prop = (Properties)cl.getMethod(methodName, new Class[0]).invoke(null, new Object[0]);
                    flag = Boolean.parseBoolean(prop.getProperty(propName));
                }
                catch (Throwable ex) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug("Could not introspect WebSphere web container properties: " + ex);
                }
            }
            websphereComplianceFlag = flag;
        }
        return websphereComplianceFlag == false;
    }
}

