/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.namedparam;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.namedparam.AbstractSqlParameterSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapSqlParameterSource
extends AbstractSqlParameterSource {
    private final Map<String, Object> values = new HashMap<String, Object>();

    public MapSqlParameterSource() {
    }

    public MapSqlParameterSource(String paramName, Object value2) {
        this.addValue(paramName, value2);
    }

    public MapSqlParameterSource(Map<String, ?> values) {
        this.addValues(values);
    }

    public MapSqlParameterSource addValue(String paramName, Object value2) {
        Assert.notNull(paramName, "Parameter name must not be null");
        this.values.put(paramName, value2);
        if (value2 instanceof SqlParameterValue) {
            this.registerSqlType(paramName, ((SqlParameterValue)value2).getSqlType());
        }
        return this;
    }

    public MapSqlParameterSource addValue(String paramName, Object value2, int sqlType) {
        Assert.notNull(paramName, "Parameter name must not be null");
        this.values.put(paramName, value2);
        this.registerSqlType(paramName, sqlType);
        return this;
    }

    public MapSqlParameterSource addValue(String paramName, Object value2, int sqlType, String typeName) {
        Assert.notNull(paramName, "Parameter name must not be null");
        this.values.put(paramName, value2);
        this.registerSqlType(paramName, sqlType);
        this.registerTypeName(paramName, typeName);
        return this;
    }

    public MapSqlParameterSource addValues(Map<String, ?> values) {
        if (values != null) {
            for (Map.Entry<String, ?> entry2 : values.entrySet()) {
                this.values.put(entry2.getKey(), entry2.getValue());
                if (!(entry2.getValue() instanceof SqlParameterValue)) continue;
                SqlParameterValue value2 = (SqlParameterValue)entry2.getValue();
                this.registerSqlType(entry2.getKey(), value2.getSqlType());
            }
        }
        return this;
    }

    public Map<String, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    @Override
    public boolean hasValue(String paramName) {
        return this.values.containsKey(paramName);
    }

    @Override
    public Object getValue(String paramName) {
        if (!this.hasValue(paramName)) {
            throw new IllegalArgumentException("No value registered for key '" + paramName + "'");
        }
        return this.values.get(paramName);
    }
}

