/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.ast.Literal;
import org.springframework.expression.spel.ast.SpelNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlineList
extends SpelNodeImpl {
    TypedValue constant = null;

    public InlineList(int pos, SpelNodeImpl ... args) {
        super(pos, args);
        this.checkIfConstant();
    }

    private void checkIfConstant() {
        boolean isConstant = true;
        int max2 = this.getChildCount();
        for (int c = 0; c < max2; ++c) {
            SpelNode child = this.getChild(c);
            if (child instanceof Literal) continue;
            if (child instanceof InlineList) {
                InlineList inlineList = (InlineList)child;
                if (inlineList.isConstant()) continue;
                isConstant = false;
                continue;
            }
            isConstant = false;
        }
        if (isConstant) {
            ArrayList<Object> constantList = new ArrayList<Object>();
            int childcount = this.getChildCount();
            for (int c = 0; c < childcount; ++c) {
                SpelNode child = this.getChild(c);
                if (child instanceof Literal) {
                    constantList.add(((Literal)child).getLiteralValue().getValue());
                    continue;
                }
                if (!(child instanceof InlineList)) continue;
                constantList.add(((InlineList)child).getConstantValue());
            }
            this.constant = new TypedValue(Collections.unmodifiableList(constantList));
        }
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        if (this.constant != null) {
            return this.constant;
        }
        ArrayList<Object> returnValue = new ArrayList<Object>();
        int childcount = this.getChildCount();
        for (int c = 0; c < childcount; ++c) {
            returnValue.add(this.getChild(c).getValue(expressionState));
        }
        return new TypedValue(returnValue);
    }

    @Override
    public String toStringAST() {
        StringBuilder s2 = new StringBuilder();
        s2.append('{');
        int count2 = this.getChildCount();
        for (int c = 0; c < count2; ++c) {
            if (c > 0) {
                s2.append(',');
            }
            s2.append(this.getChild(c).toStringAST());
        }
        s2.append('}');
        return s2.toString();
    }

    public boolean isConstant() {
        return this.constant != null;
    }

    private List<Object> getConstantValue() {
        return (List)this.constant.getValue();
    }
}

