/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.AnnotationAttributesReadingVisitor;
import org.springframework.core.type.classreading.ClassMetadataReadingVisitor;
import org.springframework.core.type.classreading.MethodMetadataReadingVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AnnotationMetadataReadingVisitor
extends ClassMetadataReadingVisitor
implements AnnotationMetadata {
    private final ClassLoader classLoader;
    private final Set<String> annotationSet = new LinkedHashSet<String>(4);
    private final Map<String, Set<String>> metaAnnotationMap = new LinkedHashMap<String, Set<String>>(4);
    private final Map<String, AnnotationAttributes> attributeMap = new LinkedHashMap<String, AnnotationAttributes>(4);
    private final Set<MethodMetadata> methodMetadataSet = new LinkedHashSet<MethodMetadata>(4);

    public AnnotationMetadataReadingVisitor(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return new MethodMetadataReadingVisitor(name, access, this.getClassName(), this.classLoader, this.methodMetadataSet);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        String className = Type.getType(desc).getClassName();
        this.annotationSet.add(className);
        return new AnnotationAttributesReadingVisitor(className, this.attributeMap, this.metaAnnotationMap, this.classLoader);
    }

    @Override
    public Set<String> getAnnotationTypes() {
        return this.annotationSet;
    }

    @Override
    public Set<String> getMetaAnnotationTypes(String annotationType) {
        return this.metaAnnotationMap.get(annotationType);
    }

    @Override
    public boolean hasAnnotation(String annotationType) {
        return this.annotationSet.contains(annotationType);
    }

    @Override
    public boolean hasMetaAnnotation(String metaAnnotationType) {
        Collection<Set<String>> allMetaTypes = this.metaAnnotationMap.values();
        for (Set<String> metaTypes : allMetaTypes) {
            if (!metaTypes.contains(metaAnnotationType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAnnotated(String annotationType) {
        return this.attributeMap.containsKey(annotationType);
    }

    public AnnotationAttributes getAnnotationAttributes(String annotationType) {
        return this.getAnnotationAttributes(annotationType, false);
    }

    public AnnotationAttributes getAnnotationAttributes(String annotationType, boolean classValuesAsString) {
        AnnotationAttributes raw2 = this.attributeMap.get(annotationType);
        return this.convertClassValues(raw2, classValuesAsString);
    }

    private AnnotationAttributes convertClassValues(AnnotationAttributes original, boolean classValuesAsString) {
        if (original == null) {
            return null;
        }
        AnnotationAttributes result2 = new AnnotationAttributes(original.size());
        for (Map.Entry entry2 : original.entrySet()) {
            try {
                int i;
                Object value2 = entry2.getValue();
                if (value2 instanceof AnnotationAttributes) {
                    value2 = this.convertClassValues((AnnotationAttributes)value2, classValuesAsString);
                } else if (value2 instanceof AnnotationAttributes[]) {
                    AnnotationAttributes[] values = (AnnotationAttributes[])value2;
                    for (int i2 = 0; i2 < values.length; ++i2) {
                        values[i2] = this.convertClassValues(values[i2], classValuesAsString);
                    }
                } else if (value2 instanceof Type) {
                    value2 = classValuesAsString ? ((Type)value2).getClassName() : this.classLoader.loadClass(((Type)value2).getClassName());
                } else if (value2 instanceof Type[]) {
                    Type[] array = (Type[])value2;
                    Object[] convArray = classValuesAsString ? new String[array.length] : new Class[array.length];
                    for (i = 0; i < array.length; ++i) {
                        convArray[i] = classValuesAsString ? array[i].getClassName() : this.classLoader.loadClass(array[i].getClassName());
                    }
                    value2 = convArray;
                } else if (classValuesAsString) {
                    if (value2 instanceof Class) {
                        value2 = ((Class)value2).getName();
                    } else if (value2 instanceof Class[]) {
                        Class[] clazzArray = (Class[])value2;
                        String[] newValue = new String[clazzArray.length];
                        for (i = 0; i < clazzArray.length; ++i) {
                            newValue[i] = clazzArray[i].getName();
                        }
                        value2 = newValue;
                    }
                }
                result2.put(entry2.getKey(), value2);
            }
            catch (Exception ex) {}
        }
        return result2;
    }

    @Override
    public boolean hasAnnotatedMethods(String annotationType) {
        for (MethodMetadata methodMetadata : this.methodMetadataSet) {
            if (!methodMetadata.isAnnotated(annotationType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<MethodMetadata> getAnnotatedMethods(String annotationType) {
        LinkedHashSet<MethodMetadata> annotatedMethods = new LinkedHashSet<MethodMetadata>(4);
        for (MethodMetadata methodMetadata : this.methodMetadataSet) {
            if (!methodMetadata.isAnnotated(annotationType)) continue;
            annotatedMethods.add(methodMetadata);
        }
        return annotatedMethods;
    }
}

