/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.scope.ScopedProxyFactoryBean;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.SimpleInstantiationStrategy;
import org.springframework.cglib.core.SpringNamingPolicy;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.CallbackFilter;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.cglib.proxy.NoOp;
import org.springframework.context.annotation.BeanAnnotationHelper;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyCreator;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationClassEnhancer {
    private static final Callback DISPOSABLE_BEAN_METHOD_INTERCEPTOR = new DisposableBeanMethodInterceptor();
    private static final Class<?>[] CALLBACK_TYPES = new Class[]{BeanMethodInterceptor.class, DisposableBeanMethodInterceptor.class, NoOp.class};
    private static final CallbackFilter CALLBACK_FILTER = new ConfigurationClassCallbackFilter();
    private static final Log logger = LogFactory.getLog(ConfigurationClassEnhancer.class);
    private final Callback[] callbackInstances;

    public ConfigurationClassEnhancer(ConfigurableBeanFactory beanFactory) {
        Assert.notNull(beanFactory, "BeanFactory must not be null");
        this.callbackInstances = new Callback[]{new BeanMethodInterceptor(beanFactory), DISPOSABLE_BEAN_METHOD_INTERCEPTOR, NoOp.INSTANCE};
    }

    public Class<?> enhance(Class<?> configClass) {
        if (EnhancedConfiguration.class.isAssignableFrom(configClass)) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Ignoring request to enhance %s as it has already been enhanced. This usually indicates that more than one ConfigurationClassPostProcessor has been registered (e.g. via <context:annotation-config>). This is harmless, but you may want check your configuration and remove one CCPP if possible", configClass.getName()));
            }
            return configClass;
        }
        Class<?> enhancedClass = this.createClass(this.newEnhancer(configClass));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Successfully enhanced %s; enhanced class name is: %s", configClass.getName(), enhancedClass.getName()));
        }
        return enhancedClass;
    }

    private Enhancer newEnhancer(Class<?> superclass) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(superclass);
        enhancer.setInterfaces(new Class[]{EnhancedConfiguration.class});
        enhancer.setUseFactory(false);
        enhancer.setNamingPolicy(SpringNamingPolicy.INSTANCE);
        enhancer.setCallbackFilter(CALLBACK_FILTER);
        enhancer.setCallbackTypes(CALLBACK_TYPES);
        return enhancer;
    }

    private Class<?> createClass(Enhancer enhancer) {
        Class subclass = enhancer.createClass();
        Enhancer.registerStaticCallbacks(subclass, this.callbackInstances);
        return subclass;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanMethodInterceptor
    implements MethodInterceptor {
        private static final Class<?>[] CALLBACK_TYPES = new Class[]{GetObjectMethodInterceptor.class, NoOp.class};
        private static final CallbackFilter CALLBACK_FILTER = new CallbackFilter(){

            public int accept(Method method) {
                return method.getName().equals("getObject") ? 0 : 1;
            }
        };
        private final ConfigurableBeanFactory beanFactory;

        public BeanMethodInterceptor(ConfigurableBeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object intercept(Object enhancedConfigInstance, Method beanMethod, Object[] beanMethodArgs, MethodProxy cglibMethodProxy) throws Throwable {
            Object factoryBean;
            String scopedBeanName;
            String beanName = BeanAnnotationHelper.determineBeanNameFor(beanMethod);
            Scope scope = AnnotationUtils.findAnnotation(beanMethod, Scope.class);
            if (scope != null && scope.proxyMode() != ScopedProxyMode.NO && this.beanFactory.isCurrentlyInCreation(scopedBeanName = ScopedProxyCreator.getTargetBeanName(beanName))) {
                beanName = scopedBeanName;
            }
            if (this.factoryContainsBean("&" + beanName) && this.factoryContainsBean(beanName) && !((factoryBean = this.beanFactory.getBean("&" + beanName)) instanceof ScopedProxyFactoryBean)) {
                return this.enhanceFactoryBean(factoryBean.getClass(), beanName);
            }
            if (this.isCurrentlyInvokedFactoryMethod(beanMethod) && !this.beanFactory.containsSingleton(beanName)) {
                if (BeanFactoryPostProcessor.class.isAssignableFrom(beanMethod.getReturnType())) {
                    logger.warn(String.format("@Bean method %s.%s is non-static and returns an object assignable to Spring's BeanFactoryPostProcessor interface. This will result in a failure to process annotations such as @Autowired, @Resource and @PostConstruct within the method's declaring @Configuration class. Add the 'static' modifier to this method to avoid these container lifecycle issues; see @Bean Javadoc for complete details", beanMethod.getDeclaringClass().getSimpleName(), beanMethod.getName()));
                }
                return cglibMethodProxy.invokeSuper(enhancedConfigInstance, beanMethodArgs);
            }
            boolean alreadyInCreation = this.beanFactory.isCurrentlyInCreation(beanName);
            try {
                if (alreadyInCreation) {
                    this.beanFactory.setCurrentlyInCreation(beanName, false);
                }
                Object object = this.beanFactory.getBean(beanName);
                return object;
            }
            finally {
                if (alreadyInCreation) {
                    this.beanFactory.setCurrentlyInCreation(beanName, true);
                }
            }
        }

        private boolean factoryContainsBean(String beanName) {
            return this.beanFactory.containsBean(beanName) && !this.beanFactory.isCurrentlyInCreation(beanName);
        }

        private boolean isCurrentlyInvokedFactoryMethod(Method method) {
            Method currentlyInvoked = SimpleInstantiationStrategy.getCurrentlyInvokedFactoryMethod();
            return currentlyInvoked != null && method.getName().equals(currentlyInvoked.getName()) && Arrays.equals(method.getParameterTypes(), currentlyInvoked.getParameterTypes());
        }

        private Object enhanceFactoryBean(Class<?> fbClass, String beanName) throws InstantiationException, IllegalAccessException {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(fbClass);
            enhancer.setUseFactory(false);
            enhancer.setCallbackFilter(CALLBACK_FILTER);
            Callback[] callbackInstances = new Callback[]{new GetObjectMethodInterceptor(this.beanFactory, beanName), NoOp.INSTANCE};
            enhancer.setCallbackTypes(CALLBACK_TYPES);
            Class fbSubclass = enhancer.createClass();
            Enhancer.registerCallbacks(fbSubclass, callbackInstances);
            return fbSubclass.newInstance();
        }
    }

    private static class DisposableBeanMethodInterceptor
    implements MethodInterceptor {
        private DisposableBeanMethodInterceptor() {
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            Enhancer.registerStaticCallbacks(obj.getClass(), null);
            if (DisposableBean.class.isAssignableFrom(obj.getClass().getSuperclass())) {
                return proxy.invokeSuper(obj, args);
            }
            return null;
        }

        public static boolean isDestroyMethod(Method candidateMethod) {
            return candidateMethod.getName().equals("destroy") && candidateMethod.getParameterTypes().length == 0 && DisposableBean.class.isAssignableFrom(candidateMethod.getDeclaringClass());
        }
    }

    private static class GetObjectMethodInterceptor
    implements MethodInterceptor {
        private final ConfigurableBeanFactory beanFactory;
        private final String beanName;

        public GetObjectMethodInterceptor(ConfigurableBeanFactory beanFactory, String beanName) {
            this.beanFactory = beanFactory;
            this.beanName = beanName;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            return this.beanFactory.getBean(this.beanName);
        }
    }

    private static class ConfigurationClassCallbackFilter
    implements CallbackFilter {
        private ConfigurationClassCallbackFilter() {
        }

        public int accept(Method candidateMethod) {
            if (BeanAnnotationHelper.isBeanAnnotated(candidateMethod)) {
                return 0;
            }
            if (DisposableBeanMethodInterceptor.isDestroyMethod(candidateMethod)) {
                return 1;
            }
            return 2;
        }
    }

    public static interface EnhancedConfiguration
    extends DisposableBean {
    }
}

