/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.text.NumberFormat;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomNumberEditor
extends PropertyEditorSupport {
    private final Class<? extends Number> numberClass;
    private final NumberFormat numberFormat;
    private final boolean allowEmpty;

    public CustomNumberEditor(Class<? extends Number> numberClass, boolean allowEmpty) throws IllegalArgumentException {
        this(numberClass, null, allowEmpty);
    }

    public CustomNumberEditor(Class<? extends Number> numberClass, NumberFormat numberFormat, boolean allowEmpty) throws IllegalArgumentException {
        if (numberClass == null || !Number.class.isAssignableFrom(numberClass)) {
            throw new IllegalArgumentException("Property class must be a subclass of Number");
        }
        this.numberClass = numberClass;
        this.numberFormat = numberFormat;
        this.allowEmpty = allowEmpty;
    }

    @Override
    public void setAsText(String text2) throws IllegalArgumentException {
        if (this.allowEmpty && !StringUtils.hasText(text2)) {
            this.setValue(null);
        } else if (this.numberFormat != null) {
            this.setValue(NumberUtils.parseNumber(text2, this.numberClass, this.numberFormat));
        } else {
            this.setValue(NumberUtils.parseNumber(text2, this.numberClass));
        }
    }

    @Override
    public void setValue(Object value2) {
        if (value2 instanceof Number) {
            super.setValue(NumberUtils.convertNumberToTargetClass((Number)value2, this.numberClass));
        } else {
            super.setValue(value2);
        }
    }

    @Override
    public String getAsText() {
        Object value2 = this.getValue();
        if (value2 == null) {
            return "";
        }
        if (this.numberFormat != null) {
            return this.numberFormat.format(value2);
        }
        return value2.toString();
    }
}

