/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.annotation;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.Conventions;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements MergedBeanDefinitionPostProcessor,
PriorityOrdered,
BeanFactoryAware {
    public static final String SKIP_REQUIRED_CHECK_ATTRIBUTE = Conventions.getQualifiedAttributeName(RequiredAnnotationBeanPostProcessor.class, "skipRequiredCheck");
    private Class<? extends Annotation> requiredAnnotationType = Required.class;
    private int order = 0x7FFFFFFE;
    private ConfigurableListableBeanFactory beanFactory;
    private final Map<String, Boolean> validatedBeanNames = new ConcurrentHashMap<String, Boolean>(64);

    public void setRequiredAnnotationType(Class<? extends Annotation> requiredAnnotationType) {
        Assert.notNull(requiredAnnotationType, "'requiredAnnotationType' must not be null");
        this.requiredAnnotationType = requiredAnnotationType;
    }

    protected Class<? extends Annotation> getRequiredAnnotationType() {
        return this.requiredAnnotationType;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        }
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
    }

    @Override
    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        if (!this.validatedBeanNames.containsKey(beanName)) {
            if (!this.shouldSkip(this.beanFactory, beanName)) {
                ArrayList<String> invalidProperties = new ArrayList<String>();
                for (PropertyDescriptor pd : pds) {
                    if (!this.isRequiredProperty(pd) || pvs.contains(pd.getName())) continue;
                    invalidProperties.add(pd.getName());
                }
                if (!invalidProperties.isEmpty()) {
                    throw new BeanInitializationException(this.buildExceptionMessage(invalidProperties, beanName));
                }
            }
            this.validatedBeanNames.put(beanName, Boolean.TRUE);
        }
        return pvs;
    }

    protected boolean shouldSkip(ConfigurableListableBeanFactory beanFactory, String beanName) {
        if (beanFactory == null || !beanFactory.containsBeanDefinition(beanName)) {
            return false;
        }
        Object value2 = beanFactory.getBeanDefinition(beanName).getAttribute(SKIP_REQUIRED_CHECK_ATTRIBUTE);
        return value2 != null && (Boolean.TRUE.equals(value2) || Boolean.valueOf(value2.toString()) != false);
    }

    protected boolean isRequiredProperty(PropertyDescriptor propertyDescriptor) {
        Method setter2 = propertyDescriptor.getWriteMethod();
        return setter2 != null && AnnotationUtils.getAnnotation(setter2, this.getRequiredAnnotationType()) != null;
    }

    private String buildExceptionMessage(List<String> invalidProperties, String beanName) {
        int size2 = invalidProperties.size();
        StringBuilder sb = new StringBuilder();
        sb.append(size2 == 1 ? "Property" : "Properties");
        for (int i = 0; i < size2; ++i) {
            String propertyName = invalidProperties.get(i);
            if (i > 0) {
                if (i == size2 - 1) {
                    sb.append(" and");
                } else {
                    sb.append(",");
                }
            }
            sb.append(" '").append(propertyName).append("'");
        }
        sb.append(size2 == 1 ? " is" : " are");
        sb.append(" required for bean '").append(beanName).append("'");
        return sb.toString();
    }
}

