/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.AbstractPropertyAccessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.TypeConverterDelegate;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectFieldAccessor
extends AbstractPropertyAccessor {
    private final Object target;
    private final Map<String, Field> fieldMap = new HashMap<String, Field>();

    public DirectFieldAccessor(Object target) {
        Assert.notNull(target, "Target object must not be null");
        this.target = target;
        ReflectionUtils.doWithFields(this.target.getClass(), new ReflectionUtils.FieldCallback(){

            public void doWith(Field field2) {
                if (!DirectFieldAccessor.this.fieldMap.containsKey(field2.getName())) {
                    DirectFieldAccessor.this.fieldMap.put(field2.getName(), field2);
                }
            }
        });
        this.typeConverterDelegate = new TypeConverterDelegate(this, target);
        this.registerDefaultEditors();
        this.setExtractOldValueForEditor(true);
    }

    @Override
    public boolean isReadableProperty(String propertyName) throws BeansException {
        return this.fieldMap.containsKey(propertyName);
    }

    @Override
    public boolean isWritableProperty(String propertyName) throws BeansException {
        return this.fieldMap.containsKey(propertyName);
    }

    @Override
    public Class<?> getPropertyType(String propertyName) throws BeansException {
        Field field2 = this.fieldMap.get(propertyName);
        if (field2 != null) {
            return field2.getType();
        }
        return null;
    }

    @Override
    public TypeDescriptor getPropertyTypeDescriptor(String propertyName) throws BeansException {
        Field field2 = this.fieldMap.get(propertyName);
        if (field2 != null) {
            return new TypeDescriptor(field2);
        }
        return null;
    }

    @Override
    public Object getPropertyValue(String propertyName) throws BeansException {
        Field field2 = this.fieldMap.get(propertyName);
        if (field2 == null) {
            throw new NotReadablePropertyException(this.target.getClass(), propertyName, "Field '" + propertyName + "' does not exist");
        }
        try {
            ReflectionUtils.makeAccessible(field2);
            return field2.get(this.target);
        }
        catch (IllegalAccessException ex) {
            throw new InvalidPropertyException(this.target.getClass(), propertyName, "Field is not accessible", ex);
        }
    }

    @Override
    public void setPropertyValue(String propertyName, Object newValue) throws BeansException {
        Field field2 = this.fieldMap.get(propertyName);
        if (field2 == null) {
            throw new NotWritablePropertyException(this.target.getClass(), propertyName, "Field '" + propertyName + "' does not exist");
        }
        Object oldValue = null;
        try {
            ReflectionUtils.makeAccessible(field2);
            oldValue = field2.get(this.target);
            Object convertedValue = this.typeConverterDelegate.convertIfNecessary(field2.getName(), oldValue, newValue, field2.getType(), new TypeDescriptor(field2));
            field2.set(this.target, convertedValue);
        }
        catch (ConverterNotFoundException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.target, propertyName, oldValue, newValue);
            throw new ConversionNotSupportedException(pce, field2.getType(), (Throwable)ex);
        }
        catch (ConversionException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.target, propertyName, oldValue, newValue);
            throw new TypeMismatchException(pce, field2.getType(), (Throwable)ex);
        }
        catch (IllegalStateException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.target, propertyName, oldValue, newValue);
            throw new ConversionNotSupportedException(pce, field2.getType(), (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.target, propertyName, oldValue, newValue);
            throw new TypeMismatchException(pce, field2.getType(), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new InvalidPropertyException(this.target.getClass(), propertyName, "Field is not accessible", ex);
        }
    }
}

