/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ClassAnalyzer;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.Errors;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.ReflectionHelper;

@Singleton
@Named(value="JerseyClassAnalyzer")
public final class JerseyClassAnalyzer
implements ClassAnalyzer {
    public static final String NAME = "JerseyClassAnalyzer";
    private final ClassAnalyzer defaultAnalyzer;
    private final Set<Class<? extends Annotation>> resolverAnnotations;

    @Inject
    JerseyClassAnalyzer(@Named(value="default") ClassAnalyzer defaultAnalyzer, IterableProvider<InjectionResolver<?>> resolvers) {
        this.defaultAnalyzer = defaultAnalyzer;
        HashSet<Class<Annotation>> tmp = new HashSet<Class<Annotation>>();
        for (InjectionResolver injectionResolver : resolvers) {
            ReflectionHelper.DeclaringClassInterfacePair pair2;
            Type paramType;
            Class paramClass;
            if (!injectionResolver.isConstructorParameterIndicator() || !Annotation.class.isAssignableFrom(paramClass = ReflectionHelper.erasure(paramType = ReflectionHelper.getParameterizedTypeArguments(pair2 = ReflectionHelper.getClass(injectionResolver.getClass(), InjectionResolver.class))[0]))) continue;
            tmp.add(paramClass.asSubclass(Annotation.class));
        }
        this.resolverAnnotations = tmp.size() > 0 ? Collections.unmodifiableSet(tmp) : Collections.emptySet();
    }

    @Override
    public <T> Constructor<T> getConstructor(final Class<T> clazz) throws MultiException, NoSuchMethodException {
        block11: {
            if (clazz.isLocalClass()) {
                throw new NoSuchMethodException(LocalizationMessages.INJECTION_ERROR_LOCAL_CLASS_NOT_SUPPORTED(clazz.getName()));
            }
            if (clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
                throw new NoSuchMethodException(LocalizationMessages.INJECTION_ERROR_NONSTATIC_MEMBER_CLASS_NOT_SUPPORTED(clazz.getName()));
            }
            try {
                Constructor<Inject> retVal = this.defaultAnalyzer.getConstructor(clazz);
                Class<?>[] args = retVal.getParameterTypes();
                if (args.length != 0) {
                    return retVal;
                }
                Inject i = retVal.getAnnotation(Inject.class);
                if (i != null) {
                    return retVal;
                }
            }
            catch (NoSuchMethodException args) {
            }
            catch (MultiException me) {
                if (me.getErrors().size() == 1 || me.getErrors().get(0) instanceof IllegalArgumentException) break block11;
                throw me;
            }
        }
        Constructor<?>[] constructors = AccessController.doPrivileged(new PrivilegedAction<Constructor<?>[]>(){

            @Override
            public Constructor<?>[] run() {
                return clazz.getDeclaredConstructors();
            }
        });
        Constructor<?> selected = null;
        int selectedSize = 0;
        int maxParams = -1;
        for (Constructor<?> constructor : constructors) {
            Class<?>[] params = constructor.getParameterTypes();
            if (params.length < maxParams || !this.isCompatible(constructor)) continue;
            if (params.length > maxParams) {
                maxParams = params.length;
                selectedSize = 0;
            }
            selected = constructor;
            ++selectedSize;
        }
        if (selectedSize == 0) {
            throw new NoSuchMethodException(LocalizationMessages.INJECTION_ERROR_SUITABLE_CONSTRUCTOR_NOT_FOUND(clazz.getName()));
        }
        if (selectedSize > 1) {
            Errors.warning(clazz, LocalizationMessages.MULTIPLE_MATCHING_CONSTRUCTORS_FOUND(selectedSize, maxParams, clazz.getName(), selected.toGenericString()));
        }
        return selected;
    }

    private boolean isCompatible(Constructor<?> constructor) {
        if (constructor.getAnnotation(Inject.class) != null) {
            return true;
        }
        int paramSize = constructor.getParameterTypes().length;
        if (paramSize != 0 && this.resolverAnnotations.isEmpty()) {
            return false;
        }
        if (!Modifier.isPublic(constructor.getModifiers())) {
            return paramSize == 0 && (constructor.getDeclaringClass().getModifiers() & 7) == constructor.getModifiers();
        }
        for (Annotation[] paramAnnotations : constructor.getParameterAnnotations()) {
            boolean found = false;
            for (Annotation paramAnnotation : paramAnnotations) {
                if (!this.resolverAnnotations.contains(paramAnnotation.annotationType())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> Set<Method> getInitializerMethods(Class<T> clazz) throws MultiException {
        return this.defaultAnalyzer.getInitializerMethods(clazz);
    }

    @Override
    public <T> Set<Field> getFields(Class<T> clazz) throws MultiException {
        return this.defaultAnalyzer.getFields(clazz);
    }

    @Override
    public <T> Method getPostConstructMethod(Class<T> clazz) throws MultiException {
        return this.defaultAnalyzer.getPostConstructMethod(clazz);
    }

    @Override
    public <T> Method getPreDestroyMethod(Class<T> clazz) throws MultiException {
        return this.defaultAnalyzer.getPreDestroyMethod(clazz);
    }

    public static final class Binder
    extends AbstractBinder {
        @Override
        protected void configure() {
            this.bind(JerseyClassAnalyzer.class).analyzeWith("default").named(JerseyClassAnalyzer.NAME).to(ClassAnalyzer.class).in(Singleton.class);
        }
    }
}

