/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class ForeignKeyConstraint
implements Serializable {
    protected String name = "";
    protected List<String> sourceFields = new ArrayList<String>();
    protected List<String> targetFields = new ArrayList<String>();
    protected String targetTable = "";
    protected boolean shouldCascadeOnDelete = false;
    protected String foreignKeyDefinition;
    protected boolean disableForeignKey;

    public ForeignKeyConstraint() {
    }

    public ForeignKeyConstraint(String name, String sourceField, String targetField, String targetTable) {
        this();
        this.name = name;
        this.sourceFields.add(sourceField);
        this.targetFields.add(targetField);
        this.targetTable = targetTable;
    }

    public void addSourceField(String sourceField) {
        this.getSourceFields().add(sourceField);
    }

    public void addTargetField(String targetField) {
        this.getTargetFields().add(targetField);
    }

    public void appendDBString(Writer writer, AbstractSession session) {
        try {
            if (this.hasForeignKeyDefinition()) {
                writer.write(this.getForeignKeyDefinition());
            } else {
                writer.write("FOREIGN KEY (");
                Iterator<String> iterator2 = this.getSourceFields().iterator();
                while (iterator2.hasNext()) {
                    writer.write(iterator2.next());
                    if (!iterator2.hasNext()) continue;
                    writer.write(", ");
                }
                writer.write(") REFERENCES ");
                writer.write(this.getTargetTable());
                writer.write(" (");
                iterator2 = this.getTargetFields().iterator();
                while (iterator2.hasNext()) {
                    writer.write(iterator2.next());
                    if (!iterator2.hasNext()) continue;
                    writer.write(", ");
                }
                writer.write(")");
                if (this.shouldCascadeOnDelete() && session.getPlatform().supportsDeleteOnCascade()) {
                    writer.write(" ON DELETE CASCADE");
                }
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public void cascadeOnDelete() {
        this.setShouldCascadeOnDelete(true);
    }

    public boolean disableForeignKey() {
        return this.disableForeignKey;
    }

    public void dontCascadeOnDelete() {
        this.setShouldCascadeOnDelete(false);
    }

    public String getForeignKeyDefinition() {
        return this.foreignKeyDefinition;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getSourceFields() {
        return this.sourceFields;
    }

    public List<String> getTargetFields() {
        return this.targetFields;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public boolean hasForeignKeyDefinition() {
        return this.foreignKeyDefinition != null;
    }

    public boolean isDisableForeignKey() {
        return this.disableForeignKey;
    }

    public void setDisableForeignKey(boolean disableForeignKey) {
        this.disableForeignKey = disableForeignKey;
    }

    public void setForeignKeyDefinition(String foreignKeyDefinition) {
        this.foreignKeyDefinition = foreignKeyDefinition;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setShouldCascadeOnDelete(boolean shouldCascadeOnDelete) {
        this.shouldCascadeOnDelete = shouldCascadeOnDelete;
    }

    public void setSourceFields(List<String> sourceFields) {
        this.sourceFields = sourceFields;
    }

    public void setTargetFields(List<String> targetFields) {
        this.targetFields = targetFields;
    }

    public void setTargetTable(String targetTable) {
        this.targetTable = targetTable;
    }

    public boolean shouldCascadeOnDelete() {
        return this.shouldCascadeOnDelete;
    }
}

