/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.descriptors.FieldTransformation;
import org.eclipse.persistence.internal.descriptors.MethodBasedFieldTransformation;
import org.eclipse.persistence.internal.descriptors.TransformerBasedFieldTransformation;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.RelationTableMechanism;
import org.eclipse.persistence.mappings.TransformationMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.SerializedObjectConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.ForeignKeyConstraint;
import org.eclipse.persistence.tools.schemaframework.TableCreator;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;
import org.eclipse.persistence.tools.schemaframework.UniqueKeyConstraint;

public class DefaultTableGenerator {
    Project project = null;
    protected DatabasePlatform databasePlatform;
    protected Map<String, TableDefinition> tableMap = null;
    protected Map<DatabaseField, FieldDefinition> fieldMap = null;
    protected Map<DatabaseField, DatabaseField> databaseFields;
    protected boolean generateFKConstraints;

    public DefaultTableGenerator(Project project) {
        this.project = project;
        if (project.getDatasourceLogin().getDatasourcePlatform() instanceof DatabasePlatform) {
            this.databasePlatform = (DatabasePlatform)project.getDatasourceLogin().getDatasourcePlatform();
            this.generateFKConstraints = this.databasePlatform.supportsForeignKeyConstraints();
        }
        this.tableMap = new LinkedHashMap<String, TableDefinition>();
        this.fieldMap = new LinkedHashMap<DatabaseField, FieldDefinition>();
        this.databaseFields = new LinkedHashMap<DatabaseField, DatabaseField>();
    }

    public DefaultTableGenerator(Project project, boolean generateFKConstraints) {
        this(project);
        this.generateFKConstraints = generateFKConstraints;
    }

    public TableCreator generateDefaultTableCreator() {
        TableCreator tblCreator = new TableCreator();
        for (ClassDescriptor descriptor : this.project.getOrderedDescriptors()) {
            if (descriptor instanceof XMLDescriptor || descriptor instanceof EISDescriptor || descriptor instanceof ObjectRelationalDataTypeDescriptor) {
                AbstractSessionLog.getLog().log(6, "ddl", "relational_descriptor_support_only", null, true);
                return tblCreator;
            }
            if (descriptor.isDescriptorTypeAggregate() || descriptor.hasTablePerMultitenantPolicy() && !this.project.allowTablePerMultitenantDDLGeneration()) continue;
            this.initTableSchema(descriptor);
        }
        for (ClassDescriptor descriptor : this.project.getOrderedDescriptors()) {
            if (descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor() || descriptor.hasTablePerMultitenantPolicy() && !this.project.allowTablePerMultitenantDDLGeneration()) continue;
            this.postInitTableSchema(descriptor);
            if (!descriptor.hasMultitenantPolicy()) continue;
            descriptor.getMultitenantPolicy().addToTableDefinition(this.getTableDefFromDBTable(descriptor.getDefaultTable()));
        }
        tblCreator.addTableDefinitions(this.tableMap.values());
        return tblCreator;
    }

    public TableCreator generateFilteredDefaultTableCreator(AbstractSession session) throws DatabaseException {
        TableCreator tblCreator = this.generateDefaultTableCreator();
        try {
            Connection conn = null;
            if (session.isServerSession()) {
                conn = ((ServerSession)session).getDefaultConnectionPool().acquireConnection().getConnection();
            } else if (session.isDatabaseSession()) {
                conn = ((DatabaseSessionImpl)session).getAccessor().getConnection();
            }
            if (conn == null) {
                return tblCreator;
            }
            DatabaseMetaData dbMetaData = conn.getMetaData();
            ResultSet resultSet = dbMetaData.getTables(null, dbMetaData.getUserName(), null, new String[]{"TABLE"});
            ArrayList<String> tablesInDatabase = new ArrayList<String>();
            while (resultSet.next()) {
                tablesInDatabase.add(resultSet.getString("TABLE_NAME"));
            }
            resultSet.close();
            ArrayList<TableDefinition> existedTables = new ArrayList<TableDefinition>();
            ArrayList<String> existedTableNames = new ArrayList<String>();
            for (TableDefinition tblDef : tblCreator.getTableDefinitions()) {
                if (!tablesInDatabase.contains(tblDef.getFullName())) continue;
                existedTables.add(tblDef);
                existedTableNames.add(tblDef.getFullName());
            }
            if (!existedTableNames.isEmpty()) {
                session.getSessionLog().log(1, "ddl", "skip_create_existing_tables", existedTableNames);
                tblCreator.getTableDefinitions().removeAll(existedTables);
            }
        }
        catch (SQLException sQLException) {
            throw DatabaseException.errorRetrieveDbMetadataThroughJDBCConnection();
        }
        return tblCreator;
    }

    protected void initTableSchema(ClassDescriptor descriptor) {
        TableDefinition tableDefintion = null;
        if (descriptor.hasTablePerClassPolicy() && descriptor.isAbstract()) {
            return;
        }
        for (DatabaseTable table : descriptor.getTables()) {
            tableDefintion = this.getTableDefFromDBTable(table);
        }
        for (DatabaseField dbField : descriptor.getFields()) {
            if (!dbField.isCreatable()) continue;
            boolean isPKField = false;
            isPKField = descriptor.getPrimaryKeyFields().contains(dbField);
            Map<DatabaseField, DatabaseField> secondaryKeyMap = descriptor.getAdditionalTablePrimaryKeyFields().get(dbField.getTable());
            if (secondaryKeyMap != null) {
                isPKField = isPKField || secondaryKeyMap.containsValue(dbField);
            }
            isPKField = isPKField || dbField.isPrimaryKey();
            FieldDefinition fieldDef = this.getFieldDefFromDBField(dbField);
            if (isPKField) {
                fieldDef.setIsPrimaryKey(true);
                String sequenceName = descriptor.getSequenceNumberName();
                DatabaseLogin login = this.project.getLogin();
                Sequence seq = login.getSequence(sequenceName);
                if (seq instanceof DefaultSequence) {
                    seq = login.getDefaultSequence();
                }
                boolean isIdentity = seq instanceof NativeSequence && seq.shouldAcquireValueAfterInsert();
                fieldDef.setIsIdentity(isIdentity);
            }
            if ((tableDefintion = this.tableMap.get(dbField.getTableName())) == null || tableDefintion.getFields().contains(fieldDef)) continue;
            tableDefintion.addField(fieldDef);
        }
    }

    protected void postInitTableSchema(ClassDescriptor descriptor) {
        for (DatabaseMapping mapping : descriptor.getMappings()) {
            if (descriptor.isChildDescriptor() && descriptor.getInheritancePolicy().getParentDescriptor().getMappingForAttributeName(mapping.getAttributeName()) != null) continue;
            if (mapping.isManyToManyMapping()) {
                this.buildRelationTableDefinition((ManyToManyMapping)mapping, ((ManyToManyMapping)mapping).getRelationTableMechanism(), ((ManyToManyMapping)mapping).getListOrderField(), mapping.getContainerPolicy());
                continue;
            }
            if (mapping.isDirectCollectionMapping()) {
                this.buildDirectCollectionTableDefinition((DirectCollectionMapping)mapping, descriptor);
                continue;
            }
            if (mapping.isDirectToFieldMapping()) {
                Converter converter = ((DirectToFieldMapping)mapping).getConverter();
                if (converter == null) continue;
                if (converter instanceof TypeConversionConverter) {
                    this.resetFieldTypeForLOB((DirectToFieldMapping)mapping);
                }
                if (!(converter instanceof SerializedObjectConverter)) continue;
                this.getFieldDefFromDBField(mapping.getField()).setType(((SerializedObjectConverter)converter).getSerializer().getType());
                continue;
            }
            if (mapping.isAggregateCollectionMapping()) {
                this.createAggregateTargetTable((AggregateCollectionMapping)mapping);
                continue;
            }
            if (mapping.isForeignReferenceMapping()) {
                if (mapping.isOneToOneMapping()) {
                    RelationTableMechanism relationTableMechanism = ((OneToOneMapping)mapping).getRelationTableMechanism();
                    if (relationTableMechanism == null) {
                        this.addForeignKeyFieldToSourceTargetTable((OneToOneMapping)mapping);
                        continue;
                    }
                    this.buildRelationTableDefinition((OneToOneMapping)mapping, relationTableMechanism, null, null);
                    continue;
                }
                if (!mapping.isOneToManyMapping()) continue;
                this.addForeignKeyFieldToSourceTargetTable((OneToManyMapping)mapping);
                TableDefinition targTblDef = this.getTableDefFromDBTable(((OneToManyMapping)mapping).getReferenceDescriptor().getDefaultTable());
                this.addFieldsForMappedKeyMapContainerPolicy(mapping.getContainerPolicy(), targTblDef);
                continue;
            }
            if (mapping.isTransformationMapping()) {
                this.resetTransformedFieldType((TransformationMapping)mapping);
                continue;
            }
            if (!mapping.isAggregateObjectMapping()) continue;
            this.postInitTableSchema(((AggregateObjectMapping)mapping).getReferenceDescriptor());
        }
        this.processAdditionalTablePkFields(descriptor);
    }

    protected void addFieldsForMappedKeyMapContainerPolicy(ContainerPolicy cp, TableDefinition table) {
        if (cp.isMappedKeyMapPolicy()) {
            List<DatabaseField> keyFields = cp.getIdentityFieldsForMapKey();
            for (DatabaseField foreignKey : keyFields) {
                FieldDefinition fieldDef = this.getFieldDefFromDBField(foreignKey);
                if (table.getFields().contains(fieldDef)) continue;
                table.addField(fieldDef);
            }
            Map<DatabaseField, DatabaseField> foreignKeys = ((MappedKeyMapContainerPolicy)cp).getForeignKeyFieldsForMapKey();
            if (foreignKeys != null) {
                this.addForeignMappingFkConstraint(foreignKeys, false);
            }
        }
    }

    protected void buildRelationTableDefinition(ForeignReferenceMapping mapping, RelationTableMechanism relationTableMechanism, DatabaseField listOrderField, ContainerPolicy cp) {
        TableDefinition table = this.getTableDefFromDBTable(relationTableMechanism.getRelationTable());
        Vector<DatabaseField> srcFkFields = relationTableMechanism.getSourceRelationKeyFields();
        Vector<DatabaseField> srcKeyFields = relationTableMechanism.getSourceKeyFields();
        this.buildRelationTableFields(mapping, table, srcFkFields, srcKeyFields);
        Vector<DatabaseField> targFkFields = relationTableMechanism.getTargetRelationKeyFields();
        Vector<DatabaseField> targKeyFields = relationTableMechanism.getTargetKeyFields();
        this.buildRelationTableFields(mapping, table, targFkFields, targKeyFields);
        if (cp != null) {
            this.addFieldsForMappedKeyMapContainerPolicy(cp, table);
        }
        if (listOrderField != null) {
            FieldDefinition fieldDef = this.getFieldDefFromDBField(listOrderField);
            if (!table.getFields().contains(fieldDef)) {
                table.addField(fieldDef);
            }
        }
    }

    protected void buildRelationTableFields(ForeignReferenceMapping mapping, TableDefinition table, List<DatabaseField> fkFields, List<DatabaseField> targetFields) {
        assert (fkFields.size() > 0 && fkFields.size() == targetFields.size());
        DatabaseField fkField = null;
        DatabaseField targetField = null;
        ArrayList<String> fkFieldNames = new ArrayList<String>();
        ArrayList<String> targetFieldNames = new ArrayList<String>();
        int index2 = 0;
        while (index2 < fkFields.size()) {
            fkField = fkFields.get(index2);
            targetField = targetFields.get(index2);
            fkFieldNames.add(fkField.getNameDelimited(this.databasePlatform));
            targetFieldNames.add(targetField.getNameDelimited(this.databasePlatform));
            fkField = this.resolveDatabaseField(fkField, targetField);
            this.setFieldToRelationTable(fkField, table);
            ++index2;
        }
        DatabaseTable targetTable = targetField.getTable();
        TableDefinition targetTblDef = this.getTableDefFromDBTable(targetTable);
        if (mapping.getDescriptor().hasTablePerClassPolicy()) {
            return;
        }
        if (mapping.getReferenceDescriptor().hasTablePerClassPolicy() && mapping.getReferenceDescriptor().getTablePerClassPolicy().hasChild()) {
            return;
        }
        this.addForeignKeyConstraint(table, targetTblDef, fkFieldNames, targetFieldNames, mapping.isCascadeOnDeleteSetOnDatabase());
    }

    protected void buildDirectCollectionTableDefinition(DirectCollectionMapping mapping, ClassDescriptor descriptor) {
        FieldDefinition fieldDef;
        TableDefinition table = this.getTableDefFromDBTable(mapping.getReferenceTable());
        DatabaseField dbField = null;
        DatabaseField targetField = null;
        ArrayList<String> fkFieldNames = new ArrayList<String>();
        ArrayList<String> targetFieldNames = new ArrayList<String>();
        Vector<DatabaseField> fkFields = mapping.getReferenceKeyFields();
        Vector<DatabaseField> targetFields = mapping.getSourceKeyFields();
        int index2 = 0;
        while (index2 < fkFields.size()) {
            DatabaseField fkField = (DatabaseField)fkFields.get(index2);
            targetField = (DatabaseField)targetFields.get(index2);
            fkFieldNames.add(fkField.getNameDelimited(this.databasePlatform));
            targetFieldNames.add(targetField.getNameDelimited(this.databasePlatform));
            fkField = this.resolveDatabaseField(fkField, targetField);
            fieldDef = this.getFieldDefFromDBField(fkField);
            if (!table.getFields().contains(fieldDef)) {
                table.addField(fieldDef);
            }
            ++index2;
        }
        DatabaseTable targetTable = targetField.getTable();
        TableDefinition targetTblDef = this.getTableDefFromDBTable(targetTable);
        fieldDef = this.getFieldDefFromDBField(mapping.getDirectField());
        if (!table.getFields().contains(fieldDef)) {
            table.addField(fieldDef);
        }
        if (mapping.isDirectMapMapping() && !mapping.getContainerPolicy().isMappedKeyMapPolicy()) {
            dbField = ((DirectMapMapping)mapping).getDirectKeyField();
            fieldDef = this.getFieldDefFromDBField(dbField);
            if (!table.getFields().contains(fieldDef)) {
                table.addField(fieldDef);
            }
        } else {
            this.addFieldsForMappedKeyMapContainerPolicy(mapping.getContainerPolicy(), table);
            if (mapping.getListOrderField() != null) {
                fieldDef = this.getFieldDefFromDBField(mapping.getListOrderField());
                if (!table.getFields().contains(fieldDef)) {
                    table.addField(fieldDef);
                }
            }
        }
        if (mapping.getDescriptor().hasTablePerClassPolicy()) {
            return;
        }
        this.addForeignKeyConstraint(table, targetTblDef, fkFieldNames, targetFieldNames, mapping.isCascadeOnDeleteSetOnDatabase());
    }

    protected void resetFieldTypeForLOB(DirectToFieldMapping mapping) {
        if (mapping.getFieldClassification().getName().equals("java.sql.Blob")) {
            this.getFieldDefFromDBField(mapping.getField()).setType(Byte[].class);
        } else if (mapping.getFieldClassification().getName().equals("java.sql.Clob")) {
            this.getFieldDefFromDBField(mapping.getField()).setType(Character[].class);
        }
    }

    protected void resetTransformedFieldType(TransformationMapping mapping) {
        for (FieldTransformation transformation : mapping.getFieldTransformations()) {
            if (transformation instanceof MethodBasedFieldTransformation) {
                MethodBasedFieldTransformation methodTransformation = (MethodBasedFieldTransformation)transformation;
                try {
                    Class<?> returnType = Helper.getDeclaredMethod(mapping.getDescriptor().getJavaClass(), methodTransformation.getMethodName(), null).getReturnType();
                    this.getFieldDefFromDBField(methodTransformation.getField()).setType(returnType);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                continue;
            }
            TransformerBasedFieldTransformation classTransformation = (TransformerBasedFieldTransformation)transformation;
            String methodName = "buildFieldValue";
            Class[] params = new Class[]{Object.class, String.class, Session.class};
            try {
                Class<?> returnType = Helper.getDeclaredMethod(classTransformation.getTransformerClass(), methodName, params).getReturnType();
                if (returnType.equals(Object.class)) {
                    throw ValidationException.missingFieldTypeForDDLGenerationOfClassTransformation(mapping.getDescriptor(), mapping.getAttributeName(), methodName);
                }
                this.getFieldDefFromDBField(classTransformation.getField()).setType(returnType);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw ValidationException.missingTransformerMethodForDDLGenerationOfClassTransformation(mapping.getDescriptor(), mapping.getAttributeName(), methodName);
            }
        }
    }

    protected void createAggregateTargetTable(AggregateCollectionMapping mapping) {
        FieldDefinition fieldDef;
        TableDefinition targetTable = this.getTableDefFromDBTable(mapping.getReferenceDescriptor().getDefaultTable());
        this.addFieldsForMappedKeyMapContainerPolicy(mapping.getContainerPolicy(), targetTable);
        for (DatabaseField dbField : mapping.getReferenceDescriptor().getFields()) {
            FieldDefinition fieldDef2 = this.getFieldDefFromDBField(dbField);
            if (targetTable.getFields().contains(fieldDef2)) continue;
            targetTable.addField(fieldDef2);
        }
        ArrayList<String> fkFieldNames = new ArrayList<String>();
        ArrayList<String> targetFieldNames = new ArrayList<String>();
        Vector<DatabaseField> fkFields = mapping.getTargetForeignKeyFields();
        Vector<DatabaseField> targetFields = mapping.getSourceKeyFields();
        DatabaseField targetField = null;
        int index2 = 0;
        while (index2 < fkFields.size()) {
            DatabaseField fkField = (DatabaseField)fkFields.get(index2);
            targetField = (DatabaseField)targetFields.get(index2);
            fkFieldNames.add(fkField.getNameDelimited(this.databasePlatform));
            targetFieldNames.add(targetField.getNameDelimited(this.databasePlatform));
            fkField = this.resolveDatabaseField(fkField, targetField);
            fieldDef = this.getFieldDefFromDBField(fkField);
            if (!targetTable.getFields().contains(fieldDef)) {
                targetTable.addField(fieldDef);
            }
            ++index2;
        }
        DatabaseTable sourceDatabaseTable = targetField.getTable();
        TableDefinition sourceTable = this.getTableDefFromDBTable(sourceDatabaseTable);
        if (mapping.getListOrderField() != null) {
            fieldDef = this.getFieldDefFromDBField(mapping.getListOrderField());
            TableDefinition table = this.getTableDefFromDBTable(mapping.getListOrderField().getTable());
            if (!table.getFields().contains(fieldDef)) {
                table.addField(fieldDef);
            }
        }
        if (mapping.getDescriptor().hasTablePerClassPolicy()) {
            return;
        }
        this.addForeignKeyConstraint(targetTable, sourceTable, fkFieldNames, targetFieldNames, mapping.isCascadeOnDeleteSetOnDatabase());
    }

    protected void addForeignKeyFieldToSourceTargetTable(OneToOneMapping mapping) {
        if (!mapping.isForeignKeyRelationship() || mapping.getReferenceDescriptor().hasTablePerClassPolicy() && mapping.getReferenceDescriptor().getTablePerClassPolicy().hasChild()) {
            return;
        }
        boolean cascadeDelete = false;
        for (DatabaseField foreignKey : mapping.getSourceToTargetKeyFields().values()) {
            DatabaseMapping mappedBy = mapping.getReferenceDescriptor().getObjectBuilder().getMappingForField(foreignKey);
            if (mappedBy != null && mappedBy.isOneToOneMapping()) {
                cascadeDelete = ((OneToOneMapping)mappedBy).isCascadeOnDeleteSetOnDatabase();
            } else {
                List<DatabaseMapping> readOnlyMappings = mapping.getReferenceDescriptor().getObjectBuilder().getReadOnlyMappingsForField(foreignKey);
                if (readOnlyMappings != null) {
                    for (DatabaseMapping mappedByPK : readOnlyMappings) {
                        if (mappedByPK.isOneToOneMapping() && (cascadeDelete = ((OneToOneMapping)mappedByPK).isCascadeOnDeleteSetOnDatabase())) break;
                    }
                }
            }
            if (cascadeDelete) break;
        }
        if (!mapping.isOptional() || !mapping.isOneToOnePrimaryKeyRelationship()) {
            this.addForeignMappingFkConstraint(mapping.getSourceToTargetKeyFields(), cascadeDelete);
        }
    }

    protected void addForeignKeyFieldToSourceTargetTable(OneToManyMapping mapping) {
        if (mapping.getDescriptor().hasTablePerClassPolicy()) {
            return;
        }
        this.addForeignMappingFkConstraint(mapping.getTargetForeignKeysToSourceKeys(), mapping.isCascadeOnDeleteSetOnDatabase());
        if (mapping.getListOrderField() != null) {
            FieldDefinition fieldDef = this.getFieldDefFromDBField(mapping.getListOrderField());
            TableDefinition table = this.getTableDefFromDBTable(mapping.getListOrderField().getTable());
            if (!table.getFields().contains(fieldDef)) {
                table.addField(fieldDef);
            }
        }
    }

    protected void addForeignMappingFkConstraint(Map<DatabaseField, DatabaseField> srcFields, boolean cascadeOnDelete) {
        if (srcFields.size() == 0) {
            return;
        }
        ArrayList<DatabaseField> fkFields = new ArrayList<DatabaseField>();
        ArrayList<DatabaseField> targetFields = new ArrayList<DatabaseField>();
        for (DatabaseField fkField : srcFields.keySet()) {
            fkFields.add(fkField);
            targetFields.add(srcFields.get(fkField));
        }
        this.addJoinColumnsFkConstraint(fkFields, targetFields, cascadeOnDelete);
    }

    protected TableDefinition getTableDefFromDBTable(DatabaseTable databaseTable) {
        TableDefinition tableDefinition = this.tableMap.get(databaseTable.getName());
        if (tableDefinition == null) {
            tableDefinition = new TableDefinition();
            tableDefinition.setTable(databaseTable);
            tableDefinition.setName(databaseTable.getNameDelimited(this.databasePlatform));
            tableDefinition.setQualifier(databaseTable.getTableQualifier());
            if (databaseTable.hasUniqueConstraints()) {
                this.addUniqueKeyConstraints(tableDefinition, databaseTable.getUniqueConstraints());
            }
            if (databaseTable.hasIndexes()) {
                tableDefinition.getIndexes().addAll(databaseTable.getIndexes());
            }
            if (databaseTable.getCreationSuffix() != null) {
                tableDefinition.setCreationSuffix(databaseTable.getCreationSuffix());
            }
            if (databaseTable.hasForeignKeyConstraints()) {
                tableDefinition.setUserDefinedForeignKeyConstraints(databaseTable.getForeignKeyConstraints());
            }
            this.tableMap.put(databaseTable.getName(), tableDefinition);
        }
        return tableDefinition;
    }

    protected DatabaseField resolveDatabaseField(DatabaseField childField, DatabaseField parentField) {
        DatabaseField resolvedDatabaseField = new DatabaseField();
        DatabaseField resolvedParentField = this.databaseFields.get(parentField);
        resolvedDatabaseField.setName(childField.getName());
        resolvedDatabaseField.setTable(childField.getTable());
        if (resolvedParentField != null) {
            resolvedDatabaseField.setType(resolvedParentField.getType());
            resolvedDatabaseField.setScale(resolvedParentField.getScale());
            resolvedDatabaseField.setLength(resolvedParentField.getLength());
            resolvedDatabaseField.setPrecision(resolvedParentField.getPrecision());
        }
        resolvedDatabaseField.setUnique(childField.isUnique());
        resolvedDatabaseField.setNullable(childField.isNullable());
        resolvedDatabaseField.setUpdatable(childField.isUpdatable());
        resolvedDatabaseField.setInsertable(childField.isInsertable());
        resolvedDatabaseField.setUseDelimiters(childField.shouldUseDelimiters());
        resolvedDatabaseField.useUpperCaseForComparisons(childField.getUseUpperCaseForComparisons());
        resolvedDatabaseField.setNameForComparisons(childField.getNameForComparisons());
        String columnDef = childField.getColumnDefinition();
        if (columnDef == null || columnDef.trim().equals("")) {
            if (resolvedParentField != null) {
                resolvedDatabaseField.setColumnDefinition(resolvedParentField.getColumnDefinition());
            }
        } else {
            resolvedDatabaseField.setColumnDefinition(columnDef);
        }
        return resolvedDatabaseField;
    }

    protected FieldDefinition getFieldDefFromDBField(DatabaseField dbField) {
        FieldDefinition fieldDef = this.fieldMap.get(dbField);
        if (fieldDef == null) {
            fieldDef = new FieldDefinition();
            fieldDef.setName(dbField.getNameDelimited(this.databasePlatform));
            fieldDef.setDatabaseField(dbField);
            if (dbField.getColumnDefinition() != null && dbField.getColumnDefinition().length() > 0) {
                fieldDef.setTypeDefinition(dbField.getColumnDefinition());
            } else {
                FieldTypeDefinition fieldTypeDef;
                Class fieldType = dbField.getType();
                FieldTypeDefinition fieldTypeDefinition = fieldTypeDef = fieldType == null ? null : this.databasePlatform.getFieldTypeDefinition(fieldType);
                if (fieldType != null) {
                    if (dbField.getLength() > 0) {
                        fieldDef.setSize(dbField.getLength());
                    } else if (dbField.getPrecision() > 0) {
                        fieldDef.setSize(dbField.getPrecision());
                        fieldDef.setSubSize(dbField.getScale());
                    }
                }
                if (fieldType == null || !fieldType.isPrimitive() && fieldTypeDef == null) {
                    AbstractSessionLog.getLog().log(4, "metadata", "field_type_set_to_java_lang_string", (Object)dbField.getQualifiedName(), (Object)fieldType);
                    fieldDef.setType(ClassConstants.STRING);
                } else {
                    fieldDef.setType(ConversionManager.getObjectClass(fieldType));
                }
                fieldDef.setShouldAllowNull(dbField.isNullable());
                fieldDef.setUnique(dbField.isUnique());
            }
            this.fieldMap.put(dbField, fieldDef);
            this.databaseFields.put(dbField, dbField);
        }
        return fieldDef;
    }

    protected void setFieldToRelationTable(DatabaseField dbField, TableDefinition table) {
        FieldDefinition fieldDef = this.getFieldDefFromDBField(dbField);
        if (!table.getFields().contains(fieldDef)) {
            table.addField(this.getFieldDefFromDBField(dbField));
            fieldDef.setIsPrimaryKey(true);
        }
    }

    protected void processAdditionalTablePkFields(ClassDescriptor descriptor) {
        if (!descriptor.hasMultipleTables()) {
            return;
        }
        DatabaseTable databaseTable2 = null;
        for (DatabaseTable databaseTable2 : descriptor.getTables()) {
            Map<DatabaseField, DatabaseField> srcFields = descriptor.getAdditionalTablePrimaryKeyFields().get(databaseTable2);
            if (srcFields == null || srcFields.size() <= 0) continue;
            ArrayList<DatabaseField> fkFields = new ArrayList<DatabaseField>();
            ArrayList<DatabaseField> pkFields = new ArrayList<DatabaseField>();
            for (DatabaseField pkField : srcFields.keySet()) {
                pkFields.add(pkField);
                fkFields.add(srcFields.get(pkField));
            }
            this.addJoinColumnsFkConstraint(fkFields, pkFields, descriptor.isCascadeOnDeleteSetOnDatabaseOnSecondaryTables());
        }
    }

    protected void addJoinColumnsFkConstraint(List<DatabaseField> fkFields, List<DatabaseField> targetFields, boolean cascadeOnDelete) {
        assert (fkFields.size() == targetFields.size());
        if (fkFields.size() == 0) {
            return;
        }
        DatabaseField fkField = null;
        DatabaseField targetField = null;
        ArrayList<String> fkFieldNames = new ArrayList<String>();
        ArrayList<String> targetFieldNames = new ArrayList<String>();
        DatabaseTable sourceTable = fkFields.get(0).getTable();
        TableDefinition sourceTableDef = this.getTableDefFromDBTable(sourceTable);
        int i = 0;
        while (i < fkFields.size()) {
            fkField = fkFields.get(i);
            targetField = targetFields.get(i);
            fkFieldNames.add(fkField.getNameDelimited(this.databasePlatform));
            targetFieldNames.add(targetField.getNameDelimited(this.databasePlatform));
            FieldDefinition fkFieldDef = this.fieldMap.get(fkField);
            FieldDefinition targetFieldDef = this.fieldMap.get(targetField);
            if (targetFieldDef != null) {
                if (fkFieldDef == null) {
                    fkFieldDef = this.getFieldDefFromDBField(fkField);
                    if (!sourceTableDef.getFields().contains(fkFieldDef)) {
                        sourceTableDef.addField(fkFieldDef);
                    }
                }
                if (fkFieldDef.getTypeDefinition() == null || fkFieldDef.getTypeDefinition().trim().equals("")) {
                    fkFieldDef.setTypeDefinition(targetFieldDef.getTypeDefinition());
                }
                fkFieldDef.setType(targetFieldDef.getType());
                fkFieldDef.setSize(targetFieldDef.getSize());
                fkFieldDef.setSubSize(targetFieldDef.getSubSize());
            }
            ++i;
        }
        DatabaseTable targetTable = targetField.getTable();
        TableDefinition targetTableDef = this.getTableDefFromDBTable(targetTable);
        this.addForeignKeyConstraint(sourceTableDef, targetTableDef, fkFieldNames, targetFieldNames, cascadeOnDelete);
    }

    protected void addForeignKeyConstraint(TableDefinition sourceTableDef, TableDefinition targetTableDef, List<String> fkFields, List<String> targetFields, boolean cascadeOnDelete) {
        if (!this.generateFKConstraints) {
            return;
        }
        assert (fkFields.size() > 0 && fkFields.size() == targetFields.size());
        List<String> fkFieldNames = fkFields;
        List<String> targetFieldNames = targetFields;
        if (fkFields.size() > 1) {
            boolean resolved = false;
            boolean error = false;
            LinkedHashMap<String, String> targetToFkField = new LinkedHashMap<String, String>();
            int index2 = 0;
            while (index2 < fkFields.size()) {
                String targetField = targetFields.get(index2);
                if (targetToFkField.containsKey(targetField)) {
                    error = true;
                    break;
                }
                targetToFkField.put(targetField, fkFields.get(index2));
                ++index2;
            }
            ArrayList<String> orderedFkFields = new ArrayList<String>(fkFields.size());
            ArrayList<String> orderedTargetFields = new ArrayList<String>(targetFields.size());
            if (!error) {
                resolved = true;
                for (String pkField : targetTableDef.getPrimaryKeyFieldNames()) {
                    String fkField = (String)targetToFkField.get(pkField);
                    if (fkField == null) {
                        resolved = false;
                        break;
                    }
                    orderedFkFields.add(fkField);
                    orderedTargetFields.add(pkField);
                }
            }
            if (!error && !resolved) {
                for (UniqueKeyConstraint uniqueConstraint : targetTableDef.getUniqueKeys()) {
                    orderedFkFields.clear();
                    orderedTargetFields.clear();
                    resolved = true;
                    for (String ukField : uniqueConstraint.getSourceFields()) {
                        String fkField = (String)targetToFkField.get(ukField);
                        if (fkField == null) {
                            resolved = false;
                            break;
                        }
                        orderedFkFields.add(fkField);
                        orderedTargetFields.add(ukField);
                    }
                    if (resolved) break;
                }
            }
            if (resolved) {
                fkFieldNames = orderedFkFields;
                targetFieldNames = orderedTargetFields;
            }
        }
        ForeignKeyConstraint constraint = sourceTableDef.buildForeignKeyConstraint(fkFieldNames, targetFieldNames, targetTableDef, this.databasePlatform);
        constraint.setShouldCascadeOnDelete(cascadeOnDelete);
        sourceTableDef.addForeignKeyConstraint(constraint);
    }

    protected void addUniqueKeyConstraints(TableDefinition sourceTableDef, Map<String, List<List<String>>> uniqueConstraintsMap) {
        int serialNumber = -1;
        for (String name : uniqueConstraintsMap.keySet()) {
            List<List<String>> uniqueConstraints = uniqueConstraintsMap.get(name);
            for (List<String> uniqueConstraint : uniqueConstraints) {
                if (uniqueConstraint == null) continue;
                if (name == null || name.equals("")) {
                    ++serialNumber;
                }
                sourceTableDef.addUniqueKeyConstraint(sourceTableDef.buildUniqueKeyConstraint(name, uniqueConstraint, serialNumber, this.databasePlatform));
            }
        }
    }
}

