/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sequencing;

import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sequencing.Sequence;

public abstract class StandardSequence
extends Sequence {
    public StandardSequence() {
    }

    public StandardSequence(String name) {
        super(name);
    }

    public StandardSequence(String name, int size2) {
        super(name, size2);
    }

    public StandardSequence(String name, int size2, int initialValue) {
        super(name, size2, initialValue);
    }

    @Override
    public void onConnect() {
    }

    @Override
    public void onDisconnect() {
    }

    protected abstract Number updateAndSelectSequence(Accessor var1, AbstractSession var2, String var3, int var4);

    @Override
    public abstract boolean shouldAcquireValueAfterInsert();

    @Override
    public abstract boolean shouldUseTransaction();

    @Override
    public Object getGeneratedValue(Accessor accessor, AbstractSession writeSession, String seqName) {
        if (this.shouldUsePreallocation()) {
            return null;
        }
        Number value2 = this.updateAndSelectSequence(accessor, writeSession, seqName, 1);
        if (value2 == null) {
            throw DatabaseException.errorPreallocatingSequenceNumbers();
        }
        return value2;
    }

    @Override
    public Vector getGeneratedVector(Accessor accessor, AbstractSession writeSession, String seqName, int size2) {
        if (this.shouldUsePreallocation()) {
            Number value2 = this.updateAndSelectSequence(accessor, writeSession, seqName, size2);
            if (value2 == null) {
                throw DatabaseException.errorPreallocatingSequenceNumbers();
            }
            return this.createVector(value2, seqName, size2);
        }
        return null;
    }

    protected Vector createVector(Number sequence2, String seqName, int size2) {
        long nextSequence = sequence2.longValue();
        Vector<Long> sequencesForName = new Vector<Long>(size2);
        if ((nextSequence -= (long)size2) < -1L) {
            throw ValidationException.sequenceSetupIncorrectly(seqName);
        }
        int index2 = size2;
        while (index2 > 0) {
            sequencesForName.add(++nextSequence);
            --index2;
        }
        return sequencesForName;
    }

    @Override
    public void setInitialValue(int initialValue) {
        if (initialValue <= 0) {
            initialValue = 1;
        }
        super.setInitialValue(initialValue);
    }
}

