/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.sequenced;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.core.mappings.CoreMapping;

public class Setting {
    private String name;
    private String namespaceURI;
    private Object value;
    private Object object;
    private CoreMapping mapping;
    private Setting parent;
    private List<Setting> children;

    public Setting() {
    }

    public Setting(String namespaceURI, String name) {
        this.setNamespaceURI(namespaceURI);
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value2) {
        this.setValue(value2, true);
    }

    public void setValue(Object value2, boolean updateObject) {
        this.value = value2;
        if (updateObject) {
            if (this.children != null) {
                return;
            }
            if (!this.mapping.isWriteOnly()) {
                this.mapping.setAttributeValueInObject(this.object, value2);
            }
        }
    }

    public void addValue(Object value2, boolean updateObject, Object container) {
        this.value = value2;
        if (updateObject) {
            if (this.children != null) {
                return;
            }
            Object containerPolicy = this.mapping.getContainerPolicy();
            if (container == null && !this.mapping.isWriteOnly()) {
                container = containerPolicy.containerInstance();
                this.mapping.setAttributeValueInObject(this.object, container);
            }
            containerPolicy.addInto(value2, container, null);
        }
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public CoreMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(CoreMapping mapping) {
        this.mapping = mapping;
    }

    public void addChild(Setting childSetting) {
        childSetting.setParent(this);
        if (this.children == null) {
            this.children = new ArrayList<Setting>();
        }
        this.children.add(childSetting);
    }

    public Setting getParent() {
        return this.parent;
    }

    public void setParent(Setting parentSetting) {
        this.parent = parentSetting;
    }

    public List<Setting> getChildren() {
        return this.children;
    }

    public Setting copy() {
        Setting copy = new Setting();
        copy.setName(this.name);
        copy.setNamespaceURI(this.namespaceURI);
        copy.setObject(this.object);
        copy.setMapping(this.mapping);
        copy.setValue(this.value, false);
        if (this.children != null) {
            int index2 = 0;
            int size2 = this.children.size();
            while (index2 < size2) {
                copy.addChild(this.children.get(index2).copy());
                ++index2;
            }
        }
        return copy;
    }

    public Setting copy(Object newParent) {
        Setting copy = new Setting();
        copy.setName(this.name);
        copy.setNamespaceURI(this.namespaceURI);
        if (this.getObject() != null) {
            copy.setObject(newParent);
        }
        copy.setMapping(this.mapping);
        copy.setValue(this.value, false);
        if (this.children != null) {
            int index2 = 0;
            int size2 = this.children.size();
            while (index2 < size2) {
                copy.addChild(this.children.get(index2).copy(newParent));
                ++index2;
            }
        }
        return copy;
    }

    public Setting copy(Object newParent, Object copyValue) {
        Setting copy = new Setting();
        copy.setName(this.name);
        copy.setNamespaceURI(this.namespaceURI);
        if (this.getObject() != null) {
            copy.setObject(newParent);
        }
        copy.setMapping(this.mapping);
        copy.setValue(copyValue, false);
        if (this.children != null) {
            int index2 = 0;
            int size2 = this.children.size();
            while (index2 < size2) {
                copy.addChild(this.children.get(index2).copy(newParent, copyValue));
                ++index2;
            }
        }
        return copy;
    }
}

