/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.stream.JsonGenerator;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.oxm.record.JsonRecord;

public class JsonGeneratorRecord
extends JsonRecord<JsonRecord.Level> {
    private JsonGenerator jsonGenerator;
    private String rootKeyName;

    public JsonGeneratorRecord(JsonGenerator generator, String rootKeyName) {
        this.jsonGenerator = generator;
        this.rootKeyName = rootKeyName;
    }

    @Override
    protected void startRootObject() {
        super.startRootObject();
        this.position.setKeyName(this.rootKeyName);
        this.setComplex(this.position, true);
    }

    @Override
    protected void finishLevel() {
        if (!this.position.isCollection || !this.position.isEmptyCollection() || this.position.getKeyName() != null) {
            this.jsonGenerator.writeEnd();
        }
        super.finishLevel();
    }

    @Override
    protected void startRootLevelCollection() {
        if (this.rootKeyName != null) {
            this.jsonGenerator.writeStartArray(this.rootKeyName);
        } else {
            this.jsonGenerator.writeStartArray();
        }
    }

    @Override
    public void endCollection() {
        this.finishLevel();
    }

    @Override
    protected void setComplex(JsonRecord.Level level, boolean complex) {
        boolean isAlreadyComplex = level.isComplex;
        super.setComplex(level, complex);
        if (complex && !isAlreadyComplex) {
            JsonRecord.Level parentLevel = level.parentLevel;
            if (parentLevel != null && parentLevel.isCollection && parentLevel.isEmptyCollection()) {
                parentLevel.setEmptyCollection(false);
            }
            if (parentLevel != null && parentLevel.isCollection && !parentLevel.isEmptyCollection() || level.keyName == null) {
                this.jsonGenerator.writeStartObject();
            } else {
                this.jsonGenerator.writeStartObject(level.keyName);
            }
        }
    }

    @Override
    protected void startEmptyCollection() {
        this.jsonGenerator.writeStartArray(this.position.keyName);
    }

    @Override
    protected void writeEmptyCollection(JsonRecord.Level level, String keyName) {
        this.jsonGenerator.writeStartArray(keyName);
        this.jsonGenerator.writeEnd();
    }

    @Override
    protected void addValueToObject(JsonRecord.Level level, String keyName, Object value2, QName schemaType) {
        if (value2 == "null") {
            this.jsonGenerator.writeNull(keyName);
        } else if (value2 instanceof Integer) {
            this.jsonGenerator.write(keyName, (Integer)value2);
        } else if (value2 instanceof BigDecimal) {
            this.jsonGenerator.write(keyName, (BigDecimal)value2);
        } else if (value2 instanceof BigInteger) {
            this.jsonGenerator.write(keyName, (BigInteger)value2);
        } else if (value2 instanceof Boolean) {
            this.jsonGenerator.write(keyName, (Boolean)value2);
        } else if (value2 instanceof Character) {
            this.jsonGenerator.write(keyName, ((Character)value2).charValue());
        } else if (value2 instanceof Double) {
            this.jsonGenerator.write(keyName, (Double)value2);
        } else if (value2 instanceof Float) {
            this.jsonGenerator.write(keyName, ((Float)value2).floatValue());
        } else if (value2 instanceof Long) {
            this.jsonGenerator.write(keyName, (Long)value2);
        } else if (value2 instanceof String) {
            this.jsonGenerator.write(keyName, (String)value2);
        } else {
            ConversionManager conversionManager = this.getConversionManager();
            String convertedValue = (String)conversionManager.convertObject(value2, CoreClassConstants.STRING, schemaType);
            Class<?> theClass = conversionManager.javaType(schemaType);
            if ((schemaType == null || theClass == null) && CoreClassConstants.NUMBER.isAssignableFrom(value2.getClass())) {
                BigDecimal convertedNumberValue = (BigDecimal)((ConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value2, CoreClassConstants.BIGDECIMAL, schemaType);
                this.jsonGenerator.write(keyName, convertedNumberValue);
            } else {
                this.jsonGenerator.write(keyName, convertedValue);
            }
        }
    }

    @Override
    protected void addValueToArray(JsonRecord.Level level, Object value2, QName schemaType) {
        if (value2 == "null") {
            this.jsonGenerator.writeNull();
        } else if (value2 instanceof Integer) {
            this.jsonGenerator.write((Integer)value2);
        } else if (value2 instanceof BigDecimal) {
            this.jsonGenerator.write((BigDecimal)value2);
        } else if (value2 instanceof BigInteger) {
            this.jsonGenerator.write((BigInteger)value2);
        } else if (value2 instanceof Boolean) {
            this.jsonGenerator.write((Boolean)value2);
        } else if (value2 instanceof Character) {
            this.jsonGenerator.write(((Character)value2).charValue());
        } else if (value2 instanceof Double) {
            this.jsonGenerator.write((Double)value2);
        } else if (value2 instanceof Float) {
            this.jsonGenerator.write(((Float)value2).floatValue());
        } else if (value2 instanceof Long) {
            this.jsonGenerator.write((Long)value2);
        } else if (value2 instanceof String) {
            this.jsonGenerator.write((String)value2);
        } else {
            ConversionManager conversionManager = this.getConversionManager();
            String convertedValue = (String)conversionManager.convertObject(value2, CoreClassConstants.STRING, schemaType);
            Class<?> theClass = conversionManager.javaType(schemaType);
            if ((schemaType == null || theClass == null) && CoreClassConstants.NUMBER.isAssignableFrom(value2.getClass())) {
                BigDecimal convertedNumberValue = (BigDecimal)((ConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value2, CoreClassConstants.BIGDECIMAL, schemaType);
                this.jsonGenerator.write(convertedNumberValue);
            } else {
                this.jsonGenerator.write(convertedValue);
            }
        }
    }
}

