/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.DeferrableChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;

public class DirectCollectionChangeRecord
extends DeferrableChangeRecord
implements org.eclipse.persistence.sessions.changesets.DirectCollectionChangeRecord {
    protected HashMap addObjectMap;
    protected HashMap removeObjectMap;
    protected HashMap commitAddMap;
    protected Map changedIndexes;
    protected int oldSize;
    protected int newSize;
    protected boolean isFirstToAddAlreadyInCollection;
    protected boolean isFirstToRemoveAlreadyOutCollection;
    protected boolean isFirstToAdd = true;
    protected boolean isFirstToRemove = true;
    protected boolean orderHasBeenRepaired;

    public DirectCollectionChangeRecord() {
    }

    public DirectCollectionChangeRecord(ObjectChangeSet owner) {
        this.owner = owner;
    }

    public void addAdditionChange(HashMap additions, HashMap databaseCount) {
        for (Object object : additions.keySet()) {
            if (databaseCount.containsKey(object)) {
                this.getCommitAddMap().put(object, databaseCount.get(object));
            }
            this.addAdditionChange(object, (Integer)additions.get(object));
        }
    }

    public void addAdditionChange(Object key, Integer count2) {
        int addValue;
        if (this.getRemoveObjectMap().containsKey(key)) {
            int addition;
            int removeValue = (Integer)this.getRemoveObjectMap().get(key);
            int result2 = removeValue - (addition = count2.intValue());
            if (result2 > 0) {
                this.getRemoveObjectMap().put(key, result2);
            } else if (result2 < 0) {
                this.getRemoveObjectMap().remove(key);
                this.getAddObjectMap().put(key, Math.abs(result2));
            } else {
                this.getRemoveObjectMap().remove(key);
            }
        } else if (this.getAddObjectMap().containsKey(key)) {
            addValue = (Integer)this.getAddObjectMap().get(key);
            this.getAddObjectMap().put(key, addValue += count2.intValue());
        } else {
            this.getAddObjectMap().put(key, count2);
        }
        if (this.isFirstToAdd) {
            this.isFirstToAdd = false;
            if (this.isFirstToAddAlreadyInCollection) {
                return;
            }
        }
        addValue = count2;
        int commitValue = 0;
        if (this.getCommitAddMap().containsKey(key)) {
            commitValue = (Integer)this.getCommitAddMap().get(key);
        }
        this.getCommitAddMap().put(key, addValue + commitValue);
    }

    public void addRemoveChange(HashMap additions, HashMap databaseCount) {
        for (Object object : additions.keySet()) {
            if (databaseCount.containsKey(object)) {
                this.getCommitAddMap().put(object, databaseCount.get(object));
            }
            this.addRemoveChange(object, (Integer)additions.get(object));
        }
    }

    public void addRemoveChange(Object key, Integer count2) {
        int removeValue;
        if (this.getAddObjectMap().containsKey(key)) {
            int addition;
            removeValue = (Integer)this.getAddObjectMap().get(key);
            int result2 = removeValue - (addition = count2.intValue());
            if (result2 > 0) {
                this.getAddObjectMap().put(key, result2);
            } else if (result2 < 0) {
                this.getAddObjectMap().remove(key);
                this.getRemoveObjectMap().put(key, Math.abs(result2));
            } else {
                this.getAddObjectMap().remove(key);
            }
        } else if (this.getRemoveObjectMap().containsKey(key)) {
            int addValue = (Integer)this.getRemoveObjectMap().get(key);
            this.getRemoveObjectMap().put(key, addValue += count2.intValue());
        } else {
            this.getRemoveObjectMap().put(key, count2);
        }
        if (this.isFirstToRemove) {
            this.isFirstToRemove = false;
            if (this.isFirstToRemoveAlreadyOutCollection) {
                return;
            }
        }
        removeValue = count2;
        int commitValue = 0;
        if (this.getCommitAddMap().containsKey(key)) {
            commitValue = (Integer)this.getCommitAddMap().get(key);
        }
        this.getCommitAddMap().put(key, commitValue - removeValue);
    }

    public void setCommitAddition(Hashtable additions) {
        Enumeration enumtr = additions.keys();
        while (enumtr.hasMoreElements()) {
            Object object = enumtr.nextElement();
            this.getCommitAddMap().put(object, additions.get(object));
        }
    }

    public void storeDatabaseCounts(Object collection, ContainerPolicy containerPolicy, AbstractSession session) {
        Object iterator2 = containerPolicy.iteratorFor(collection);
        while (containerPolicy.hasNext(iterator2)) {
            Object object = containerPolicy.next(iterator2, session);
            this.incrementDatabaseCount(object);
        }
    }

    public void incrementDatabaseCount(Object object) {
        if (this.getCommitAddMap().containsKey(object)) {
            int count2 = (Integer)this.getCommitAddMap().get(object);
            this.getCommitAddMap().put(object, ++count2);
        } else {
            this.getCommitAddMap().put(object, 1);
        }
    }

    public void decrementDatabaseCount(Object object) {
        if (this.getCommitAddMap().containsKey(object)) {
            int count2 = (Integer)this.getCommitAddMap().get(object);
            if (count2 > 1) {
                this.getCommitAddMap().put(object, --count2);
            } else {
                this.getCommitAddMap().remove(object);
            }
        }
    }

    @Override
    public Vector getAddObjectList() {
        Vector vector = new Vector();
        for (Object object : this.getAddObjectMap().keySet()) {
            int count2 = (Integer)this.getAddObjectMap().get(object);
            while (count2 > 0) {
                vector.add(object);
                --count2;
            }
        }
        return vector;
    }

    public HashMap getAddObjectMap() {
        if (this.addObjectMap == null) {
            this.addObjectMap = new HashMap(1);
        }
        return this.addObjectMap;
    }

    public HashMap getCommitAddMap() {
        if (this.commitAddMap == null) {
            this.commitAddMap = new HashMap(1);
        }
        return this.commitAddMap;
    }

    @Override
    public Vector getRemoveObjectList() {
        Vector vector = new Vector();
        for (Object object : this.getRemoveObjectMap().keySet()) {
            int count2 = (Integer)this.getRemoveObjectMap().get(object);
            while (count2 > 0) {
                vector.add(object);
                --count2;
            }
        }
        return vector;
    }

    public HashMap getRemoveObjectMap() {
        if (this.removeObjectMap == null) {
            this.removeObjectMap = new HashMap(1);
        }
        return this.removeObjectMap;
    }

    public boolean hasChanges() {
        return this.addObjectMap != null && !this.addObjectMap.isEmpty() || this.removeObjectMap != null && !this.removeObjectMap.isEmpty() || this.changedIndexes != null && !this.changedIndexes.isEmpty() || this.getOwner().isNew();
    }

    @Override
    public void mergeRecord(ChangeRecord mergeFromRecord, UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        if (((DeferrableChangeRecord)mergeFromRecord).isDeferred()) {
            if (this.hasChanges()) {
                ((DeferrableChangeRecord)mergeFromRecord).getMapping().calculateDeferredChanges(mergeFromRecord, mergeToChangeSet.getSession());
            } else {
                this.isDeferred = true;
                this.originalCollection = ((DeferrableChangeRecord)mergeFromRecord).originalCollection;
                this.latestCollection = ((DeferrableChangeRecord)mergeFromRecord).latestCollection;
                return;
            }
        }
        HashMap addMapToMerge = ((DirectCollectionChangeRecord)mergeFromRecord).getAddObjectMap();
        HashMap removeMapToMerge = ((DirectCollectionChangeRecord)mergeFromRecord).getRemoveObjectMap();
        for (Object added : addMapToMerge.keySet()) {
            if (!((DirectCollectionChangeRecord)mergeFromRecord).getCommitAddMap().containsKey(added)) {
                this.getCommitAddMap().put(added, ((DirectCollectionChangeRecord)mergeFromRecord).getCommitAddMap().get(added));
            }
            this.addAdditionChange(added, (Integer)addMapToMerge.get(added));
        }
        for (Object removed : removeMapToMerge.keySet()) {
            if (!((DirectCollectionChangeRecord)mergeFromRecord).getCommitAddMap().containsKey(removed)) {
                this.getCommitAddMap().put(removed, ((DirectCollectionChangeRecord)mergeFromRecord).getCommitAddMap().get(removed));
            }
            this.addRemoveChange(removed, (Integer)removeMapToMerge.get(removed));
        }
        if (this.changedIndexes != null) {
            if (((DirectCollectionChangeRecord)mergeFromRecord).getChangedIndexes() != null) {
                for (Map.Entry entry2 : ((DirectCollectionChangeRecord)mergeFromRecord).getChangedIndexes().entrySet()) {
                    Object obj = entry2.getValue();
                    Set[] indexes = (Set[])entry2.getValue();
                    if (this.changedIndexes.containsKey(obj)) {
                        ((Set[])this.changedIndexes.get(obj))[1] = indexes[1];
                        continue;
                    }
                    this.changedIndexes.put(obj, indexes);
                }
                this.newSize = ((DirectCollectionChangeRecord)mergeFromRecord).getNewSize();
            }
        } else if (((DirectCollectionChangeRecord)mergeFromRecord).getChangedIndexes() != null) {
            this.changedIndexes = new HashMap(((DirectCollectionChangeRecord)mergeFromRecord).getChangedIndexes());
            this.oldSize = ((DirectCollectionChangeRecord)mergeFromRecord).getOldSize();
            this.newSize = ((DirectCollectionChangeRecord)mergeFromRecord).getNewSize();
        }
    }

    @Override
    public void updateReferences(UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
    }

    public void setFirstToAddAlreadyInCollection(boolean flag) {
        this.isFirstToAddAlreadyInCollection = flag;
    }

    public boolean isFirstToAddAlreadyInCollection() {
        return this.isFirstToAddAlreadyInCollection;
    }

    public void setFirstToRemoveAlreadyOutCollection(boolean flag) {
        this.isFirstToRemoveAlreadyOutCollection = flag;
    }

    public boolean isFirstToRemoveAlreadyOutCollection() {
        return this.isFirstToRemoveAlreadyOutCollection;
    }

    public void setChangedIndexes(Map changedIndexes) {
        this.changedIndexes = changedIndexes;
    }

    public Map getChangedIndexes() {
        return this.changedIndexes;
    }

    public void setOldSize(int size2) {
        this.oldSize = size2;
    }

    public int getOldSize() {
        return this.oldSize;
    }

    public void setNewSize(int size2) {
        this.newSize = size2;
    }

    public int getNewSize() {
        return this.newSize;
    }

    @Override
    public void internalRecreateOriginalCollection(Object currentCollection, AbstractSession session) {
        int i;
        int n;
        Object obj;
        ContainerPolicy cp = this.mapping.getContainerPolicy();
        if (this.removeObjectMap != null) {
            for (Map.Entry entry2 : this.removeObjectMap.entrySet()) {
                obj = entry2.getKey();
                n = (Integer)entry2.getValue();
                i = 0;
                while (i < n) {
                    cp.addInto(obj, currentCollection, session);
                    ++i;
                }
            }
        }
        if (this.addObjectMap != null) {
            for (Map.Entry entry2 : this.addObjectMap.entrySet()) {
                obj = entry2.getKey();
                n = (Integer)entry2.getValue();
                i = 0;
                while (i < n) {
                    cp.removeFrom(obj, currentCollection, session);
                    ++i;
                }
            }
        }
    }

    public void setOrderHasBeenRepaired(boolean hasBeenRepaired) {
        this.orderHasBeenRepaired = hasBeenRepaired;
    }

    public boolean orderHasBeenRepaired() {
        return this.orderHasBeenRepaired;
    }

    @Override
    public void clearChanges() {
        if (this.removeObjectMap != null) {
            this.removeObjectMap.clear();
        }
        if (this.addObjectMap != null) {
            this.addObjectMap.clear();
        }
        if (this.addObjectMap != null) {
            this.addObjectMap.clear();
        }
        if (this.removeObjectMap != null) {
            this.removeObjectMap.clear();
        }
        if (this.commitAddMap != null) {
            this.commitAddMap.clear();
        }
    }

    public static class NULL {
        public boolean equals(Object object) {
            return object instanceof NULL;
        }
    }
}

