/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.io.StringWriter;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class ArrayRecord
extends DatabaseRecord {
    protected DatabaseField[] fieldsArray;
    protected Object[] valuesArray;

    protected ArrayRecord() {
    }

    public ArrayRecord(Vector fields, DatabaseField[] fieldsArray, Object[] valuesArray) {
        super(fields, null, fieldsArray.length);
        this.fieldsArray = fieldsArray;
        this.valuesArray = valuesArray;
    }

    protected void checkValues() {
        if (this.values == null) {
            this.values = new NonSynchronizedVector(this.valuesArray.length);
            Object[] objectArray = this.valuesArray;
            int n = this.valuesArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object value2 = objectArray[n2];
                this.values.add(value2);
                ++n2;
            }
        }
    }

    @Override
    public void add(DatabaseField key, Object value2) {
        this.checkValues();
        this.fieldsArray = null;
        this.valuesArray = null;
        super.add(key, value2);
    }

    @Override
    public void clear() {
        this.fieldsArray = null;
        this.valuesArray = null;
        super.clear();
    }

    @Override
    public AbstractRecord clone() {
        this.checkValues();
        return super.clone();
    }

    @Override
    public boolean containsKey(DatabaseField key) {
        if (this.fieldsArray != null) {
            DatabaseField field2;
            int index2 = key.index;
            if (index2 >= 0 && index2 < this.size && ((field2 = this.fieldsArray[index2]) == key || field2.equals(key))) {
                return true;
            }
            DatabaseField[] databaseFieldArray = this.fieldsArray;
            int n = this.fieldsArray.length;
            int n2 = 0;
            while (n2 < n) {
                field2 = databaseFieldArray[n2];
                if (field2 == key || field2.equals(key)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return super.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value2) {
        if (this.valuesArray != null) {
            Object[] objectArray = this.valuesArray;
            int n = this.valuesArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object rowValue = objectArray[n2];
                if (value2 == rowValue || rowValue.equals(value2)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return super.containsValue(value2);
    }

    @Override
    public Object get(DatabaseField key) {
        if (this.fieldsArray != null) {
            DatabaseField field2;
            int index2 = key.index;
            if (index2 >= 0 && index2 < this.size && ((field2 = this.fieldsArray[index2]) == key || field2.equals(key))) {
                return this.valuesArray[index2];
            }
            int fieldIndex = 0;
            while (fieldIndex < this.size) {
                DatabaseField field3 = this.fieldsArray[fieldIndex];
                if (field3 == key || field3.equals(key)) {
                    if (index2 == -1) {
                        key.setIndex(fieldIndex);
                    }
                    return this.valuesArray[fieldIndex];
                }
                ++fieldIndex;
            }
            return null;
        }
        return super.get(key);
    }

    @Override
    public Object getIndicatingNoEntry(DatabaseField key) {
        if (this.fieldsArray != null) {
            DatabaseField field2;
            int index2 = key.index;
            if (index2 >= 0 && index2 < this.size && ((field2 = this.fieldsArray[index2]) == key || field2.equals(key))) {
                return this.valuesArray[index2];
            }
            int fieldIndex = 0;
            while (fieldIndex < this.size) {
                DatabaseField field3 = this.fieldsArray[fieldIndex];
                if (field3 == key || field3.equals(key)) {
                    if (index2 == -1) {
                        key.setIndex(fieldIndex);
                    }
                    return this.valuesArray[fieldIndex];
                }
                ++fieldIndex;
            }
            return AbstractRecord.noEntry;
        }
        return super.get(key);
    }

    @Override
    public DatabaseField getField(DatabaseField key) {
        if (this.fieldsArray != null) {
            DatabaseField field2;
            int index2 = key.index;
            if (index2 >= 0 && index2 < this.size && ((field2 = this.fieldsArray[index2]) == key || field2.equals(key))) {
                return field2;
            }
            int fieldIndex = 0;
            while (fieldIndex < this.size) {
                DatabaseField field3 = this.fieldsArray[fieldIndex];
                if (field3 == key || field3.equals(key)) {
                    return field3;
                }
                ++fieldIndex;
            }
            return null;
        }
        return super.getField(key);
    }

    public Vector getFields() {
        this.checkValues();
        return super.getFields();
    }

    @Override
    public Vector getValues() {
        this.checkValues();
        return super.getValues();
    }

    @Override
    public Object put(DatabaseField key, Object value2) {
        this.checkValues();
        this.fieldsArray = null;
        this.valuesArray = null;
        return super.put(key, value2);
    }

    @Override
    public Object remove(DatabaseField key) {
        this.checkValues();
        this.fieldsArray = null;
        this.valuesArray = null;
        return super.remove(key);
    }

    @Override
    public void replaceAt(Object value2, int index2) {
        if (this.valuesArray != null) {
            this.valuesArray[index2] = value2;
        } else {
            super.replaceAt(value2, index2);
        }
    }

    @Override
    public void replaceAt(Object value2, DatabaseField key) {
        if (this.fieldsArray != null) {
            DatabaseField field2;
            int index2 = key.index;
            if (index2 >= 0 && index2 < this.size && ((field2 = this.fieldsArray[index2]) == key || field2.equals(key))) {
                this.valuesArray[index2] = value2;
                return;
            }
            int fieldIndex = 0;
            while (fieldIndex < this.size) {
                DatabaseField field3 = this.fieldsArray[fieldIndex];
                if (field3 == key || field3.equals(key)) {
                    if (index2 == -1) {
                        key.setIndex(fieldIndex);
                    }
                    this.valuesArray[fieldIndex] = value2;
                    return;
                }
                ++fieldIndex;
            }
        } else {
            super.replaceAt(value2, key);
        }
    }

    @Override
    protected void setFields(Vector fields) {
        this.checkValues();
        this.fieldsArray = null;
        this.valuesArray = null;
        super.setFields(fields);
    }

    @Override
    protected void setValues(Vector values) {
        this.checkValues();
        this.fieldsArray = null;
        this.valuesArray = null;
        super.setValues(values);
    }

    @Override
    public int size() {
        if (this.fieldsArray == null) {
            return this.fields.size();
        }
        return this.fieldsArray.length;
    }

    @Override
    public String toString() {
        if (this.valuesArray != null) {
            StringWriter writer = new StringWriter();
            writer.write(Helper.getShortClassName(this.getClass()));
            writer.write("(");
            writer.write(this.toStringAditional());
            int index2 = 0;
            while (index2 < this.fieldsArray.length) {
                writer.write(Helper.cr());
                writer.write("\t");
                writer.write(String.valueOf(this.fieldsArray[index2]));
                writer.write(" => ");
                writer.write(String.valueOf(this.valuesArray[index2]));
                ++index2;
            }
            if (this.sopObject != null) {
                writer.write(Helper.cr());
                writer.write(" sopObject = ");
                writer.write(this.sopObject.toString());
            }
            writer.write(")");
            return writer.toString();
        }
        return super.toString();
    }

    protected String toStringAditional() {
        return "";
    }
}

