/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.json;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.MediaType;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.record.AbstractUnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.internal.oxm.record.XMLReaderAdapter;
import org.eclipse.persistence.internal.oxm.record.json.JsonStructureReader;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JsonParserReader
extends XMLReaderAdapter {
    private final JsonParser parser;
    private final JsonStructureReader structureReader;
    private final Deque<JsonStructureBuilder> stack = new ArrayDeque<JsonStructureBuilder>();

    private JsonParserReader(JsonParserReaderBuilder b) {
        this.parser = b.parser;
        this.structureReader = b.resultClass == null ? new JsonStructureReader(b.um) : new JsonStructureReader(b.um, b.resultClass);
    }

    @Override
    public void parse(InputSource input2) throws IOException, SAXException {
        if (input2 == null) {
            this.doParsing(this.parser);
            return;
        }
        if (input2.getCharacterStream() != null) {
            this.doParsing(Json.createParser(input2.getCharacterStream()));
            return;
        }
        try (InputStream inputStream = null;){
            inputStream = input2.getByteStream();
            if (inputStream != null) {
                this.doParsing(Json.createParser(new InputStreamReader(inputStream)));
                return;
            }
            try {
                try {
                    URL url = new URL(input2.getSystemId());
                    inputStream = url.openStream();
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        inputStream = new FileInputStream(input2.getSystemId());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw malformedURLException;
                    }
                }
                this.doParsing(Json.createParser(new InputStreamReader(inputStream)));
            }
            catch (JsonException je) {
                throw XMLMarshalException.unmarshalException(je);
            }
        }
    }

    @Override
    public void parse(String systemId) {
        try {
            this.parse(new InputSource(systemId));
        }
        catch (IOException | SAXException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    private void doParsing(JsonParser parser) throws SAXException, IOException {
        JsonStructureBuilder builder = null;
        while (parser.hasNext()) {
            builder = this.parseEvent(parser);
        }
        assert (builder != null);
        JsonStructure jsonStructure = builder.build();
        this.structureReader.parseRoot(jsonStructure);
    }

    private JsonStructureBuilder parseEvent(JsonParser jp) throws SAXException {
        JsonParser.Event e = jp.next();
        JsonStructureBuilder top = this.stack.peek();
        switch (e) {
            case START_ARRAY: {
                ArrayBuilder b = new ArrayBuilder(Json.createArrayBuilder());
                this.stack.push(b);
                break;
            }
            case START_OBJECT: {
                ObjectBuilder b = new ObjectBuilder(Json.createObjectBuilder());
                this.stack.push(b);
                break;
            }
            case KEY_NAME: {
                top.setKey(jp.getString());
                break;
            }
            case VALUE_STRING: {
                top.add(jp.getString());
                break;
            }
            case VALUE_NUMBER: {
                top.add(jp.getBigDecimal());
                break;
            }
            case VALUE_TRUE: {
                top.add(Boolean.TRUE);
                break;
            }
            case VALUE_FALSE: {
                top.add(Boolean.FALSE);
                break;
            }
            case VALUE_NULL: {
                top.addNull();
                break;
            }
            case END_OBJECT: 
            case END_ARRAY: {
                JsonStructureBuilder b = this.stack.pop();
                top = this.stack.peek();
                if (top != null) {
                    top.add(b.build());
                }
                return b;
            }
            default: {
                throw new IllegalStateException("Unhandled event: " + (Object)((Object)e));
            }
        }
        return null;
    }

    @Override
    public boolean isNullRepresentedByXsiNil(AbstractNullPolicy nullPolicy) {
        return true;
    }

    @Override
    public Object convertValueBasedOnSchemaType(Field xmlField, Object value2, ConversionManager conversionManager, AbstractUnmarshalRecord record) {
        return this.structureReader.convertValueBasedOnSchemaType(xmlField, value2, conversionManager, record);
    }

    @Override
    public char getNamespaceSeparator() {
        return this.structureReader.getNamespaceSeparator();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.structureReader.getErrorHandler();
    }

    @Override
    public ExtendedContentHandler getContentHandler() {
        return this.structureReader.getContentHandler();
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.structureReader.setContentHandler(contentHandler);
    }

    @Override
    public boolean isInCollection() {
        return this.structureReader.isInCollection();
    }

    @Override
    public MediaType getMediaType() {
        return Constants.APPLICATION_JSON;
    }

    @Override
    public boolean isNamespaceAware() {
        return this.structureReader.isNamespaceAware();
    }

    /* synthetic */ JsonParserReader(JsonParserReaderBuilder jsonParserReaderBuilder, JsonParserReader jsonParserReader) {
        this(jsonParserReaderBuilder);
    }

    private static final class ArrayBuilder
    implements JsonStructureBuilder {
        private final JsonArrayBuilder b;

        public ArrayBuilder(JsonArrayBuilder b) {
            this.b = b;
        }

        @Override
        public JsonStructure build() {
            return this.b.build();
        }

        @Override
        public void add(JsonValue value2) {
            this.b.add(value2);
        }

        @Override
        public void add(String value2) {
            this.b.add(value2);
        }

        @Override
        public void add(BigDecimal value2) {
            this.b.add(value2);
        }

        @Override
        public void add(boolean value2) {
            this.b.add(value2);
        }

        @Override
        public void addNull() {
            this.b.addNull();
        }

        @Override
        public void setKey(String key) {
        }
    }

    public static final class JsonParserReaderBuilder {
        private final JsonParser parser;
        private Unmarshaller um;
        private Class resultClass;

        public JsonParserReaderBuilder(JsonParser parser) {
            this.parser = parser;
        }

        public JsonParserReaderBuilder setUnmarshaller(Unmarshaller um) {
            this.um = um;
            return this;
        }

        public JsonParserReaderBuilder setResultClass(Class resultClass) {
            this.resultClass = resultClass;
            return this;
        }

        public JsonParserReader build() {
            if (this.parser == null) {
                throw new NullPointerException("JsonParser can't be null");
            }
            return new JsonParserReader(this, null);
        }
    }

    private static interface JsonStructureBuilder {
        public JsonStructure build();

        public void add(JsonValue var1);

        public void add(String var1);

        public void add(BigDecimal var1);

        public void add(boolean var1);

        public void addNull();

        public void setKey(String var1);
    }

    private static final class ObjectBuilder
    implements JsonStructureBuilder {
        private final JsonObjectBuilder b;
        private String key;

        public ObjectBuilder(JsonObjectBuilder b) {
            this.b = b;
        }

        @Override
        public JsonStructure build() {
            return this.b.build();
        }

        @Override
        public void add(JsonValue value2) {
            this.b.add(this.key, value2);
        }

        @Override
        public void add(String value2) {
            this.b.add(this.key, value2);
        }

        @Override
        public void add(BigDecimal value2) {
            this.b.add(this.key, value2);
        }

        @Override
        public void add(boolean value2) {
            this.b.add(this.key, value2);
        }

        @Override
        public void addNull() {
            this.b.addNull(this.key);
        }

        @Override
        public void setKey(String key) {
            this.key = key;
        }
    }
}

