/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.conversion;

public class Base64 {
    private static final byte[] Base64EncMap = Base64.initEncodeMap();
    private static final byte[] Base64DecMap = Base64.initDecodeMap();
    private static final byte PADDING = 127;

    private static byte[] initEncodeMap() {
        byte[] map2 = new byte[64];
        int i = 0;
        while (i < 26) {
            map2[i] = (byte)(65 + i);
            ++i;
        }
        i = 26;
        while (i < 52) {
            map2[i] = (byte)(97 + (i - 26));
            ++i;
        }
        i = 52;
        while (i < 62) {
            map2[i] = (byte)(48 + (i - 52));
            ++i;
        }
        map2[62] = 43;
        map2[63] = 47;
        return map2;
    }

    private static byte[] initDecodeMap() {
        byte[] map2 = new byte[128];
        int i = 0;
        while (i < 128) {
            map2[i] = -1;
            ++i;
        }
        i = 65;
        while (i <= 90) {
            map2[i] = (byte)(i - 65);
            ++i;
        }
        i = 97;
        while (i <= 122) {
            map2[i] = (byte)(i - 97 + 26);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            map2[i] = (byte)(i - 48 + 52);
            ++i;
        }
        map2[43] = 62;
        map2[47] = 63;
        map2[61] = 127;
        return map2;
    }

    private Base64() {
    }

    private static int guessLength(byte[] data2) {
        int padSize;
        int len = data2.length;
        int j = len - 1;
        while (j >= 0) {
            byte code = Base64DecMap[data2[j]];
            if (code != 127) {
                if (code != -1) break;
                return data2.length / 4 * 3;
            }
            --j;
        }
        if ((padSize = len - ++j) > 2) {
            return data2.length / 4 * 3;
        }
        return data2.length / 4 * 3 - padSize;
    }

    public static byte[] base64Decode(byte[] data2) {
        int buflen = Base64.guessLength(data2);
        byte[] out = new byte[buflen];
        int o = 0;
        int len = data2.length;
        byte[] quadruplet = new byte[4];
        int q = 0;
        int i = 0;
        while (i < len) {
            byte ch = data2[i];
            byte v = Base64DecMap[ch];
            if (v != -1) {
                quadruplet[q++] = v;
            }
            if (q == 4) {
                out[o++] = (byte)(quadruplet[0] << 2 | quadruplet[1] >> 4);
                if (quadruplet[2] != 127) {
                    out[o++] = (byte)(quadruplet[1] << 4 | quadruplet[2] >> 2);
                }
                if (quadruplet[3] != 127) {
                    out[o++] = (byte)(quadruplet[2] << 6 | quadruplet[3]);
                }
                q = 0;
            }
            ++i;
        }
        if (buflen == o) {
            return out;
        }
        byte[] nb = new byte[o];
        System.arraycopy(out, 0, nb, 0, o);
        return nb;
    }

    public static byte[] base64Encode(byte[] data2) {
        if (data2 == null) {
            return null;
        }
        byte[] dest = new byte[(data2.length + 2) / 3 * 4];
        int sidx = 0;
        int didx = 0;
        while (sidx < data2.length - 2) {
            dest[didx++] = Base64EncMap[data2[sidx] >>> 2 & 0x3F];
            dest[didx++] = Base64EncMap[data2[sidx + 1] >>> 4 & 0xF | data2[sidx] << 4 & 0x3F];
            dest[didx++] = Base64EncMap[data2[sidx + 2] >>> 6 & 3 | data2[sidx + 1] << 2 & 0x3F];
            dest[didx++] = Base64EncMap[data2[sidx + 2] & 0x3F];
            sidx += 3;
        }
        if (sidx < data2.length) {
            dest[didx++] = Base64EncMap[data2[sidx] >>> 2 & 0x3F];
            if (sidx < data2.length - 1) {
                dest[didx++] = Base64EncMap[data2[sidx + 1] >>> 4 & 0xF | data2[sidx] << 4 & 0x3F];
                dest[didx++] = Base64EncMap[data2[sidx + 1] << 2 & 0x3F];
            } else {
                dest[didx++] = Base64EncMap[data2[sidx] << 4 & 0x3F];
            }
        }
        while (didx < dest.length) {
            dest[didx] = 61;
            ++didx;
        }
        return dest;
    }
}

