/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.Marshaller;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.NullCapableValue;
import org.eclipse.persistence.internal.oxm.ObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLAnyAttributeMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCompositeObjectMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLVariableXPathCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLVariableXPathObjectMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;

public class XPathNode {
    private NodeValue unmarshalNodeValue;
    private NodeValue marshalNodeValue;
    private boolean isMarshalOnlyNodeValue;
    private XPathFragment xPathFragment;
    private XPathNode parent;
    private List<XPathNode> attributeChildren;
    private List<XPathNode> nonAttributeChildren;
    private List<XPathNode> selfChildren;
    private Map<XPathFragment, XPathNode> attributeChildrenMap;
    private Map<String, XPathNode> attributeChildrenLookupTable;
    private boolean isAttributeChildrenLookupTableFilled = false;
    private Map<XPathFragment, XPathNode> nonAttributeChildrenMap;
    private Map<String, XPathNode> nonAttributeChildrenLookupTable;
    private boolean isNonAttributeChildrenLookupTableFilled = false;
    private MappingNodeValue anyAttributeNodeValue;
    private XPathNode anyAttributeNode;
    private XPathNode textNode;
    private XPathNode anyNode;
    private XPathNode nextNode;
    private boolean hasTypeChild;
    private boolean hasPredicateSiblings;
    private boolean hasPredicateChildren;
    private NullCapableValue nullCapableValue;

    public XPathFragment getXPathFragment() {
        return this.xPathFragment;
    }

    public void setXPathFragment(XPathFragment xPathFragment) {
        this.xPathFragment = xPathFragment;
    }

    public NodeValue getNodeValue() {
        return this.unmarshalNodeValue;
    }

    public void setNodeValue(NodeValue nodeValue) {
        this.marshalNodeValue = nodeValue;
        this.unmarshalNodeValue = nodeValue;
        if (nodeValue != null) {
            nodeValue.setXPathNode(this);
            this.isMarshalOnlyNodeValue = nodeValue.isMarshalOnlyNodeValue();
        }
    }

    public NodeValue getUnmarshalNodeValue() {
        return this.unmarshalNodeValue;
    }

    public void setUnmarshalNodeValue(NodeValue nodeValue) {
        if (nodeValue != null) {
            nodeValue.setXPathNode(this);
        }
        this.unmarshalNodeValue = nodeValue;
    }

    public NodeValue getMarshalNodeValue() {
        return this.marshalNodeValue;
    }

    public void setMarshalNodeValue(NodeValue nodeValue) {
        if (nodeValue != null) {
            nodeValue.setXPathNode(this);
        }
        this.marshalNodeValue = nodeValue;
        this.isMarshalOnlyNodeValue = this.marshalNodeValue.isMarshalOnlyNodeValue();
    }

    public NullCapableValue getNullCapableValue() {
        return this.nullCapableValue;
    }

    public void setNullCapableValue(NullCapableValue nullCapableValue) {
        this.nullCapableValue = nullCapableValue;
    }

    public XPathNode getParent() {
        return this.parent;
    }

    public void setParent(XPathNode parent) {
        this.parent = parent;
    }

    public List<XPathNode> getAttributeChildren() {
        return this.attributeChildren;
    }

    public List<XPathNode> getNonAttributeChildren() {
        return this.nonAttributeChildren;
    }

    public List<XPathNode> getSelfChildren() {
        return this.selfChildren;
    }

    public Map<XPathFragment, XPathNode> getNonAttributeChildrenMap() {
        return this.nonAttributeChildrenMap;
    }

    public Map<XPathFragment, XPathNode> getAttributeChildrenMap() {
        return this.attributeChildrenMap;
    }

    public boolean isChildrenLookupTableFilled(boolean isAttribute) {
        return isAttribute ? this.isAttributeChildrenLookupTableFilled : this.isNonAttributeChildrenLookupTableFilled;
    }

    public void setChildrenLookupTableFilled(boolean isAttribute) {
        if (isAttribute) {
            this.isAttributeChildrenLookupTableFilled = true;
        } else {
            this.isNonAttributeChildrenLookupTableFilled = true;
        }
    }

    public Map<String, XPathNode> getChildrenLookupTable(boolean isAttribute) {
        return isAttribute ? this.getAttributeChildrenLookupTable() : this.getNonAttributeChildrenLookupTable();
    }

    private Map<String, XPathNode> getAttributeChildrenLookupTable() {
        if (this.attributeChildrenLookupTable == null) {
            this.attributeChildrenLookupTable = new HashMap<String, XPathNode>();
        }
        return this.attributeChildrenLookupTable;
    }

    private Map<String, XPathNode> getNonAttributeChildrenLookupTable() {
        if (this.nonAttributeChildrenLookupTable == null) {
            this.nonAttributeChildrenLookupTable = new HashMap<String, XPathNode>();
        }
        return this.nonAttributeChildrenLookupTable;
    }

    public void setAnyAttributeNodeValue(MappingNodeValue nodeValue) {
        this.anyAttributeNodeValue = nodeValue;
    }

    public MappingNodeValue getAnyAttributeNodeValue() {
        return this.anyAttributeNodeValue;
    }

    public XPathNode getAnyAttributeNode() {
        return this.anyAttributeNode;
    }

    public XPathNode getAnyNode() {
        return this.anyNode;
    }

    public void setAnyNode(XPathNode xPathNode) {
        this.anyNode = xPathNode;
    }

    public XPathNode getNextNode() {
        return this.nextNode;
    }

    public XPathNode getTextNode() {
        return this.textNode;
    }

    public void setTextNode(XPathNode xPathNode) {
        this.textNode = xPathNode;
    }

    public boolean hasTypeChild() {
        return this.hasTypeChild;
    }

    public boolean equals(Object object) {
        XPathFragment perfNodeXPathFragment;
        block7: {
            block6: {
                block5: {
                    try {
                        perfNodeXPathFragment = ((XPathNode)object).getXPathFragment();
                        if (this.xPathFragment != perfNodeXPathFragment) break block5;
                        return true;
                    }
                    catch (ClassCastException classCastException) {
                        return false;
                    }
                }
                if (this.xPathFragment != null) break block6;
                return false;
            }
            if (perfNodeXPathFragment != null) break block7;
            return false;
        }
        return this.xPathFragment.equals(perfNodeXPathFragment);
    }

    public XPathNode addChild(XPathFragment anXPathFragment, NodeValue aNodeValue, NamespaceResolver namespaceResolver) {
        boolean isSelfFragment;
        Map<XPathFragment, XPathNode> childrenMap;
        List<XPathNode> children;
        if (anXPathFragment != null && anXPathFragment.nameIsText() && aNodeValue.isOwningNode(anXPathFragment)) {
            XPathNode textXPathNode = this.getTextNode();
            if (textXPathNode == null) {
                textXPathNode = new XPathNode();
            }
            textXPathNode.setParent(this);
            textXPathNode.setXPathFragment(anXPathFragment);
            if (aNodeValue.isMarshalNodeValue()) {
                textXPathNode.setMarshalNodeValue(aNodeValue);
            }
            if (aNodeValue.isUnmarshalNodeValue()) {
                textXPathNode.setUnmarshalNodeValue(aNodeValue);
            }
            this.setTextNode(textXPathNode);
            if (this.nonAttributeChildren != null && !this.nonAttributeChildren.contains(textXPathNode)) {
                this.nonAttributeChildren.add(textXPathNode);
            }
            if (aNodeValue instanceof XMLCompositeObjectMappingNodeValue) {
                if (this.selfChildren == null) {
                    this.selfChildren = new ArrayList<XPathNode>();
                }
                this.selfChildren.add(textXPathNode);
            }
            return textXPathNode;
        }
        if (anXPathFragment != null && namespaceResolver != null && anXPathFragment.getNamespaceURI() == null && !anXPathFragment.nameIsText()) {
            if (!anXPathFragment.isAttribute()) {
                anXPathFragment.setNamespaceURI(namespaceResolver.resolveNamespacePrefix(anXPathFragment.getPrefix()));
            } else if (anXPathFragment.hasNamespace()) {
                anXPathFragment.setNamespaceURI(namespaceResolver.resolveNamespacePrefix(anXPathFragment.getPrefix()));
            }
        }
        XPathNode xPathNode = new XPathNode();
        xPathNode.setXPathFragment(anXPathFragment);
        if (anXPathFragment != null && anXPathFragment.isAttribute()) {
            if (this.attributeChildren == null) {
                this.attributeChildren = new ArrayList<XPathNode>();
            }
            if (this.attributeChildrenMap == null) {
                this.attributeChildrenMap = new HashMap<XPathFragment, XPathNode>();
            }
            children = this.attributeChildren;
            childrenMap = this.attributeChildrenMap;
        } else {
            if (this.nonAttributeChildren == null) {
                this.nonAttributeChildren = new ArrayList<XPathNode>();
                if (this.textNode != null) {
                    this.nonAttributeChildren.add(this.textNode);
                }
            }
            if (this.nonAttributeChildrenMap == null) {
                this.nonAttributeChildrenMap = new LinkedHashMap<XPathFragment, XPathNode>();
            }
            if (anXPathFragment != null && "type".equals(anXPathFragment.getLocalName())) {
                this.hasTypeChild = true;
            }
            children = this.nonAttributeChildren;
            childrenMap = this.nonAttributeChildrenMap;
        }
        if (anXPathFragment == null) {
            if (aNodeValue.isMarshalNodeValue()) {
                xPathNode.setMarshalNodeValue(aNodeValue);
            }
            if (aNodeValue.isUnmarshalNodeValue() && xPathNode.getUnmarshalNodeValue() == null) {
                xPathNode.setUnmarshalNodeValue(aNodeValue);
            }
            xPathNode.setParent(this);
            if (aNodeValue instanceof XMLAnyAttributeMappingNodeValue || aNodeValue instanceof XMLVariableXPathObjectMappingNodeValue && ((XMLVariableXPathObjectMappingNodeValue)aNodeValue).getMapping().isAttribute() || aNodeValue instanceof XMLVariableXPathCollectionMappingNodeValue && ((XMLVariableXPathCollectionMappingNodeValue)aNodeValue).getMapping().isAttribute()) {
                this.setAnyAttributeNodeValue((MappingNodeValue)aNodeValue);
                this.anyAttributeNode = xPathNode;
            } else {
                if (!children.contains(xPathNode)) {
                    children.add(xPathNode);
                }
                this.setAnyNode(xPathNode);
            }
            return xPathNode;
        }
        boolean bl = this.hasPredicateChildren = this.hasPredicateChildren || anXPathFragment.getPredicate() != null;
        if (this.getNonAttributeChildren() != null && this.hasPredicateChildren) {
            for (XPathNode nextChild : this.getNonAttributeChildren()) {
                XPathFragment nextFrag = nextChild.getXPathFragment();
                if (nextFrag == null || !nextFrag.equals(anXPathFragment, true)) continue;
                if (nextFrag.getPredicate() == null && anXPathFragment.getPredicate() != null) {
                    nextChild.setHasPredicateSiblings(true);
                    continue;
                }
                if (anXPathFragment.getPredicate() != null || nextFrag.getPredicate() == null) continue;
                xPathNode.setHasPredicateSiblings(true);
            }
        }
        if (isSelfFragment = XPathFragment.SELF_FRAGMENT.equals(anXPathFragment)) {
            children.add(xPathNode);
            if (this.selfChildren == null) {
                this.selfChildren = new ArrayList<XPathNode>();
            }
            this.selfChildren.add(xPathNode);
        } else {
            int index2 = children.indexOf(xPathNode);
            if (index2 >= 0) {
                xPathNode = children.get(index2);
            } else {
                xPathNode.setParent(this);
                if (!children.contains(xPathNode)) {
                    int childrenSize = children.size();
                    if (childrenSize > 0) {
                        children.get((int)(childrenSize - 1)).nextNode = xPathNode;
                    }
                    children.add(xPathNode);
                }
                childrenMap.put(anXPathFragment, xPathNode);
            }
        }
        if (aNodeValue.isOwningNode(anXPathFragment)) {
            if (aNodeValue.isMarshalNodeValue()) {
                xPathNode.setMarshalNodeValue(aNodeValue);
            }
            if (aNodeValue.isUnmarshalNodeValue() && xPathNode.getUnmarshalNodeValue() == null) {
                xPathNode.setUnmarshalNodeValue(aNodeValue);
            }
        } else {
            XPathFragment nextFragment = anXPathFragment.getNextFragment();
            xPathNode.addChild(nextFragment, aNodeValue, namespaceResolver);
        }
        return xPathNode;
    }

    private void setHasPredicateSiblings(boolean b) {
        this.hasPredicateSiblings = b;
    }

    public boolean hasPredicateSiblings() {
        return this.hasPredicateSiblings;
    }

    public boolean marshal(MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver, Marshaller marshaller, MarshalContext marshalContext, XPathFragment rootFragment) {
        if (this.marshalNodeValue == null || this.isMarshalOnlyNodeValue) {
            XPathNode xPathNode;
            ContainerValue containerValue;
            XPathNode childXPathNode;
            NodeValue childXPathNodeUnmarshalNodeValue;
            if (marshalRecord.isWrapperAsCollectionName() && this.nonAttributeChildren != null && this.nonAttributeChildren.size() == 1 && (childXPathNodeUnmarshalNodeValue = (childXPathNode = this.nonAttributeChildren.get(0)).getUnmarshalNodeValue()) != null && childXPathNodeUnmarshalNodeValue.isContainerValue() && (containerValue = (ContainerValue)((Object)childXPathNodeUnmarshalNodeValue)).isWrapperAllowedAsCollectionName()) {
                XPathNode wrapperXPathNode = new XPathNode();
                wrapperXPathNode.setXPathFragment(this.getXPathFragment());
                wrapperXPathNode.setMarshalNodeValue(childXPathNode.getMarshalNodeValue());
                return wrapperXPathNode.marshal(marshalRecord, object, session, namespaceResolver, marshaller, marshalContext, rootFragment);
            }
            marshalRecord.addGroupingElement(this);
            boolean hasValue = false;
            if (this.attributeChildren != null) {
                int x = 0;
                int size2 = this.attributeChildren.size();
                while (x < size2) {
                    xPathNode = this.attributeChildren.get(x);
                    hasValue = xPathNode.marshal(marshalRecord, object, session, namespaceResolver, marshaller, ObjectMarshalContext.getInstance(), this.xPathFragment) || hasValue;
                    ++x;
                }
            }
            if (this.anyAttributeNode != null) {
                boolean bl = hasValue = this.anyAttributeNode.marshal(marshalRecord, object, session, namespaceResolver, marshaller, ObjectMarshalContext.getInstance(), null) || hasValue;
            }
            if (this.nonAttributeChildren == null) {
                if (this.textNode != null) {
                    hasValue = this.textNode.marshal(marshalRecord, object, session, namespaceResolver, marshaller, ObjectMarshalContext.getInstance(), null) || hasValue;
                }
            } else {
                int x = 0;
                int size3 = marshalContext.getNonAttributeChildrenSize(this);
                while (x < size3) {
                    MarshalContext childMarshalContext;
                    xPathNode = (XPathNode)marshalContext.getNonAttributeChild(x, this);
                    hasValue = xPathNode.marshal(marshalRecord, object, session, namespaceResolver, marshaller, childMarshalContext = marshalContext.getMarshalContext(x), this.xPathFragment) || hasValue;
                    ++x;
                }
            }
            if (hasValue) {
                marshalRecord.endElement(this.xPathFragment, namespaceResolver);
            } else {
                marshalRecord.removeGroupingElement(this);
            }
            return hasValue;
        }
        if (this.marshalNodeValue.isMappingNodeValue()) {
            Mapping mapping = ((MappingNodeValue)this.marshalNodeValue).getMapping();
            CoreAttributeGroup currentGroup = marshalRecord.getCurrentAttributeGroup();
            if (!currentGroup.containsAttributeInternal(mapping.getAttributeName())) {
                return false;
            }
        }
        return marshalContext.marshal(this.marshalNodeValue, this.xPathFragment, marshalRecord, object, session, namespaceResolver, rootFragment);
    }

    public boolean startElement(MarshalRecord marshalRecord, XPathFragment anXPathFragment, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver, ObjectBuilder compositeObjectBuilder, Object compositeObject) {
        if (anXPathFragment == null) {
            return false;
        }
        marshalRecord.openStartElement(anXPathFragment, namespaceResolver);
        boolean hasValue = false;
        marshalRecord.predicateAttribute(anXPathFragment, namespaceResolver);
        if (this.attributeChildren != null) {
            int x = 0;
            int size2 = this.attributeChildren.size();
            while (x < size2) {
                XPathNode attributeNode = this.attributeChildren.get(x);
                hasValue = attributeNode.marshal(marshalRecord, object, session, namespaceResolver, null, ObjectMarshalContext.getInstance(), null) || hasValue;
                ++x;
            }
        }
        if (this.anyAttributeNode != null) {
            boolean bl = hasValue = this.anyAttributeNode.marshal(marshalRecord, object, session, namespaceResolver, null, ObjectMarshalContext.getInstance(), null) || hasValue;
        }
        if (compositeObjectBuilder != null) {
            hasValue = compositeObjectBuilder.marshalAttributes(marshalRecord, compositeObject, session) || hasValue;
        }
        marshalRecord.closeStartElement();
        return hasValue;
    }

    public boolean marshalSelfAttributes(MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver, Marshaller marshaller) {
        if (this.marshalNodeValue == null) {
            return false;
        }
        return this.marshalNodeValue.marshalSelfAttributes(this.xPathFragment, marshalRecord, object, session, namespaceResolver, marshaller);
    }

    public boolean isWhitespaceAware() {
        return this.unmarshalNodeValue.isWhitespaceAware();
    }
}

