/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.BindCallCustomParameter;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.databaseaccess.InOutputParameterForCallableStatement;
import org.eclipse.persistence.internal.databaseaccess.OutputParameterForCallableStatement;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.CallQueryMechanism;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public abstract class DatabaseCall
extends DatasourceCall {
    protected boolean executeReturnValue;
    public static DatabaseField MAXROW_FIELD = new DatabaseField("EclipseLink-MaxResults");
    public static DatabaseField FIRSTRESULT_FIELD = new DatabaseField("EclipseLink-FirstRow");
    protected boolean ignoreFirstRowSetting;
    protected boolean ignoreMaxResultsSetting;
    protected transient Statement statement;
    protected transient ResultSet result;
    protected Boolean usesBinding;
    protected Boolean shouldCacheStatement;
    protected transient Vector fields;
    protected transient DatabaseField[] fieldsArray;
    protected boolean isFieldMatchingRequired;
    protected boolean hasOptimisticLock;
    protected boolean isResultSetScrollable;
    protected int resultSetFetchSize;
    protected int resultSetType;
    protected int resultSetConcurrency;
    protected int queryTimeout;
    protected int maxRows;
    protected int firstResult;
    private transient AbstractRecord contexts;
    protected boolean isCursorOutputProcedure;
    protected boolean isMultipleCursorOutputProcedure;
    protected Boolean returnsResultSet;
    protected boolean shouldBuildOutputRow;
    protected boolean isCallableStatementRequired;
    protected boolean hasMultipleResultSets;
    protected boolean returnMultipleResultSetCollections;
    protected String sqlString;
    protected boolean hasAllocatedConnection;
    protected boolean isBatchExecutionSupported;
    protected List<DatabaseField> outputCursors;

    public DatabaseCall() {
        this.shouldProcessTokenInQuotes = false;
        this.usesBinding = null;
        this.shouldCacheStatement = null;
        this.isFieldMatchingRequired = false;
        this.queryTimeout = 0;
        this.maxRows = 0;
        this.resultSetFetchSize = 0;
        this.isCursorOutputProcedure = false;
        this.shouldBuildOutputRow = false;
        this.returnsResultSet = null;
        this.isBatchExecutionSupported = true;
    }

    public boolean hasMultipleResultSets() {
        return this.hasMultipleResultSets;
    }

    public void setHasMultipleResultSets(boolean hasMultipleResultSets) {
        this.hasMultipleResultSets = hasMultipleResultSets;
    }

    public void appendIn(Object inObject) {
        this.getParameters().add(inObject);
        this.getParameterTypes().add(IN);
    }

    public void appendInOut(DatabaseField inoutField) {
        Object[] inOut = new Object[]{inoutField, inoutField};
        this.getParameters().add(inOut);
        this.getParameterTypes().add(INOUT);
    }

    public void appendInOut(Object inValueOrField, DatabaseField outField) {
        Object[] inOut = new Object[]{inValueOrField, outField};
        this.getParameters().add(inOut);
        this.getParameterTypes().add(INOUT);
    }

    public void appendOut(DatabaseField outField) {
        this.getParameters().add(outField);
        this.getParameterTypes().add(OUT);
    }

    public void appendOutCursor(DatabaseField outField) {
        this.getParameters().add(outField);
        this.getParameterTypes().add(OUT_CURSOR);
        this.getOutputCursors().add(outField);
    }

    @Override
    public void appendParameter(Writer writer, Object parameter, AbstractSession session) {
        if (Boolean.TRUE.equals(this.usesBinding)) {
            this.bindParameter(writer, parameter);
        } else {
            session.getPlatform().appendParameter(this, writer, parameter);
        }
    }

    public void bindParameter(Writer writer, Object parameter) {
        if (parameter instanceof Collection) {
            throw QueryException.inCannotBeParameterized(this.getQuery());
        }
        try {
            writer.write("?");
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().add(parameter);
    }

    @Override
    public DatabaseQueryMechanism buildNewQueryMechanism(DatabaseQuery query) {
        return new CallQueryMechanism(query, this);
    }

    public AbstractRecord buildOutputRow(CallableStatement statement, DatabaseAccessor accessor, AbstractSession session) throws SQLException {
        DatabaseRecord row = new DatabaseRecord();
        int size2 = this.parameters.size();
        int index2 = 0;
        while (index2 < size2) {
            OutputParameterForCallableStatement outParameter;
            Object parameter = this.parameters.get(index2);
            if (!(!(parameter instanceof OutputParameterForCallableStatement) || (outParameter = (OutputParameterForCallableStatement)parameter).isCursor() && this.isCursorOutputProcedure())) {
                Object value2 = statement.getObject(index2 + 1);
                DatabaseField field2 = outParameter.getOutputField();
                if (value2 instanceof Struct) {
                    ClassDescriptor descriptor = session.getDescriptor(field2.getType());
                    if (value2 != null && descriptor != null && descriptor.isObjectRelationalDataTypeDescriptor()) {
                        AbstractRecord nestedRow = ((ObjectRelationalDataTypeDescriptor)descriptor).buildRowFromStructure((Struct)value2);
                        ReadObjectQuery query = new ReadObjectQuery();
                        query.setSession(session);
                        value2 = descriptor.getObjectBuilder().buildNewInstance();
                        descriptor.getObjectBuilder().buildAttributesIntoObject(value2, null, nestedRow, query, null, null, false, this.getQuery().getSession());
                    }
                } else if (value2 instanceof Array && field2.isObjectRelationalDatabaseField()) {
                    value2 = ObjectRelationalDataTypeDescriptor.buildContainerFromArray((Array)value2, (ObjectRelationalDatabaseField)field2, session);
                } else if (value2 instanceof ResultSet) {
                    ResultSet resultSet = (ResultSet)value2;
                    this.setFields(null);
                    this.matchFieldOrder(resultSet, accessor, session);
                    value2 = accessor.processResultSet(resultSet, this, statement, session);
                }
                row.put(field2, value2);
            }
            ++index2;
        }
        return row;
    }

    @Override
    public DatabaseQueryMechanism buildQueryMechanism(DatabaseQuery query, DatabaseQueryMechanism mechanism) {
        if (mechanism.isCallQueryMechanism() && mechanism instanceof CallQueryMechanism) {
            CallQueryMechanism callMechanism = (CallQueryMechanism)mechanism;
            if (!callMechanism.hasMultipleCalls()) {
                callMechanism.addCall(callMechanism.getCall());
                callMechanism.setCall(null);
            }
            callMechanism.addCall(this);
            return mechanism;
        }
        return this.buildNewQueryMechanism(query);
    }

    @Override
    protected Object createInOutParameter(Object inValue, Object outParameter, AbstractSession session) {
        if (outParameter instanceof OutputParameterForCallableStatement) {
            return new InOutputParameterForCallableStatement(inValue, (OutputParameterForCallableStatement)outParameter);
        }
        if (outParameter instanceof DatabaseField) {
            return new InOutputParameterForCallableStatement(inValue, (DatabaseField)outParameter, session);
        }
        return null;
    }

    public String getCallString() {
        return this.getSQLString();
    }

    public Vector getFields() {
        return this.fields;
    }

    public DatabaseField[] getFieldsArray() {
        return this.fieldsArray;
    }

    protected DatabaseField getFieldWithTypeFromDescriptor(DatabaseField outField) {
        if (this.getQuery().getDescriptor() != null) {
            return this.getQuery().getDescriptor().getTypedField(outField);
        }
        return null;
    }

    public int getCursorOutIndex() {
        int size2 = this.getParameters().size();
        int i = 0;
        while (i < size2) {
            Object parameter = this.parameters.get(i);
            if (parameter instanceof OutputParameterForCallableStatement && ((OutputParameterForCallableStatement)parameter).isCursor()) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    public boolean getExecuteReturnValue() {
        return this.executeReturnValue;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    @Override
    public String getLogString(Accessor accessor) {
        if (this.hasParameters()) {
            StringWriter writer = new StringWriter();
            writer.write(this.getSQLString());
            writer.write(Helper.cr());
            if (this.hasParameters()) {
                AbstractSession session = null;
                if (this.getQuery() != null) {
                    session = this.getQuery().getSession();
                }
                DatabaseCall.appendLogParameters(this.getParameters(), accessor, writer, session);
            }
            return writer.toString();
        }
        return this.getSQLString();
    }

    public static void appendLogParameters(Collection parameters, Accessor accessor, StringWriter writer, AbstractSession session) {
        writer.write("\tbind => [");
        if (session == null || session != null && session.shouldDisplayData()) {
            Iterator paramsEnum = parameters.iterator();
            while (paramsEnum.hasNext()) {
                Object parameter = paramsEnum.next();
                if (parameter instanceof DatabaseField) {
                    writer.write("null");
                } else {
                    if (session != null) {
                        parameter = session.getPlatform().convertToDatabaseType(parameter);
                    }
                    writer.write(String.valueOf(parameter));
                }
                if (paramsEnum.hasNext()) {
                    writer.write(", ");
                    continue;
                }
                writer.write("]");
            }
        } else {
            String parameterString = parameters.size() == 1 ? " parameter" : " parameters";
            writer.write(String.valueOf(parameters.size()) + parameterString + " bound]");
        }
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public Vector getOutputRowFields() {
        Vector<Object> fields = new Vector<Object>();
        int size2 = this.getParameters().size();
        int i = 0;
        while (i < size2) {
            Integer parameterType = (Integer)this.parameterTypes.get(i);
            Object parameter = this.parameters.get(i);
            if (parameterType == OUT) {
                fields.add(parameter);
            } else if (parameterType == INOUT) {
                fields.add(((Object[])parameter)[1]);
            }
            ++i;
        }
        return fields;
    }

    public List<DatabaseField> getOutputCursors() {
        if (this.outputCursors == null) {
            this.outputCursors = new ArrayList<DatabaseField>();
        }
        return this.outputCursors;
    }

    @Override
    public String getQueryString() {
        return this.getSQLString();
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public ResultSet getResult() {
        return this.result;
    }

    public boolean getReturnsResultSet() {
        if (this.returnsResultSet == null) {
            return !this.shouldBuildOutputRow();
        }
        return this.returnsResultSet;
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public int getResultSetFetchSize() {
        return this.resultSetFetchSize;
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public String getSQLString() {
        return this.sqlString;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public boolean hasOptimisticLock() {
        return this.hasOptimisticLock;
    }

    public boolean hasOutputCursors() {
        return this.outputCursors != null && !this.outputCursors.isEmpty();
    }

    protected boolean isCallableStatementRequired() {
        return this.isCallableStatementRequired;
    }

    protected boolean isDynamicCall(AbstractSession session) {
        return DatabaseAccessor.shouldUseDynamicStatements && !this.usesBinding(session) && !this.isResultSetScrollable() && !this.hasParameters();
    }

    public boolean isCursorOutputProcedure() {
        return this.isCursorOutputProcedure;
    }

    @Override
    public boolean isCursorReturned() {
        return this.returnType == 4;
    }

    public boolean isFieldMatchingRequired() {
        return this.isFieldMatchingRequired;
    }

    @Override
    public boolean isFinished() {
        return !this.isCursorReturned() && !this.isExecuteUpdate();
    }

    public boolean isMultipleCursorOutputProcedure() {
        return this.isMultipleCursorOutputProcedure;
    }

    public boolean isNonCursorOutputProcedure() {
        return !this.isCursorOutputProcedure() && this.shouldBuildOutputRow();
    }

    public boolean isResultSetScrollable() {
        return this.isResultSetScrollable;
    }

    public void matchFieldOrder(ResultSet resultSet, DatabaseAccessor accessor, AbstractSession session) {
        if (this.getFields() != null && !this.isFieldMatchingRequired()) {
            return;
        }
        this.setFields(accessor.buildSortedFields(this.getFields(), resultSet, session));
    }

    @Override
    public void prepare(AbstractSession session) {
        if (this.isPrepared) {
            return;
        }
        this.prepareInternal(session);
        this.isPrepared = true;
    }

    protected void prepareInternal(AbstractSession session) {
        this.prepareInternalParameters(session);
    }

    protected void prepareInternalParameters(AbstractSession session) {
        if (this.isCursorOutputProcedure()) {
            int nFirstOutParameterIndex = -1;
            boolean hasFoundOutCursor = false;
            int size2 = this.parameters.size();
            int index2 = 0;
            while (index2 < size2) {
                Integer parameterType = (Integer)this.parameterTypes.get(index2);
                if (parameterType == DatasourceCall.OUT_CURSOR) {
                    if (hasFoundOutCursor) {
                        throw ValidationException.multipleCursorsNotSupported(this.toString());
                    }
                    hasFoundOutCursor = true;
                } else if (parameterType == DatasourceCall.OUT) {
                    if (nFirstOutParameterIndex == -1) {
                        nFirstOutParameterIndex = index2;
                    }
                } else if (parameterType == null) {
                    throw ValidationException.wrongUsageOfSetCustomArgumentTypeMethod(this.toString());
                }
                ++index2;
            }
            if (!hasFoundOutCursor && nFirstOutParameterIndex >= 0) {
                this.parameterTypes.set(nFirstOutParameterIndex, DatasourceCall.OUT_CURSOR);
            }
        }
        int size3 = this.getParameters().size();
        int i = 0;
        while (i < size3) {
            Object parameter = this.parameters.get(i);
            Integer parameterType = (Integer)this.parameterTypes.get(i);
            if (parameterType == MODIFY) {
                DatabaseField field2 = (DatabaseField)parameter;
                if (field2.getType() == null || session.getPlatform().shouldUseCustomModifyForCall(field2)) {
                    this.parameterTypes.set(i, CUSTOM_MODIFY);
                }
            } else if (parameterType == INOUT) {
                DatabaseField typeOutField;
                this.setShouldBuildOutputRow(true);
                this.setIsCallableStatementRequired(true);
                DatabaseField outField = (DatabaseField)((Object[])parameter)[1];
                if (outField.getType() == null && (typeOutField = this.getFieldWithTypeFromDescriptor(outField)) != null) {
                    outField = typeOutField.clone();
                }
                if (outField.getType() != null) {
                    OutputParameterForCallableStatement outParameter = new OutputParameterForCallableStatement(outField, session);
                    ((Object[])parameter)[1] = outParameter;
                }
            } else if (parameterType == OUT || parameterType == OUT_CURSOR) {
                DatabaseField typeOutField;
                boolean isCursor;
                boolean bl = isCursor = parameterType == OUT_CURSOR;
                if (!isCursor) {
                    this.setShouldBuildOutputRow(true);
                }
                this.setIsCallableStatementRequired(true);
                DatabaseField outField = (DatabaseField)parameter;
                if (outField.getType() == null && (typeOutField = this.getFieldWithTypeFromDescriptor(outField)) != null) {
                    outField = typeOutField.clone();
                }
                OutputParameterForCallableStatement outParameter = new OutputParameterForCallableStatement(outField, session, isCursor);
                this.parameters.set(i, outParameter);
                this.parameterTypes.set(i, LITERAL);
            }
            ++i;
        }
        if (this.returnsResultSet == null) {
            this.setReturnsResultSet(!this.isCallableStatementRequired());
        }
        this.isBatchExecutionSupported = !(!this.isNothingReturned() || this.hasOptimisticLock() && !session.getPlatform().canBatchWriteWithOptimisticLocking(this) || this.shouldBuildOutputRow() || !session.getPlatform().usesJDBCBatchWriting() && this.hasParameters() || this.isLOBLocatorNeeded() || !this.getQuery().isModifyQuery() || !((ModifyQuery)this.getQuery()).isBatchExecutionSupported());
    }

    public Statement prepareStatement(DatabaseAccessor accessor, AbstractRecord translationRow, AbstractSession session) throws SQLException {
        Statement statement = accessor.prepareStatement(this, session);
        if (this.queryTimeout > 0) {
            statement.setQueryTimeout(this.queryTimeout);
        }
        if (!this.ignoreMaxResultsSetting && this.maxRows > 0) {
            statement.setMaxRows(this.maxRows);
        }
        if (this.resultSetFetchSize > 0) {
            statement.setFetchSize(this.resultSetFetchSize);
        }
        if (this.parameters == null) {
            return statement;
        }
        List parameters = this.getParameters();
        int size2 = parameters.size();
        int index2 = 0;
        while (index2 < size2) {
            session.getPlatform().setParameterValueInDatabaseCall(parameters.get(index2), (PreparedStatement)statement, index2 + 1, session);
            ++index2;
        }
        return statement;
    }

    public boolean returnMultipleResultSetCollections() {
        return this.returnMultipleResultSetCollections;
    }

    public void setFields(Vector fields) {
        this.fields = fields;
        if (fields != null) {
            int size2 = fields.size();
            this.fieldsArray = new DatabaseField[size2];
            int index2 = 0;
            while (index2 < size2) {
                this.fieldsArray[index2] = (DatabaseField)fields.get(index2);
                ++index2;
            }
        } else {
            this.fieldsArray = null;
        }
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }

    public void setHasOptimisticLock(boolean hasOptimisticLock) {
        this.hasOptimisticLock = hasOptimisticLock;
    }

    public void setIgnoreFirstRowSetting(boolean ignoreFirstRowSetting) {
        this.ignoreFirstRowSetting = ignoreFirstRowSetting;
    }

    public void setIgnoreMaxResultsSetting(boolean ignoreMaxResultsSetting) {
        this.ignoreMaxResultsSetting = ignoreMaxResultsSetting;
    }

    protected void setIsCallableStatementRequired(boolean isCallableStatementRequired) {
        this.isCallableStatementRequired = isCallableStatementRequired;
    }

    public void setIsCursorOutputProcedure(boolean isCursorOutputProcedure) {
        this.isCursorOutputProcedure = isCursorOutputProcedure;
    }

    public void setIsFieldMatchingRequired(boolean isFieldMatchingRequired) {
        this.isFieldMatchingRequired = isFieldMatchingRequired;
    }

    public void setIsMultipleCursorOutputProcedure(boolean isMultipleCursorOutputProcedure) {
        this.isMultipleCursorOutputProcedure = isMultipleCursorOutputProcedure;
    }

    public void setIsResultSetScrollable(boolean isResultSetScrollable) {
        this.isResultSetScrollable = isResultSetScrollable;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public void setQueryString(String queryString) {
        this.setSQLStringInternal(queryString);
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public void setResult(ResultSet result2) {
        this.result = result2;
    }

    public void setResultSetConcurrency(int resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
    }

    protected void setSQLStringInternal(String sqlString) {
        this.sqlString = sqlString;
    }

    public void setResultSetFetchSize(int resultSetFetchSize) {
        this.resultSetFetchSize = resultSetFetchSize;
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public void setReturnsResultSet(boolean returnsResultSet) {
        this.returnsResultSet = returnsResultSet;
    }

    public void setReturnMultipleResultSetCollections(boolean returnMultipleResultSetCollections) {
        this.returnMultipleResultSetCollections = returnMultipleResultSetCollections;
    }

    protected void setShouldBuildOutputRow(boolean shouldBuildOutputRow) {
        this.shouldBuildOutputRow = shouldBuildOutputRow;
    }

    public void setShouldCacheStatement(boolean shouldCacheStatement) {
        this.shouldCacheStatement = shouldCacheStatement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public void setUsesBinding(boolean usesBinding) {
        this.usesBinding = usesBinding;
    }

    public boolean shouldBuildOutputRow() {
        return this.shouldBuildOutputRow;
    }

    public boolean shouldCacheStatement(AbstractSession session) {
        return this.shouldCacheStatement(session.getPlatform());
    }

    public boolean shouldCacheStatement(DatabasePlatform databasePlatform) {
        if (this.isResultSetScrollable()) {
            return false;
        }
        if (this.shouldCacheStatement == null) {
            return databasePlatform.shouldCacheAllStatements();
        }
        return this.shouldCacheStatement;
    }

    public boolean shouldIgnoreFirstRowSetting() {
        return this.ignoreFirstRowSetting;
    }

    public boolean shouldIgnoreMaxResultsSetting() {
        return this.ignoreMaxResultsSetting;
    }

    public String toString() {
        String str = Helper.getShortClassName(this.getClass());
        if (this.getSQLString() == null) {
            return str;
        }
        return String.valueOf(str) + "(" + this.getSQLString() + ")";
    }

    @Override
    public void translate(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        if (!this.isPrepared()) {
            throw ValidationException.cannotTranslateUnpreparedCall(this.toString());
        }
        if (this.usesBinding(session) && this.parameters != null) {
            boolean hasParameterizedIN = false;
            List parameters = this.getParameters();
            List<Integer> parameterTypes = this.getParameterTypes();
            int size2 = parameters.size();
            ArrayList<Object> parametersValues = new ArrayList<Object>(size2);
            int index2 = 0;
            while (index2 < size2) {
                Object value2;
                Object value3;
                DatabaseField field2;
                Object parameter = parameters.get(index2);
                Integer parameterType = parameterTypes.get(index2);
                if (parameterType == MODIFY) {
                    field2 = (DatabaseField)parameter;
                    value3 = modifyRow.get(field2);
                    if (value3 == null && (value3 = modifyRow.getField(field2)) == null) {
                        value3 = field2;
                    }
                    parametersValues.add(value3);
                } else if (parameterType == CUSTOM_MODIFY) {
                    field2 = (DatabaseField)parameter;
                    value3 = modifyRow.get(field2);
                    value3 = session.getPlatform().getCustomModifyValueForCall(this, value3, field2, true);
                    if (value3 != null && value3 instanceof BindCallCustomParameter && ((BindCallCustomParameter)value3).shouldUseUnwrappedConnection()) {
                        this.isNativeConnectionRequired = true;
                    }
                    if (value3 == null && (value3 = modifyRow.getField(field2)) == null) {
                        value3 = field2;
                    }
                    parametersValues.add(value3);
                } else if (parameterType == TRANSLATION) {
                    value2 = null;
                    DatabaseField field3 = null;
                    if (parameter instanceof ParameterExpression) {
                        field3 = ((ParameterExpression)parameter).getField();
                        value2 = ((ParameterExpression)parameter).getValue(translationRow, this.query, session);
                    } else {
                        field3 = (DatabaseField)parameter;
                        value2 = translationRow.get(field3);
                        if (value2 == null) {
                            value2 = modifyRow.get(field3);
                        }
                    }
                    if (value2 instanceof Collection) {
                        hasParameterizedIN = true;
                    }
                    if (value2 == null && field3 != null) {
                        if (!this.query.hasNullableArguments() || !this.query.getNullableArguments().contains(field3)) {
                            value2 = translationRow.getField(field3);
                            if (value2 == null) {
                                value2 = field3;
                            }
                            parametersValues.add(value2);
                        }
                    } else {
                        parametersValues.add(value2);
                    }
                } else if (parameterType == LITERAL) {
                    parametersValues.add(parameter);
                } else if (parameterType == IN) {
                    value2 = this.getValueForInParameter(parameter, translationRow, modifyRow, session, true);
                    if (value2 != this) {
                        parametersValues.add(value2);
                    }
                } else if (parameterType == INOUT) {
                    value2 = this.getValueForInOutParameter(parameter, translationRow, modifyRow, session);
                    parametersValues.add(value2);
                }
                ++index2;
            }
            this.setParameters(parametersValues);
            if (hasParameterizedIN) {
                this.translateQueryStringForParameterizedIN(translationRow, modifyRow, session);
            }
            return;
        }
        this.translateQueryString(translationRow, modifyRow, session);
    }

    public void translateQueryStringForParameterizedIN(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        int lastIndex = 0;
        int parameterIndex = 0;
        String queryString = this.getQueryString();
        CharArrayWriter writer = new CharArrayWriter(queryString.length() + 50);
        try {
            List parameters = this.getParameters();
            ArrayList parametersValues = new ArrayList(parameters.size());
            while (lastIndex != -1) {
                String token2;
                int tokenIndex = queryString.indexOf(this.argumentMarker(), lastIndex);
                if (tokenIndex == -1) {
                    token2 = queryString.substring(lastIndex, queryString.length());
                    lastIndex = -1;
                } else {
                    token2 = queryString.substring(lastIndex, tokenIndex);
                }
                writer.write(token2);
                if (tokenIndex == -1) continue;
                Object parameter = parameters.get(parameterIndex);
                if (parameter instanceof Collection) {
                    int size2;
                    Collection values = (Collection)parameter;
                    writer.write("(");
                    if (values.size() > 0 && values.iterator().next() instanceof List) {
                        size2 = values.size();
                        Iterator valuesIterator = values.iterator();
                        int index2 = 0;
                        while (index2 < size2) {
                            List nestedValues = (List)valuesIterator.next();
                            parametersValues.addAll(nestedValues);
                            int nestedSize = nestedValues.size();
                            writer.write("(");
                            int nestedIndex = 0;
                            while (nestedIndex < nestedSize) {
                                writer.write("?");
                                if (nestedIndex + 1 < nestedSize) {
                                    writer.write(",");
                                }
                                ++nestedIndex;
                            }
                            writer.write(")");
                            if (index2 + 1 < size2) {
                                writer.write(",");
                            }
                            ++index2;
                        }
                    } else {
                        parametersValues.addAll(values);
                        size2 = values.size();
                        int index3 = 0;
                        while (index3 < size2) {
                            writer.write("?");
                            if (index3 + 1 < size2) {
                                writer.write(",");
                            }
                            ++index3;
                        }
                    }
                    writer.write(")");
                } else {
                    parametersValues.add(parameter);
                    writer.write("?");
                }
                lastIndex = tokenIndex + 1;
                ++parameterIndex;
            }
            this.setParameters(parametersValues);
            this.setQueryString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public boolean usesBinding(AbstractSession session) {
        return this.usesBinding(session.getPlatform());
    }

    public boolean usesBinding(DatabasePlatform databasePlatform) {
        if (this.usesBinding == null) {
            return databasePlatform.shouldBindAllParameters();
        }
        return this.usesBinding;
    }

    public boolean isUsesBindingSet() {
        return this.usesBinding != null;
    }

    public boolean isLOBLocatorNeeded() {
        return this.contexts != null;
    }

    public void addContext(DatabaseField field2, Object value2) {
        if (this.contexts == null) {
            this.contexts = new DatabaseRecord(2);
        }
        this.contexts.add(field2, value2);
        this.isBatchExecutionSupported = false;
    }

    public AbstractRecord getContexts() {
        return this.contexts;
    }

    public void setContexts(AbstractRecord contexts) {
        this.contexts = contexts;
    }

    public void setExecuteReturnValue(boolean value2) {
        this.executeReturnValue = value2;
    }

    public void useUnnamedCursorOutputAsResultSet() {
        this.setIsCursorOutputProcedure(true);
    }

    public boolean isBatchExecutionSupported() {
        return this.isBatchExecutionSupported;
    }

    public void setBatchExecutionSupported(boolean isBatchExecutionSupported) {
        this.isBatchExecutionSupported = isBatchExecutionSupported;
    }

    public boolean hasAllocatedConnection() {
        return this.hasAllocatedConnection;
    }

    public void setHasAllocatedConnection(boolean hasAllocatedConnection) {
        this.hasAllocatedConnection = hasAllocatedConnection;
    }
}

