/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadQuery;

public class ExpressionBuilder
extends ObjectExpression {
    protected transient AbstractSession session;
    protected Class queryClass;
    protected SQLSelectStatement statement;
    protected DatabaseTable viewTable;
    protected DatabaseTable aliasedViewTable;
    protected boolean wasQueryClassSetInternally = true;
    protected boolean wasAdditionJoinCriteriaUsed = false;

    public ExpressionBuilder() {
    }

    public ExpressionBuilder(Class queryClass) {
        this.queryClass = queryClass;
        this.wasQueryClassSetInternally = false;
    }

    @Override
    public boolean equals(Object expression) {
        if (this == expression) {
            return true;
        }
        return super.equals(expression) && this.getQueryClass() == null && ((ExpressionBuilder)expression).getQueryClass() == null;
    }

    @Override
    public DatabaseTable aliasForTable(DatabaseTable table) {
        if (this.hasViewTable()) {
            return this.getAliasedViewTable();
        }
        if (this.doesNotRepresentAnObjectInTheQuery()) {
            for (Expression expression : this.derivedTables) {
                DatabaseTable result2 = expression.aliasForTable(table);
                if (result2 == null) continue;
                return result2;
            }
        } else {
            return super.aliasForTable(table);
        }
        return null;
    }

    @Override
    public int assignTableAliasesStartingAt(int initialValue) {
        if (this.hasBeenAliased()) {
            return initialValue;
        }
        if (this.doesNotRepresentAnObjectInTheQuery()) {
            return initialValue;
        }
        if (this.hasViewTable()) {
            DatabaseTable aliased = this.viewTable.clone();
            String alias = "t" + initialValue;
            aliased.setName(alias);
            this.assignAlias(alias, this.viewTable);
            this.aliasedViewTable = aliased;
            this.hasBeenAliased = true;
            return initialValue + 1;
        }
        return super.assignTableAliasesStartingAt(initialValue);
    }

    @Override
    public String descriptionOfNodeType() {
        return "Base";
    }

    public boolean doesNotRepresentAnObjectInTheQuery() {
        return this.hasDerivedTables() && !this.hasDerivedFields() && !this.hasDerivedExpressions();
    }

    public DatabaseTable getAliasedViewTable() {
        return this.aliasedViewTable;
    }

    @Override
    public ExpressionBuilder getBuilder() {
        return this;
    }

    @Override
    public ClassDescriptor getDescriptor() {
        if (this.descriptor == null) {
            if (this.getQueryClass() == null) {
                return null;
            }
            if (this.getSession() == null) {
                throw QueryException.noExpressionBuilderFound(this);
            }
            this.descriptor = this.getSession().getDescriptor(this.getQueryClass());
            this.descriptor = this.convertToCastDescriptor(this.descriptor, this.getSession());
        }
        return this.descriptor;
    }

    public Class getQueryClass() {
        return this.queryClass;
    }

    @Override
    public AbstractSession getSession() {
        return this.session;
    }

    public SQLSelectStatement getStatement() {
        return this.statement;
    }

    public DatabaseTable getViewTable() {
        return this.viewTable;
    }

    public boolean hasViewTable() {
        return this.viewTable != null;
    }

    @Override
    public boolean isExpressionBuilder() {
        return true;
    }

    @Override
    public Expression normalize(ExpressionNormalizer normalizer) {
        ReadQuery query;
        if (this.hasBeenNormalized()) {
            return this;
        }
        this.setHasBeenNormalized(true);
        if (this.onClause != null) {
            this.onClause = this.onClause.normalize(normalizer);
            if (this.shouldUseOuterJoin() || !this.getSession().getPlatform().shouldPrintInnerJoinInWhereClause()) {
                Expression historyCriteria;
                normalizer.getStatement().addOuterJoinExpressionsHolders(this, null, null, null);
                if (this.getDescriptor() != null && this.getDescriptor().getHistoryPolicy() != null && (historyCriteria = this.getDescriptor().getHistoryPolicy().additionalHistoryExpression(this, this)) != null) {
                    normalizer.addAdditionalExpression(historyCriteria);
                }
            } else {
                normalizer.addAdditionalExpression(this.onClause);
            }
        }
        if (this.queryClass != null) {
            Expression criteria = null;
            this.setSession(normalizer.getSession().getRootSession(null));
            if (this.getDescriptor() == null) {
                throw QueryException.noExpressionBuilderFound(this);
            }
            if (!this.wasAdditionJoinCriteriaUsed && (criteria = this.getDescriptor().getQueryManager().getAdditionalJoinExpression()) != null) {
                criteria = this.twist(criteria, this);
            }
            if (this.isUsingOuterJoinForMultitableInheritance()) {
                if (this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause()) {
                    Expression childrenCriteria = this.getDescriptor().getInheritancePolicy().getChildrenJoinExpression();
                    childrenCriteria = this.twist(childrenCriteria, this);
                    childrenCriteria.convertToUseOuterJoin();
                    criteria = criteria == null ? childrenCriteria : criteria.and(childrenCriteria);
                } else {
                    normalizer.getStatement().addOuterJoinExpressionsHolders(null, null, this.additionalExpressionCriteriaMap(), this.getDescriptor());
                }
            }
            normalizer.addAdditionalExpression(criteria);
        }
        this.setStatement(normalizer.getStatement());
        if (this.getAsOfClause() == null) {
            this.asOf(AsOfClause.NO_CLAUSE);
        }
        if (this.getDescriptor() != null && this.getDescriptor().getHistoryPolicy() != null) {
            Expression temporalCriteria = this.getDescriptor().getHistoryPolicy().additionalHistoryExpression(this, this);
            normalizer.addAdditionalExpression(temporalCriteria);
        }
        if ((query = normalizer.getStatement().getQuery()) != null && query.shouldCacheQueryResults() && this.queryClass != null) {
            query.getQueryResultsCachePolicy().getInvalidationClasses().add(this.queryClass);
        }
        return this;
    }

    @Override
    public void printJava(ExpressionJavaPrinter printer) {
        printer.printString(printer.getBuilderString());
    }

    @Override
    public Expression rebuildOn(Expression newBase) {
        return newBase;
    }

    @Override
    public void resetPlaceHolderBuilder(ExpressionBuilder queryBuilder) {
    }

    @Override
    protected Expression registerIn(Map alreadyDone) {
        Object value2 = alreadyDone.get(alreadyDone);
        if (value2 == null || value2 == alreadyDone) {
            return super.registerIn(alreadyDone);
        }
        ObjectExpression copy = (ObjectExpression)value2;
        alreadyDone.put(alreadyDone, alreadyDone);
        alreadyDone.put(this, copy);
        if (this.derivedExpressions != null) {
            if (copy.derivedExpressions == null) {
                copy.derivedExpressions = this.copyDerivedExpressions(alreadyDone);
            } else {
                copy.derivedExpressions.addAll(this.copyDerivedExpressions(alreadyDone));
            }
        }
        copy.postCopyIn(alreadyDone, this.derivedFields, this.derivedTables);
        return copy;
    }

    public void setQueryClass(Class queryClass) {
        this.queryClass = queryClass;
        this.descriptor = null;
    }

    public void setQueryClassAndDescriptor(Class queryClass, ClassDescriptor descriptor) {
        this.queryClass = queryClass;
        this.descriptor = this.convertToCastDescriptor(descriptor, this.session);
    }

    public void setSession(AbstractSession session) {
        this.session = session != null ? session.getRootSession(null) : null;
    }

    public void setStatement(SQLSelectStatement statement) {
        this.statement = statement;
    }

    public void setViewTable(DatabaseTable theTable) {
        this.viewTable = theTable;
    }

    public void setWasAdditionJoinCriteriaUsed(boolean joinCriteriaUsed) {
        this.wasAdditionJoinCriteriaUsed = joinCriteriaUsed;
    }

    @Override
    public Expression twistedForBaseAndContext(Expression newBase, Expression context, Expression oldBase) {
        if (oldBase == null || this == oldBase) {
            return newBase;
        }
        return this;
    }

    @Override
    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        return object;
    }

    public boolean wasAdditionJoinCriteriaUsed() {
        return this.wasAdditionJoinCriteriaUsed;
    }

    public boolean wasQueryClassSetInternally() {
        return this.wasQueryClassSetInternally;
    }

    @Override
    public ClassDescriptor getLeafDescriptor(DatabaseQuery query, ClassDescriptor rootDescriptor, AbstractSession session) {
        Class queryClass = this.getQueryClass();
        if (queryClass != null && (query == null || queryClass != query.getReferenceClass())) {
            return this.convertToCastDescriptor(session.getDescriptor(queryClass), session);
        }
        return this.convertToCastDescriptor(rootDescriptor, session);
    }

    @Override
    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        String className = this.getQueryClass() == null ? "QUERY OBJECT" : this.getQueryClass().getName();
        writer.write(String.valueOf(className) + this.tableAliasesDescription());
    }
}

