/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.discovery;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.curator.x.discovery.details.JsonInstanceSerializer;
import org.apache.curator.x.discovery.details.ServiceDiscoveryImpl;

public class ServiceDiscoveryBuilder<T> {
    private CuratorFramework client;
    private String basePath;
    private InstanceSerializer<T> serializer;
    private ServiceInstance<T> thisInstance;

    public static <T> ServiceDiscoveryBuilder<T> builder(Class<T> payloadClass) {
        return new ServiceDiscoveryBuilder<T>(payloadClass).serializer(new JsonInstanceSerializer<T>(payloadClass));
    }

    public ServiceDiscovery<T> build() {
        return new ServiceDiscoveryImpl<T>(this.client, this.basePath, this.serializer, this.thisInstance);
    }

    public ServiceDiscoveryBuilder<T> client(CuratorFramework client) {
        this.client = client;
        return this;
    }

    public ServiceDiscoveryBuilder<T> basePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public ServiceDiscoveryBuilder<T> serializer(InstanceSerializer<T> serializer) {
        this.serializer = serializer;
        return this;
    }

    public ServiceDiscoveryBuilder<T> thisInstance(ServiceInstance<T> thisInstance) {
        this.thisInstance = thisInstance;
        return this;
    }

    ServiceDiscoveryBuilder(Class<T> payloadClass) {
    }
}

