/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class IOUtils {
    public static final char DIR_SEPARATOR_UNIX = '/';
    public static final char DIR_SEPARATOR_WINDOWS = '\\';
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final String LINE_SEPARATOR_UNIX = "\n";
    public static final String LINE_SEPARATOR_WINDOWS = "\r\n";
    public static final String LINE_SEPARATOR;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void closeQuietly(Reader input2) {
        try {
            if (input2 != null) {
                input2.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Writer output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(InputStream input2) {
        try {
            if (input2 != null) {
                input2.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] toByteArray(InputStream input2) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copy(input2, (OutputStream)output);
        return output.toByteArray();
    }

    public static byte[] toByteArray(Reader input2) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copy(input2, (OutputStream)output);
        return output.toByteArray();
    }

    public static byte[] toByteArray(Reader input2, String encoding) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copy(input2, output, encoding);
        return output.toByteArray();
    }

    public static byte[] toByteArray(String input2) throws IOException {
        return input2.getBytes();
    }

    public static char[] toCharArray(InputStream is) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        IOUtils.copy(is, (Writer)output);
        return output.toCharArray();
    }

    public static char[] toCharArray(InputStream is, String encoding) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        IOUtils.copy(is, output, encoding);
        return output.toCharArray();
    }

    public static char[] toCharArray(Reader input2) throws IOException {
        CharArrayWriter sw = new CharArrayWriter();
        IOUtils.copy(input2, (Writer)sw);
        return sw.toCharArray();
    }

    public static String toString(InputStream input2) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtils.copy(input2, (Writer)sw);
        return sw.toString();
    }

    public static String toString(InputStream input2, String encoding) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtils.copy(input2, sw, encoding);
        return sw.toString();
    }

    public static String toString(Reader input2) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtils.copy(input2, (Writer)sw);
        return sw.toString();
    }

    public static String toString(byte[] input2) throws IOException {
        return new String(input2);
    }

    public static String toString(byte[] input2, String encoding) throws IOException {
        if (encoding == null) {
            return new String(input2);
        }
        return new String(input2, encoding);
    }

    public static List readLines(InputStream input2) throws IOException {
        InputStreamReader reader = new InputStreamReader(input2);
        return IOUtils.readLines(reader);
    }

    public static List readLines(InputStream input2, String encoding) throws IOException {
        if (encoding == null) {
            return IOUtils.readLines(input2);
        }
        InputStreamReader reader = new InputStreamReader(input2, encoding);
        return IOUtils.readLines(reader);
    }

    public static List readLines(Reader input2) throws IOException {
        BufferedReader reader = new BufferedReader(input2);
        ArrayList<String> list2 = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list2.add(line);
            line = reader.readLine();
        }
        return list2;
    }

    public static LineIterator lineIterator(Reader reader) {
        return new LineIterator(reader);
    }

    public static LineIterator lineIterator(InputStream input2, String encoding) throws IOException {
        InputStreamReader reader = null;
        reader = encoding == null ? new InputStreamReader(input2) : new InputStreamReader(input2, encoding);
        return new LineIterator(reader);
    }

    public static InputStream toInputStream(String input2) {
        byte[] bytes = input2.getBytes();
        return new ByteArrayInputStream(bytes);
    }

    public static InputStream toInputStream(String input2, String encoding) throws IOException {
        byte[] bytes = encoding != null ? input2.getBytes(encoding) : input2.getBytes();
        return new ByteArrayInputStream(bytes);
    }

    public static void write(byte[] data2, OutputStream output) throws IOException {
        if (data2 != null) {
            output.write(data2);
        }
    }

    public static void write(byte[] data2, Writer output) throws IOException {
        if (data2 != null) {
            output.write(new String(data2));
        }
    }

    public static void write(byte[] data2, Writer output, String encoding) throws IOException {
        if (data2 != null) {
            if (encoding == null) {
                IOUtils.write(data2, output);
            } else {
                output.write(new String(data2, encoding));
            }
        }
    }

    public static void write(char[] data2, Writer output) throws IOException {
        if (data2 != null) {
            output.write(data2);
        }
    }

    public static void write(char[] data2, OutputStream output) throws IOException {
        if (data2 != null) {
            output.write(new String(data2).getBytes());
        }
    }

    public static void write(char[] data2, OutputStream output, String encoding) throws IOException {
        if (data2 != null) {
            if (encoding == null) {
                IOUtils.write(data2, output);
            } else {
                output.write(new String(data2).getBytes(encoding));
            }
        }
    }

    public static void write(String data2, Writer output) throws IOException {
        if (data2 != null) {
            output.write(data2);
        }
    }

    public static void write(String data2, OutputStream output) throws IOException {
        if (data2 != null) {
            output.write(data2.getBytes());
        }
    }

    public static void write(String data2, OutputStream output, String encoding) throws IOException {
        if (data2 != null) {
            if (encoding == null) {
                IOUtils.write(data2, output);
            } else {
                output.write(data2.getBytes(encoding));
            }
        }
    }

    public static void write(StringBuffer data2, Writer output) throws IOException {
        if (data2 != null) {
            output.write(data2.toString());
        }
    }

    public static void write(StringBuffer data2, OutputStream output) throws IOException {
        if (data2 != null) {
            output.write(data2.toString().getBytes());
        }
    }

    public static void write(StringBuffer data2, OutputStream output, String encoding) throws IOException {
        if (data2 != null) {
            if (encoding == null) {
                IOUtils.write(data2, output);
            } else {
                output.write(data2.toString().getBytes(encoding));
            }
        }
    }

    public static void writeLines(Collection lines2, String lineEnding, OutputStream output) throws IOException {
        if (lines2 == null) {
            return;
        }
        if (lineEnding == null) {
            lineEnding = LINE_SEPARATOR;
        }
        Iterator it = lines2.iterator();
        while (it.hasNext()) {
            Object line = it.next();
            if (line != null) {
                output.write(line.toString().getBytes());
            }
            output.write(lineEnding.getBytes());
        }
    }

    public static void writeLines(Collection lines2, String lineEnding, OutputStream output, String encoding) throws IOException {
        if (encoding == null) {
            IOUtils.writeLines(lines2, lineEnding, output);
        } else {
            if (lines2 == null) {
                return;
            }
            if (lineEnding == null) {
                lineEnding = LINE_SEPARATOR;
            }
            Iterator it = lines2.iterator();
            while (it.hasNext()) {
                Object line = it.next();
                if (line != null) {
                    output.write(line.toString().getBytes(encoding));
                }
                output.write(lineEnding.getBytes(encoding));
            }
        }
    }

    public static void writeLines(Collection lines2, String lineEnding, Writer writer) throws IOException {
        if (lines2 == null) {
            return;
        }
        if (lineEnding == null) {
            lineEnding = LINE_SEPARATOR;
        }
        Iterator it = lines2.iterator();
        while (it.hasNext()) {
            Object line = it.next();
            if (line != null) {
                writer.write(line.toString());
            }
            writer.write(lineEnding);
        }
    }

    public static int copy(InputStream input2, OutputStream output) throws IOException {
        long count2 = IOUtils.copyLarge(input2, output);
        if (count2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count2;
    }

    public static long copyLarge(InputStream input2, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count2 = 0L;
        int n = 0;
        while (-1 != (n = input2.read(buffer))) {
            output.write(buffer, 0, n);
            count2 += (long)n;
        }
        return count2;
    }

    public static void copy(InputStream input2, Writer output) throws IOException {
        InputStreamReader in = new InputStreamReader(input2);
        IOUtils.copy((Reader)in, output);
    }

    public static void copy(InputStream input2, Writer output, String encoding) throws IOException {
        if (encoding == null) {
            IOUtils.copy(input2, output);
        } else {
            InputStreamReader in = new InputStreamReader(input2, encoding);
            IOUtils.copy((Reader)in, output);
        }
    }

    public static int copy(Reader input2, Writer output) throws IOException {
        long count2 = IOUtils.copyLarge(input2, output);
        if (count2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count2;
    }

    public static long copyLarge(Reader input2, Writer output) throws IOException {
        char[] buffer = new char[4096];
        long count2 = 0L;
        int n = 0;
        while (-1 != (n = input2.read(buffer))) {
            output.write(buffer, 0, n);
            count2 += (long)n;
        }
        return count2;
    }

    public static void copy(Reader input2, OutputStream output) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(output);
        IOUtils.copy(input2, (Writer)out);
        out.flush();
    }

    public static void copy(Reader input2, OutputStream output, String encoding) throws IOException {
        if (encoding == null) {
            IOUtils.copy(input2, output);
        } else {
            OutputStreamWriter out = new OutputStreamWriter(output, encoding);
            IOUtils.copy(input2, (Writer)out);
            out.flush();
        }
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static boolean contentEquals(Reader input1, Reader input2) throws IOException {
        int ch2;
        if (!(input1 instanceof BufferedReader)) {
            input1 = new BufferedReader(input1);
        }
        if (!(input2 instanceof BufferedReader)) {
            input2 = new BufferedReader(input2);
        }
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    static {
        StringWriter buf = new StringWriter(4);
        PrintWriter out = new PrintWriter(buf);
        out.println();
        LINE_SEPARATOR = buf.toString();
    }
}

