/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.IOException;
import java.io.OutputStream;

public class HexDump {
    public static final String EOL = System.getProperty("line.separator");
    private static final StringBuffer _lbuffer = new StringBuffer(8);
    private static final StringBuffer _cbuffer = new StringBuffer(2);
    private static final char[] _hexcodes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] _shifts = new int[]{28, 24, 20, 16, 12, 8, 4, 0};

    public static void dump(byte[] data2, long offset, OutputStream stream, int index2) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (index2 < 0 || index2 >= data2.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + index2 + " into array of length " + data2.length);
        }
        if (stream == null) {
            throw new IllegalArgumentException("cannot write to nullstream");
        }
        long display_offset = offset + (long)index2;
        StringBuffer buffer = new StringBuffer(74);
        for (int j = index2; j < data2.length; j += 16) {
            int k;
            int chars_read = data2.length - j;
            if (chars_read > 16) {
                chars_read = 16;
            }
            buffer.append(HexDump.dump(display_offset)).append(' ');
            for (k = 0; k < 16; ++k) {
                if (k < chars_read) {
                    buffer.append(HexDump.dump(data2[k + j]));
                } else {
                    buffer.append("  ");
                }
                buffer.append(' ');
            }
            for (k = 0; k < chars_read; ++k) {
                if (data2[k + j] >= 32 && data2[k + j] < 127) {
                    buffer.append((char)data2[k + j]);
                    continue;
                }
                buffer.append('.');
            }
            buffer.append(EOL);
            stream.write(buffer.toString().getBytes());
            stream.flush();
            buffer.setLength(0);
            display_offset += (long)chars_read;
        }
    }

    private static StringBuffer dump(long value2) {
        _lbuffer.setLength(0);
        for (int j = 0; j < 8; ++j) {
            _lbuffer.append(_hexcodes[(int)(value2 >> _shifts[j]) & 0xF]);
        }
        return _lbuffer;
    }

    private static StringBuffer dump(byte value2) {
        _cbuffer.setLength(0);
        for (int j = 0; j < 2; ++j) {
            _cbuffer.append(_hexcodes[value2 >> _shifts[j + 6] & 0xF]);
        }
        return _cbuffer;
    }
}

