/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufProcessor;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.util.Signal;
import io.netty.util.internal.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

final class ReplayingDecoderByteBuf
extends ByteBuf {
    private static final Signal REPLAY = ReplayingDecoder.REPLAY;
    private ByteBuf buffer;
    private boolean terminated;
    private SwappedByteBuf swapped;
    static final ReplayingDecoderByteBuf EMPTY_BUFFER = new ReplayingDecoderByteBuf(Unpooled.EMPTY_BUFFER);

    ReplayingDecoderByteBuf() {
    }

    ReplayingDecoderByteBuf(ByteBuf buffer) {
        this.setCumulation(buffer);
    }

    void setCumulation(ByteBuf buffer) {
        this.buffer = buffer;
    }

    void terminate() {
        this.terminated = true;
    }

    @Override
    public int capacity() {
        if (this.terminated) {
            return this.buffer.capacity();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public int maxCapacity() {
        return this.capacity();
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.buffer.alloc();
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf clear() {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int compareTo(ByteBuf buffer) {
        ReplayingDecoderByteBuf.reject();
        return 0;
    }

    @Override
    public ByteBuf copy() {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf copy(int index2, int length) {
        this.checkIndex(index2, length);
        return this.buffer.copy(index2, length);
    }

    @Override
    public ByteBuf discardReadBytes() {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf ensureWritable(int writableBytes) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public int ensureWritable(int minWritableBytes, boolean force2) {
        ReplayingDecoderByteBuf.reject();
        return 0;
    }

    @Override
    public ByteBuf duplicate() {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public boolean getBoolean(int index2) {
        this.checkIndex(index2, 1);
        return this.buffer.getBoolean(index2);
    }

    @Override
    public byte getByte(int index2) {
        this.checkIndex(index2, 1);
        return this.buffer.getByte(index2);
    }

    @Override
    public short getUnsignedByte(int index2) {
        this.checkIndex(index2, 1);
        return this.buffer.getUnsignedByte(index2);
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length) {
        this.checkIndex(index2, length);
        this.buffer.getBytes(index2, dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst) {
        this.checkIndex(index2, dst.length);
        this.buffer.getBytes(index2, dst);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuffer dst) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length) {
        this.checkIndex(index2, length);
        this.buffer.getBytes(index2, dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int length) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public int getBytes(int index2, GatheringByteChannel out, int length) {
        ReplayingDecoderByteBuf.reject();
        return 0;
    }

    @Override
    public ByteBuf getBytes(int index2, OutputStream out, int length) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public int getInt(int index2) {
        this.checkIndex(index2, 4);
        return this.buffer.getInt(index2);
    }

    @Override
    public long getUnsignedInt(int index2) {
        this.checkIndex(index2, 4);
        return this.buffer.getUnsignedInt(index2);
    }

    @Override
    public long getLong(int index2) {
        this.checkIndex(index2, 8);
        return this.buffer.getLong(index2);
    }

    @Override
    public int getMedium(int index2) {
        this.checkIndex(index2, 3);
        return this.buffer.getMedium(index2);
    }

    @Override
    public int getUnsignedMedium(int index2) {
        this.checkIndex(index2, 3);
        return this.buffer.getUnsignedMedium(index2);
    }

    @Override
    public short getShort(int index2) {
        this.checkIndex(index2, 2);
        return this.buffer.getShort(index2);
    }

    @Override
    public int getUnsignedShort(int index2) {
        this.checkIndex(index2, 2);
        return this.buffer.getUnsignedShort(index2);
    }

    @Override
    public char getChar(int index2) {
        this.checkIndex(index2, 2);
        return this.buffer.getChar(index2);
    }

    @Override
    public float getFloat(int index2) {
        this.checkIndex(index2, 4);
        return this.buffer.getFloat(index2);
    }

    @Override
    public double getDouble(int index2) {
        this.checkIndex(index2, 8);
        return this.buffer.getDouble(index2);
    }

    @Override
    public int hashCode() {
        ReplayingDecoderByteBuf.reject();
        return 0;
    }

    @Override
    public int indexOf(int fromIndex, int toIndex, byte value2) {
        if (fromIndex == toIndex) {
            return -1;
        }
        if (Math.max(fromIndex, toIndex) > this.buffer.writerIndex()) {
            throw REPLAY;
        }
        return this.buffer.indexOf(fromIndex, toIndex, value2);
    }

    @Override
    public int bytesBefore(byte value2) {
        int bytes = this.buffer.bytesBefore(value2);
        if (bytes < 0) {
            throw REPLAY;
        }
        return bytes;
    }

    @Override
    public int bytesBefore(int length, byte value2) {
        int readerIndex = this.buffer.readerIndex();
        return this.bytesBefore(readerIndex, this.buffer.writerIndex() - readerIndex, value2);
    }

    @Override
    public int bytesBefore(int index2, int length, byte value2) {
        int writerIndex = this.buffer.writerIndex();
        if (index2 >= writerIndex) {
            throw REPLAY;
        }
        if (index2 <= writerIndex - length) {
            return this.buffer.bytesBefore(index2, length, value2);
        }
        int res = this.buffer.bytesBefore(index2, writerIndex - index2, value2);
        if (res < 0) {
            throw REPLAY;
        }
        return res;
    }

    @Override
    public int forEachByte(ByteBufProcessor processor) {
        int ret = this.buffer.forEachByte(processor);
        if (ret < 0) {
            throw REPLAY;
        }
        return ret;
    }

    @Override
    public int forEachByte(int index2, int length, ByteBufProcessor processor) {
        int writerIndex = this.buffer.writerIndex();
        if (index2 >= writerIndex) {
            throw REPLAY;
        }
        if (index2 <= writerIndex - length) {
            return this.buffer.forEachByte(index2, length, processor);
        }
        int ret = this.buffer.forEachByte(index2, writerIndex - index2, processor);
        if (ret < 0) {
            throw REPLAY;
        }
        return ret;
    }

    @Override
    public int forEachByteDesc(ByteBufProcessor processor) {
        if (this.terminated) {
            return this.buffer.forEachByteDesc(processor);
        }
        ReplayingDecoderByteBuf.reject();
        return 0;
    }

    @Override
    public int forEachByteDesc(int index2, int length, ByteBufProcessor processor) {
        if (index2 + length > this.buffer.writerIndex()) {
            throw REPLAY;
        }
        return this.buffer.forEachByteDesc(index2, length, processor);
    }

    @Override
    public ByteBuf markReaderIndex() {
        this.buffer.markReaderIndex();
        return this;
    }

    @Override
    public ByteBuf markWriterIndex() {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteOrder order() {
        return this.buffer.order();
    }

    @Override
    public ByteBuf order(ByteOrder endianness) {
        if (endianness == null) {
            throw new NullPointerException("endianness");
        }
        if (endianness == this.order()) {
            return this;
        }
        SwappedByteBuf swapped = this.swapped;
        if (swapped == null) {
            this.swapped = swapped = new SwappedByteBuf(this);
        }
        return swapped;
    }

    @Override
    public boolean isReadable() {
        return this.terminated ? this.buffer.isReadable() : true;
    }

    @Override
    public boolean isReadable(int size2) {
        return this.terminated ? this.buffer.isReadable(size2) : true;
    }

    @Override
    public int readableBytes() {
        if (this.terminated) {
            return this.buffer.readableBytes();
        }
        return Integer.MAX_VALUE - this.buffer.readerIndex();
    }

    @Override
    public boolean readBoolean() {
        this.checkReadableBytes(1);
        return this.buffer.readBoolean();
    }

    @Override
    public byte readByte() {
        this.checkReadableBytes(1);
        return this.buffer.readByte();
    }

    @Override
    public short readUnsignedByte() {
        this.checkReadableBytes(1);
        return this.buffer.readUnsignedByte();
    }

    @Override
    public ByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        this.checkReadableBytes(length);
        this.buffer.readBytes(dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf readBytes(byte[] dst) {
        this.checkReadableBytes(dst.length);
        this.buffer.readBytes(dst);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuffer dst) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf dst, int dstIndex, int length) {
        this.checkReadableBytes(length);
        this.buffer.readBytes(dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf dst, int length) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf dst) {
        this.checkReadableBytes(dst.writableBytes());
        this.buffer.readBytes(dst);
        return this;
    }

    @Override
    public int readBytes(GatheringByteChannel out, int length) {
        ReplayingDecoderByteBuf.reject();
        return 0;
    }

    @Override
    public ByteBuf readBytes(int length) {
        this.checkReadableBytes(length);
        return this.buffer.readBytes(length);
    }

    @Override
    public ByteBuf readSlice(int length) {
        this.checkReadableBytes(length);
        return this.buffer.readSlice(length);
    }

    @Override
    public ByteBuf readBytes(OutputStream out, int length) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    @Override
    public ByteBuf readerIndex(int readerIndex) {
        this.buffer.readerIndex(readerIndex);
        return this;
    }

    @Override
    public int readInt() {
        this.checkReadableBytes(4);
        return this.buffer.readInt();
    }

    @Override
    public long readUnsignedInt() {
        this.checkReadableBytes(4);
        return this.buffer.readUnsignedInt();
    }

    @Override
    public long readLong() {
        this.checkReadableBytes(8);
        return this.buffer.readLong();
    }

    @Override
    public int readMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readMedium();
    }

    @Override
    public int readUnsignedMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readUnsignedMedium();
    }

    @Override
    public short readShort() {
        this.checkReadableBytes(2);
        return this.buffer.readShort();
    }

    @Override
    public int readUnsignedShort() {
        this.checkReadableBytes(2);
        return this.buffer.readUnsignedShort();
    }

    @Override
    public char readChar() {
        this.checkReadableBytes(2);
        return this.buffer.readChar();
    }

    @Override
    public float readFloat() {
        this.checkReadableBytes(4);
        return this.buffer.readFloat();
    }

    @Override
    public double readDouble() {
        this.checkReadableBytes(8);
        return this.buffer.readDouble();
    }

    @Override
    public ByteBuf resetReaderIndex() {
        this.buffer.resetReaderIndex();
        return this;
    }

    @Override
    public ByteBuf resetWriterIndex() {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf setBoolean(int index2, boolean value2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf setByte(int index2, int value2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuffer src) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int length) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public int setBytes(int index2, InputStream in, int length) {
        ReplayingDecoderByteBuf.reject();
        return 0;
    }

    @Override
    public ByteBuf setZero(int index2, int length) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public int setBytes(int index2, ScatteringByteChannel in, int length) {
        ReplayingDecoderByteBuf.reject();
        return 0;
    }

    @Override
    public ByteBuf setIndex(int readerIndex, int writerIndex) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf setInt(int index2, int value2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf setLong(int index2, long value2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf setMedium(int index2, int value2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf setShort(int index2, int value2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf setChar(int index2, int value2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf setFloat(int index2, float value2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf setDouble(int index2, double value2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf skipBytes(int length) {
        this.checkReadableBytes(length);
        this.buffer.skipBytes(length);
        return this;
    }

    @Override
    public ByteBuf slice() {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf slice(int index2, int length) {
        this.checkIndex(index2, length);
        return this.buffer.slice(index2, length);
    }

    @Override
    public int nioBufferCount() {
        return this.buffer.nioBufferCount();
    }

    @Override
    public ByteBuffer nioBuffer() {
        ReplayingDecoderByteBuf.reject();
        return null;
    }

    @Override
    public ByteBuffer nioBuffer(int index2, int length) {
        this.checkIndex(index2, length);
        return this.buffer.nioBuffer(index2, length);
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        ReplayingDecoderByteBuf.reject();
        return null;
    }

    @Override
    public ByteBuffer[] nioBuffers(int index2, int length) {
        this.checkIndex(index2, length);
        return this.buffer.nioBuffers(index2, length);
    }

    @Override
    public ByteBuffer internalNioBuffer(int index2, int length) {
        this.checkIndex(index2, length);
        return this.buffer.internalNioBuffer(index2, length);
    }

    @Override
    public String toString(int index2, int length, Charset charset) {
        this.checkIndex(index2, length);
        return this.buffer.toString(index2, length, charset);
    }

    @Override
    public String toString(Charset charsetName) {
        ReplayingDecoderByteBuf.reject();
        return null;
    }

    @Override
    public String toString() {
        return StringUtil.simpleClassName(this) + '(' + "ridx=" + this.readerIndex() + ", " + "widx=" + this.writerIndex() + ')';
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isWritable(int size2) {
        return false;
    }

    @Override
    public int writableBytes() {
        return 0;
    }

    @Override
    public int maxWritableBytes() {
        return 0;
    }

    @Override
    public ByteBuf writeBoolean(boolean value2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf writeByte(int value2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf writeBytes(byte[] src) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuffer src) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src, int srcIndex, int length) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src, int length) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public int writeBytes(InputStream in, int length) {
        ReplayingDecoderByteBuf.reject();
        return 0;
    }

    @Override
    public int writeBytes(ScatteringByteChannel in, int length) {
        ReplayingDecoderByteBuf.reject();
        return 0;
    }

    @Override
    public ByteBuf writeInt(int value2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf writeLong(long value2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf writeMedium(int value2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf writeZero(int length) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    @Override
    public ByteBuf writerIndex(int writerIndex) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf writeShort(int value2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf writeChar(int value2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf writeFloat(float value2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf writeDouble(double value2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    private void checkIndex(int index2, int length) {
        if (index2 + length > this.buffer.writerIndex()) {
            throw REPLAY;
        }
    }

    private void checkReadableBytes(int readableBytes) {
        if (this.buffer.readableBytes() < readableBytes) {
            throw REPLAY;
        }
    }

    @Override
    public ByteBuf discardSomeReadBytes() {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public int refCnt() {
        return this.buffer.refCnt();
    }

    @Override
    public ByteBuf retain() {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public ByteBuf retain(int increment) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public boolean release() {
        ReplayingDecoderByteBuf.reject();
        return false;
    }

    @Override
    public boolean release(int decrement) {
        ReplayingDecoderByteBuf.reject();
        return false;
    }

    @Override
    public ByteBuf unwrap() {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    private static void reject() {
        throw new UnsupportedOperationException("not a replayable operation");
    }

    static {
        EMPTY_BUFFER.terminate();
    }
}

