/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractDerivedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufProcessor;
import io.netty.buffer.DuplicatedByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class SlicedByteBuf
extends AbstractDerivedByteBuf {
    private final ByteBuf buffer;
    private final int adjustment;
    private final int length;

    public SlicedByteBuf(ByteBuf buffer, int index2, int length) {
        super(length);
        if (index2 < 0 || index2 > buffer.capacity() - length) {
            throw new IndexOutOfBoundsException(buffer + ".slice(" + index2 + ", " + length + ')');
        }
        if (buffer instanceof SlicedByteBuf) {
            this.buffer = ((SlicedByteBuf)buffer).buffer;
            this.adjustment = ((SlicedByteBuf)buffer).adjustment + index2;
        } else if (buffer instanceof DuplicatedByteBuf) {
            this.buffer = buffer.unwrap();
            this.adjustment = index2;
        } else {
            this.buffer = buffer;
            this.adjustment = index2;
        }
        this.length = length;
        this.writerIndex(length);
    }

    @Override
    public ByteBuf unwrap() {
        return this.buffer;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.buffer.alloc();
    }

    @Override
    public ByteOrder order() {
        return this.buffer.order();
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public int capacity() {
        return this.length;
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        throw new UnsupportedOperationException("sliced buffer");
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.idx(this.buffer.arrayOffset());
    }

    @Override
    public boolean hasMemoryAddress() {
        return this.buffer.hasMemoryAddress();
    }

    @Override
    public long memoryAddress() {
        return this.buffer.memoryAddress() + (long)this.adjustment;
    }

    @Override
    protected byte _getByte(int index2) {
        return this.buffer.getByte(this.idx(index2));
    }

    @Override
    protected short _getShort(int index2) {
        return this.buffer.getShort(this.idx(index2));
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return this.buffer.getUnsignedMedium(this.idx(index2));
    }

    @Override
    protected int _getInt(int index2) {
        return this.buffer.getInt(this.idx(index2));
    }

    @Override
    protected long _getLong(int index2) {
        return this.buffer.getLong(this.idx(index2));
    }

    @Override
    public ByteBuf duplicate() {
        ByteBuf duplicate = this.buffer.slice(this.adjustment, this.length);
        duplicate.setIndex(this.readerIndex(), this.writerIndex());
        return duplicate;
    }

    @Override
    public ByteBuf copy(int index2, int length) {
        this.checkIndex0(index2, length);
        return this.buffer.copy(this.idx(index2), length);
    }

    @Override
    public ByteBuf slice(int index2, int length) {
        this.checkIndex0(index2, length);
        return this.buffer.slice(this.idx(index2), length);
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length) {
        this.checkIndex0(index2, length);
        this.buffer.getBytes(this.idx(index2), dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length) {
        this.checkIndex0(index2, length);
        this.buffer.getBytes(this.idx(index2), dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuffer dst) {
        this.checkIndex0(index2, dst.remaining());
        this.buffer.getBytes(this.idx(index2), dst);
        return this;
    }

    @Override
    protected void _setByte(int index2, int value2) {
        this.buffer.setByte(this.idx(index2), value2);
    }

    @Override
    protected void _setShort(int index2, int value2) {
        this.buffer.setShort(this.idx(index2), value2);
    }

    @Override
    protected void _setMedium(int index2, int value2) {
        this.buffer.setMedium(this.idx(index2), value2);
    }

    @Override
    protected void _setInt(int index2, int value2) {
        this.buffer.setInt(this.idx(index2), value2);
    }

    @Override
    protected void _setLong(int index2, long value2) {
        this.buffer.setLong(this.idx(index2), value2);
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length) {
        this.checkIndex0(index2, length);
        this.buffer.setBytes(this.idx(index2), src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length) {
        this.checkIndex0(index2, length);
        this.buffer.setBytes(this.idx(index2), src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuffer src) {
        this.checkIndex0(index2, src.remaining());
        this.buffer.setBytes(this.idx(index2), src);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, OutputStream out, int length) throws IOException {
        this.checkIndex0(index2, length);
        this.buffer.getBytes(this.idx(index2), out, length);
        return this;
    }

    @Override
    public int getBytes(int index2, GatheringByteChannel out, int length) throws IOException {
        this.checkIndex0(index2, length);
        return this.buffer.getBytes(this.idx(index2), out, length);
    }

    @Override
    public int setBytes(int index2, InputStream in, int length) throws IOException {
        this.checkIndex0(index2, length);
        return this.buffer.setBytes(this.idx(index2), in, length);
    }

    @Override
    public int setBytes(int index2, ScatteringByteChannel in, int length) throws IOException {
        this.checkIndex0(index2, length);
        return this.buffer.setBytes(this.idx(index2), in, length);
    }

    @Override
    public int nioBufferCount() {
        return this.buffer.nioBufferCount();
    }

    @Override
    public ByteBuffer nioBuffer(int index2, int length) {
        this.checkIndex0(index2, length);
        return this.buffer.nioBuffer(this.idx(index2), length);
    }

    @Override
    public ByteBuffer[] nioBuffers(int index2, int length) {
        this.checkIndex0(index2, length);
        return this.buffer.nioBuffers(this.idx(index2), length);
    }

    @Override
    public ByteBuffer internalNioBuffer(int index2, int length) {
        return this.nioBuffer(index2, length);
    }

    @Override
    public int forEachByte(int index2, int length, ByteBufProcessor processor) {
        this.checkIndex0(index2, length);
        int ret = this.buffer.forEachByte(this.idx(index2), length, processor);
        if (ret >= this.adjustment) {
            return ret - this.adjustment;
        }
        return -1;
    }

    @Override
    public int forEachByteDesc(int index2, int length, ByteBufProcessor processor) {
        this.checkIndex0(index2, length);
        int ret = this.buffer.forEachByteDesc(this.idx(index2), length, processor);
        if (ret >= this.adjustment) {
            return ret - this.adjustment;
        }
        return -1;
    }

    final int idx(int index2) {
        return index2 + this.adjustment;
    }
}

