/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps;

import com.google.common.base.Objects;
import eu.europeana.cloud.common.model.Revision;
import eu.europeana.cloud.service.dps.InputDataType;
import eu.europeana.cloud.service.dps.OAIPMHHarvestingDetails;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class DpsTask
implements Serializable {
    private Map<InputDataType, List<String>> inputData;
    private Map<String, String> parameters;
    private Revision outputRevision;
    private Date startTime = null;
    private Date createTime = new Date(System.currentTimeMillis());
    private Date endTime = null;
    private long taskId;
    private String taskName;
    private OAIPMHHarvestingDetails harvestingDetails;

    public DpsTask() {
        this("");
    }

    public DpsTask(String taskName) {
        this.taskName = taskName;
        this.inputData = new HashMap<InputDataType, List<String>>();
        this.parameters = new HashMap<String, String>();
        this.taskId = UUID.randomUUID().getMostSignificantBits();
        this.harvestingDetails = null;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public Revision getOutputRevision() {
        return this.outputRevision;
    }

    public void setOutputRevision(Revision outputRevision) {
        this.outputRevision = outputRevision;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void addDataEntry(InputDataType dataType, List<String> data2) {
        this.inputData.put(dataType, data2);
    }

    public List<String> getDataEntry(InputDataType dataType) {
        return this.inputData.get((Object)dataType);
    }

    public void addParameter(String parameterKey, String parameterValue) {
        this.parameters.put(parameterKey, parameterValue);
    }

    public String getParameter(String parameterKey) {
        return this.parameters.get(parameterKey);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public Map<InputDataType, List<String>> getInputData() {
        return this.inputData;
    }

    public void setInputData(Map<InputDataType, List<String>> inputData) {
        this.inputData = inputData;
    }

    public OAIPMHHarvestingDetails getHarvestingDetails() {
        return this.harvestingDetails;
    }

    public void setHarvestingDetails(OAIPMHHarvestingDetails harvestingDetails) {
        this.harvestingDetails = harvestingDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DpsTask)) {
            return false;
        }
        DpsTask dpsTask = (DpsTask)o;
        return this.taskId == dpsTask.taskId && Objects.equal(this.inputData, dpsTask.inputData) && Objects.equal(this.parameters, dpsTask.parameters) && Objects.equal(this.outputRevision, dpsTask.outputRevision) && Objects.equal(this.startTime, dpsTask.startTime) && Objects.equal(this.createTime, dpsTask.createTime) && Objects.equal(this.endTime, dpsTask.endTime) && Objects.equal(this.taskName, dpsTask.taskName) && Objects.equal(this.harvestingDetails, dpsTask.harvestingDetails);
    }

    public int hashCode() {
        return Objects.hashCode(this.inputData, this.parameters, this.outputRevision, this.startTime, this.createTime, this.endTime, this.taskId, this.taskName, this.harvestingDetails);
    }
}

