/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.coordination.registration;

import com.google.common.base.Throwables;
import eu.europeana.cloud.service.coordination.ServiceProperties;
import eu.europeana.cloud.service.coordination.ZookeeperService;
import eu.europeana.cloud.service.coordination.registration.EcloudServiceAdvertiser;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceInstanceBuilder;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.curator.x.discovery.details.JsonInstanceSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class ZookeeperServiceAdvertiser
implements EcloudServiceAdvertiser {
    @Autowired
    ServletContext servletContext;
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperServiceAdvertiser.class);
    private ServiceProperties currentlyAdvertisedServiceProperties;
    private String currentlyAdvertisedServiceID;
    private final InstanceSerializer<ServiceProperties> serializer = new JsonInstanceSerializer<ServiceProperties>(ServiceProperties.class);
    private final ServiceDiscovery<ServiceProperties> discovery;
    private ServiceProperties serviceProperties;

    ZookeeperServiceAdvertiser(ZookeeperService zookeeper, String discoveryPath, ServiceProperties serviceProperties) {
        LOGGER.info("ZookeeperServiceAdvertiser starting...");
        this.serviceProperties = serviceProperties;
        this.discovery = ServiceDiscoveryBuilder.builder(ServiceProperties.class).basePath(zookeeper.getZookeeperPath() + discoveryPath).client(zookeeper.getClient()).serializer(this.serializer).build();
        try {
            this.discovery.start();
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
        LOGGER.info("ZookeeperServiceAdvertiser started successfully.");
    }

    @Override
    public void startAdvertising(ServiceProperties serviceProperties) {
        LOGGER.info("ZookeeperServiceAdvertiser starting advertising process '{}' ...", (Object)serviceProperties);
        try {
            ServiceInstance<ServiceProperties> propertiesToBeRegisteredInZoo = ZookeeperServiceAdvertiser.convert(serviceProperties);
            this.discovery.registerService(propertiesToBeRegisteredInZoo);
            this.currentlyAdvertisedServiceProperties = serviceProperties;
            this.currentlyAdvertisedServiceID = propertiesToBeRegisteredInZoo.getId();
            LOGGER.info("ZookeeperServiceAdvertiser has advertised the service successfully.");
        }
        catch (Exception e) {
            this.currentlyAdvertisedServiceProperties = null;
            this.currentlyAdvertisedServiceID = null;
            LOGGER.error(e.getMessage());
            throw Throwables.propagate(e);
        }
    }

    @Override
    public void stopAdvertising() {
        LOGGER.info("ZookeeperServiceAdvertiser unregistering process '{}' ...", (Object)this.serviceProperties);
        try {
            this.discovery.unregisterService(ZookeeperServiceAdvertiser.convert(this.currentlyAdvertisedServiceProperties));
            this.currentlyAdvertisedServiceProperties = null;
            this.currentlyAdvertisedServiceID = null;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw Throwables.propagate(e);
        }
    }

    private static ServiceInstance<ServiceProperties> convert(ServiceProperties p) throws Exception {
        return ServiceInstance.builder().name(p.getServiceName()).payload(p).address(p.getListenAddress()).build();
    }

    private String getAutoListenAddress() throws UnknownHostException, IOException {
        Collection<InetAddress> localIps = ServiceInstanceBuilder.getAllLocalIPs();
        Iterator<InetAddress> localIpsIter = localIps.iterator();
        LOGGER.info("ZookeeperServiceAdvertiser: autodetecting ip address.. found {} localIpAddresses", (Object)localIps.size());
        while (localIpsIter.hasNext()) {
            InetAddress localIp = localIpsIter.next();
            if (!localIp.isReachable(5000)) continue;
            String address = localIp.getLocalHost().getHostAddress();
            LOGGER.info("ZookeeperServiceAdvertiser: autodetected {} as listen address", (Object)address);
            return address;
        }
        return null;
    }

    private String getServletContextPath() {
        String servletPath = this.servletContext.getContextPath();
        LOGGER.info("ZookeeperServiceAdvertiser detecting ContextPath: {}", (Object)servletPath);
        return servletPath;
    }

    private String getPort() {
        return "8080";
    }

    @PostConstruct
    public void postConstruct() {
        try {
            if (this.serviceProperties.getListenAddress().isEmpty()) {
                String autodectedIpaddress = this.getAutoListenAddress();
                if (autodectedIpaddress != null) {
                    this.serviceProperties.setListenAddress("http://" + this.getAutoListenAddress() + ":" + this.getPort() + this.getServletContextPath());
                }
            } else {
                this.serviceProperties.setListenAddress(this.serviceProperties.getListenAddress() + this.getServletContextPath());
            }
        }
        catch (Exception e) {
            LOGGER.warn("ZookeeperServiceAdvertiser: Error while setting service address.. {}", (Object)e.getMessage());
        }
        this.startAdvertising(this.serviceProperties);
        LOGGER.info("ZookeeperServiceAdvertiser advertising process successfull.");
    }

    @Override
    public String getCurrentlyAdvertisedServiceID() {
        return this.currentlyAdvertisedServiceID;
    }

    @Override
    public String getCurrentlyAdvertisedServiceAddress() {
        if (this.currentlyAdvertisedServiceProperties != null) {
            return this.currentlyAdvertisedServiceProperties.getListenAddress();
        }
        return null;
    }

    public ServiceProperties getServiceProperties() {
        return this.serviceProperties;
    }
}

