/*
 * Decompiled with CFR 0.152.
 */
package com.rits.cloning;

import com.rits.cloning.CloningException;
import com.rits.cloning.FastClonerArrayList;
import com.rits.cloning.FastClonerCalendar;
import com.rits.cloning.FastClonerConcurrentHashMap;
import com.rits.cloning.FastClonerHashMap;
import com.rits.cloning.FastClonerHashSet;
import com.rits.cloning.FastClonerLinkedList;
import com.rits.cloning.FastClonerTreeMap;
import com.rits.cloning.IDeepCloner;
import com.rits.cloning.IDumpCloned;
import com.rits.cloning.IFastCloner;
import com.rits.cloning.IFreezable;
import com.rits.cloning.IInstantiationStrategy;
import com.rits.cloning.Immutable;
import com.rits.cloning.ObjenesisInstantiationStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cloner {
    private final IInstantiationStrategy instantiationStrategy;
    private final Set<Class<?>> ignored = new HashSet();
    private final Set<Class<?>> ignoredInstanceOf = new HashSet();
    private final Set<Class<?>> nullInstead = new HashSet();
    private final Map<Class<?>, IFastCloner> fastCloners = new HashMap();
    private final Map<Object, Boolean> ignoredInstances = new IdentityHashMap<Object, Boolean>();
    private final ConcurrentHashMap<Class<?>, List<Field>> fieldsCache = new ConcurrentHashMap();
    private IDumpCloned dumpCloned = null;
    private boolean cloningEnabled = true;
    private boolean nullTransient = false;
    private boolean cloneSynthetics = true;
    private IDeepCloner deepCloner = new IDeepCloner(){

        @Override
        public <T> T deepClone(T o, Map<Object, Object> clones) {
            try {
                return Cloner.this.cloneInternal(o, clones);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
    };
    private final ConcurrentHashMap<Class<?>, Boolean> immutables = new ConcurrentHashMap();
    private boolean cloneAnonymousParent = true;

    public IDumpCloned getDumpCloned() {
        return this.dumpCloned;
    }

    public void setDumpCloned(IDumpCloned dumpCloned) {
        this.dumpCloned = dumpCloned;
    }

    public Cloner() {
        this.instantiationStrategy = ObjenesisInstantiationStrategy.getInstance();
        this.init();
    }

    public Cloner(IInstantiationStrategy instantiationStrategy) {
        this.instantiationStrategy = instantiationStrategy;
        this.init();
    }

    public boolean isNullTransient() {
        return this.nullTransient;
    }

    public void setNullTransient(boolean nullTransient) {
        this.nullTransient = nullTransient;
    }

    public void setCloneSynthetics(boolean cloneSynthetics) {
        this.cloneSynthetics = cloneSynthetics;
    }

    private void init() {
        this.registerKnownJdkImmutableClasses();
        this.registerKnownConstants();
        this.registerFastCloners();
    }

    protected void registerFastCloners() {
        this.fastCloners.put(GregorianCalendar.class, new FastClonerCalendar());
        this.fastCloners.put(ArrayList.class, new FastClonerArrayList());
        this.fastCloners.put(LinkedList.class, new FastClonerLinkedList());
        this.fastCloners.put(HashSet.class, new FastClonerHashSet());
        this.fastCloners.put(HashMap.class, new FastClonerHashMap());
        this.fastCloners.put(TreeMap.class, new FastClonerTreeMap());
        this.fastCloners.put(ConcurrentHashMap.class, new FastClonerConcurrentHashMap());
    }

    protected Object fastClone(Object o, Map<Object, Object> clones) throws IllegalAccessException {
        Class<?> c = o.getClass();
        IFastCloner fastCloner = this.fastCloners.get(c);
        if (fastCloner != null) {
            return fastCloner.clone(o, this.deepCloner, clones);
        }
        return null;
    }

    public void registerConstant(Object o) {
        this.ignoredInstances.put(o, true);
    }

    public void registerConstant(Class<?> c, String privateFieldName) {
        try {
            Field field2 = c.getDeclaredField(privateFieldName);
            field2.setAccessible(true);
            Object v = field2.get(null);
            this.ignoredInstances.put(v, true);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected void registerKnownJdkImmutableClasses() {
        this.registerImmutable(String.class);
        this.registerImmutable(Integer.class);
        this.registerImmutable(Long.class);
        this.registerImmutable(Boolean.class);
        this.registerImmutable(Class.class);
        this.registerImmutable(Float.class);
        this.registerImmutable(Double.class);
        this.registerImmutable(Character.class);
        this.registerImmutable(Byte.class);
        this.registerImmutable(Short.class);
        this.registerImmutable(Void.class);
        this.registerImmutable(BigDecimal.class);
        this.registerImmutable(BigInteger.class);
        this.registerImmutable(URI.class);
        this.registerImmutable(URL.class);
        this.registerImmutable(UUID.class);
        this.registerImmutable(Pattern.class);
    }

    protected void registerKnownConstants() {
        this.registerStaticFields(TreeSet.class, HashSet.class, HashMap.class, TreeMap.class);
    }

    public void registerStaticFields(Class<?> ... classes) {
        for (Class<?> c : classes) {
            List<Field> fields = this.allFields(c);
            for (Field field2 : fields) {
                int mods = field2.getModifiers();
                if (!Modifier.isStatic(mods) || field2.getType().isPrimitive()) continue;
                this.registerConstant(c, field2.getName());
            }
        }
    }

    public void setExtraStaticFields(Set<Class<?>> set) {
        this.registerStaticFields((Class[])set.toArray());
    }

    public void dontClone(Class<?> ... c) {
        for (Class<?> cl : c) {
            this.ignored.add(cl);
        }
    }

    public void dontCloneInstanceOf(Class<?> ... c) {
        for (Class<?> cl : c) {
            this.ignoredInstanceOf.add(cl);
        }
    }

    public void setDontCloneInstanceOf(Class<?> ... c) {
        this.dontCloneInstanceOf(c);
    }

    public void nullInsteadOfClone(Class<?> ... c) {
        for (Class<?> cl : c) {
            this.nullInstead.add(cl);
        }
    }

    public void setExtraNullInsteadOfClone(Set<Class<?>> set) {
        this.nullInstead.addAll(set);
    }

    public void registerImmutable(Class<?> ... c) {
        for (Class<?> cl : c) {
            this.ignored.add(cl);
        }
    }

    public void setExtraImmutables(Set<Class<?>> set) {
        this.ignored.addAll(set);
    }

    public void registerFastCloner(Class<?> c, IFastCloner fastCloner) {
        if (this.fastCloners.containsKey(c)) {
            throw new IllegalArgumentException(c + " already fast-cloned!");
        }
        this.fastCloners.put(c, fastCloner);
    }

    public void unregisterFastCloner(Class<?> c) {
        this.fastCloners.remove(c);
    }

    protected <T> T newInstance(Class<T> c) {
        return this.instantiationStrategy.newInstance(c);
    }

    public <T> T fastCloneOrNewInstance(Class<T> c) {
        try {
            Object fastClone = this.fastClone(c, null);
            if (fastClone != null) {
                return (T)fastClone;
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return this.newInstance(c);
    }

    public <T> T deepClone(T o) {
        if (o == null) {
            return null;
        }
        if (!this.cloningEnabled) {
            return o;
        }
        if (this.dumpCloned != null) {
            this.dumpCloned.startCloning(o.getClass());
        }
        IdentityHashMap<Object, Object> clones = new IdentityHashMap<Object, Object>(16);
        try {
            return this.cloneInternal(o, clones);
        }
        catch (IllegalAccessException e) {
            throw new CloningException("error during cloning of " + o, e);
        }
    }

    public <T> T deepCloneDontCloneInstances(T o, Object ... dontCloneThese) {
        if (o == null) {
            return null;
        }
        if (!this.cloningEnabled) {
            return o;
        }
        if (this.dumpCloned != null) {
            this.dumpCloned.startCloning(o.getClass());
        }
        IdentityHashMap<Object, Object> clones = new IdentityHashMap<Object, Object>(16);
        for (Object dc : dontCloneThese) {
            clones.put(dc, dc);
        }
        try {
            return this.cloneInternal(o, clones);
        }
        catch (IllegalAccessException e) {
            throw new CloningException("error during cloning of " + o, e);
        }
    }

    public <T> T shallowClone(T o) {
        if (o == null) {
            return null;
        }
        if (!this.cloningEnabled) {
            return o;
        }
        try {
            return this.cloneInternal(o, null);
        }
        catch (IllegalAccessException e) {
            throw new CloningException("error during cloning of " + o, e);
        }
    }

    protected boolean considerImmutable(Class<?> clz) {
        return false;
    }

    protected Class<?> getImmutableAnnotation() {
        return Immutable.class;
    }

    private boolean isImmutable(Class<?> clz) {
        Boolean isIm = this.immutables.get(clz);
        if (isIm != null) {
            return isIm;
        }
        if (this.considerImmutable(clz)) {
            return true;
        }
        Class<?> immutableAnnotation = this.getImmutableAnnotation();
        for (Annotation annotation : clz.getDeclaredAnnotations()) {
            if (annotation.annotationType() != immutableAnnotation) continue;
            this.immutables.put(clz, Boolean.TRUE);
            return true;
        }
        for (Class<?> c = clz.getSuperclass(); c != null && c != Object.class; c = c.getSuperclass()) {
            for (Annotation annotation : c.getDeclaredAnnotations()) {
                Immutable im;
                if (annotation.annotationType() != Immutable.class || !(im = (Immutable)annotation).subClass()) continue;
                this.immutables.put(clz, Boolean.TRUE);
                return true;
            }
        }
        this.immutables.put(clz, Boolean.FALSE);
        return false;
    }

    protected <T> T cloneInternal(T o, Map<Object, Object> clones) throws IllegalAccessException {
        Object clonedPreviously;
        IFreezable f;
        if (o == null) {
            return null;
        }
        if (o == this) {
            return null;
        }
        if (this.ignoredInstances.containsKey(o)) {
            return o;
        }
        if (o instanceof Enum) {
            return o;
        }
        Class<?> clz = o.getClass();
        if (this.nullInstead.contains(clz)) {
            return null;
        }
        if (this.ignored.contains(clz)) {
            return o;
        }
        for (Class<?> iClz : this.ignoredInstanceOf) {
            if (!iClz.isAssignableFrom(clz)) continue;
            return o;
        }
        if (this.isImmutable(clz)) {
            return o;
        }
        if (o instanceof IFreezable && (f = (IFreezable)o).isFrozen()) {
            return o;
        }
        Object object = clonedPreviously = clones != null ? clones.get(o) : null;
        if (clonedPreviously != null) {
            return (T)clonedPreviously;
        }
        Object fastClone = this.fastClone(o, clones);
        if (fastClone != null) {
            if (clones != null) {
                clones.put(o, fastClone);
            }
            return (T)fastClone;
        }
        if (this.dumpCloned != null) {
            this.dumpCloned.startCloning(o.getClass());
        }
        if (clz.isArray()) {
            return this.cloneArray(o, clones);
        }
        return this.cloneObject(o, clones, clz);
    }

    private <T> T cloneObject(T o, Map<Object, Object> clones, Class<T> clz) throws IllegalAccessException {
        T newInstance = this.newInstance(clz);
        if (clones != null) {
            clones.put(o, newInstance);
        }
        List<Field> fields = this.allFields(clz);
        for (Field field2 : fields) {
            boolean shouldClone;
            int modifiers = field2.getModifiers();
            if (Modifier.isStatic(modifiers)) continue;
            if (this.nullTransient && Modifier.isTransient(modifiers)) {
                Class<?> type = field2.getType();
                if (type.isPrimitive()) continue;
                field2.set(newInstance, null);
                continue;
            }
            Object fieldObject = field2.get(o);
            boolean bl = shouldClone = (this.cloneSynthetics || !this.cloneSynthetics && !field2.isSynthetic()) && (this.cloneAnonymousParent || !this.cloneAnonymousParent && !this.isAnonymousParent(field2));
            Object fieldObjectClone = clones != null ? (shouldClone ? this.cloneInternal(fieldObject, clones) : fieldObject) : fieldObject;
            field2.set(newInstance, fieldObjectClone);
            if (this.dumpCloned == null || fieldObjectClone == fieldObject) continue;
            this.dumpCloned.cloning(field2, o.getClass());
        }
        return newInstance;
    }

    private <T> T cloneArray(T o, Map<Object, Object> clones) throws IllegalAccessException {
        Class<?> clz = o.getClass();
        int length = Array.getLength(o);
        Object newInstance = Array.newInstance(clz.getComponentType(), length);
        if (clones != null) {
            clones.put(o, newInstance);
        }
        for (int i = 0; i < length; ++i) {
            Object v = Array.get(o, i);
            Object clone2 = clones != null ? this.cloneInternal(v, clones) : v;
            Array.set(newInstance, i, clone2);
        }
        return (T)newInstance;
    }

    private boolean isAnonymousParent(Field field2) {
        return "this$0".equals(field2.getName());
    }

    public <T, E extends T> void copyPropertiesOfInheritedClass(T src, E dest) {
        if (src == null) {
            throw new IllegalArgumentException("src can't be null");
        }
        if (dest == null) {
            throw new IllegalArgumentException("dest can't be null");
        }
        Class<?> srcClz = src.getClass();
        Class<?> destClz = dest.getClass();
        if (srcClz.isArray()) {
            if (!destClz.isArray()) {
                throw new IllegalArgumentException("can't copy from array to non-array class " + destClz);
            }
            int length = Array.getLength(src);
            for (int i = 0; i < length; ++i) {
                Object v = Array.get(src, i);
                Array.set(dest, i, v);
            }
            return;
        }
        List<Field> fields = this.allFields(srcClz);
        List<Field> destFields = this.allFields(dest.getClass());
        for (Field field2 : fields) {
            if (Modifier.isStatic(field2.getModifiers())) continue;
            try {
                Object fieldObject = field2.get(src);
                field2.setAccessible(true);
                if (!destFields.contains(field2)) continue;
                field2.set(dest, fieldObject);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void addAll(List<Field> l, Field[] fields) {
        for (Field field2 : fields) {
            if (!field2.isAccessible()) {
                field2.setAccessible(true);
            }
            l.add(field2);
        }
    }

    protected List<Field> allFields(Class<?> c) {
        List<Field> l = this.fieldsCache.get(c);
        if (l == null) {
            l = new LinkedList<Field>();
            Field[] fields = c.getDeclaredFields();
            this.addAll(l, fields);
            Class<?> sc = c;
            while ((sc = sc.getSuperclass()) != Object.class && sc != null) {
                this.addAll(l, sc.getDeclaredFields());
            }
            this.fieldsCache.putIfAbsent(c, l);
        }
        return l;
    }

    public boolean isDumpClonedClasses() {
        return this.dumpCloned != null;
    }

    public void setDumpClonedClasses(boolean dumpClonedClasses) {
        this.dumpCloned = dumpClonedClasses ? new IDumpCloned(){

            @Override
            public void startCloning(Class<?> clz) {
                System.out.println("clone>" + clz);
            }

            @Override
            public void cloning(Field field2, Class<?> clz) {
                System.out.println("cloned field>" + field2 + "  -- of class " + clz);
            }
        } : null;
    }

    public boolean isCloningEnabled() {
        return this.cloningEnabled;
    }

    public void setCloningEnabled(boolean cloningEnabled) {
        this.cloningEnabled = cloningEnabled;
    }

    public void setCloneAnonymousParent(boolean cloneAnonymousParent) {
        this.cloneAnonymousParent = cloneAnonymousParent;
    }

    public boolean isCloneAnonymousParent() {
        return this.cloneAnonymousParent;
    }

    public static Cloner standard() {
        return new Cloner();
    }

    public static Cloner shared() {
        return new Cloner(new ObjenesisInstantiationStrategy());
    }
}

