/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.Platform;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

public abstract class MemoryIO {
    final Foreign foreign = Foreign.getInstance();
    private static final long ADDRESS_MASK = Platform.getPlatform().addressMask();

    public static MemoryIO getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static MemoryIO getCheckedInstance() {
        return CheckedMemorySingletonHolder.INSTANCE;
    }

    private MemoryIO() {
    }

    private static MemoryIO newMemoryIO() {
        try {
            if (Boolean.getBoolean("jffi.memory.checked")) {
                return MemoryIO.newNativeCheckedImpl();
            }
            return !Boolean.getBoolean("jffi.unsafe.disabled") && MemoryIO.isUnsafeAvailable() ? MemoryIO.newUnsafeImpl() : MemoryIO.newNativeImpl();
        }
        catch (Throwable t) {
            return MemoryIO.newNativeImpl();
        }
    }

    private static MemoryIO newNativeImpl() {
        return Platform.getPlatform().addressSize() == 32 ? MemoryIO.newNativeImpl32() : MemoryIO.newNativeImpl64();
    }

    private static MemoryIO newNativeCheckedImpl() {
        return Foreign.isMemoryProtectionEnabled() ? new CheckedNativeImpl() : MemoryIO.newNativeImpl();
    }

    private static MemoryIO newNativeImpl32() {
        return new NativeImpl32();
    }

    private static MemoryIO newNativeImpl64() {
        return new NativeImpl64();
    }

    private static MemoryIO newUnsafeImpl() {
        return Platform.getPlatform().addressSize() == 32 ? MemoryIO.newUnsafeImpl32() : MemoryIO.newUnsafeImpl64();
    }

    private static MemoryIO newUnsafeImpl32() {
        return new UnsafeImpl32();
    }

    private static MemoryIO newUnsafeImpl64() {
        return new UnsafeImpl64();
    }

    public abstract byte getByte(long var1);

    public abstract short getShort(long var1);

    public abstract int getInt(long var1);

    public abstract long getLong(long var1);

    public abstract float getFloat(long var1);

    public abstract double getDouble(long var1);

    public abstract long getAddress(long var1);

    public abstract void putByte(long var1, byte var3);

    public abstract void putShort(long var1, short var3);

    public abstract void putInt(long var1, int var3);

    public abstract void putLong(long var1, long var3);

    public abstract void putFloat(long var1, float var3);

    public abstract void putDouble(long var1, double var3);

    public abstract void putAddress(long var1, long var3);

    public final void copyMemory(long src, long dst, long size2) {
        if (dst + size2 <= src || src + size2 <= dst) {
            this._copyMemory(src, dst, size2);
        } else {
            this.memmove(dst, src, size2);
        }
    }

    abstract void _copyMemory(long var1, long var3, long var5);

    public abstract void setMemory(long var1, long var3, byte var5);

    public abstract void memcpy(long var1, long var3, long var5);

    public abstract void memmove(long var1, long var3, long var5);

    public final void memset(long address, int value2, long size2) {
        this.setMemory(address, size2, (byte)value2);
    }

    public abstract long memchr(long var1, int var3, long var4);

    public abstract void putByteArray(long var1, byte[] var3, int var4, int var5);

    public abstract void getByteArray(long var1, byte[] var3, int var4, int var5);

    public abstract void putCharArray(long var1, char[] var3, int var4, int var5);

    public abstract void getCharArray(long var1, char[] var3, int var4, int var5);

    public abstract void putShortArray(long var1, short[] var3, int var4, int var5);

    public abstract void getShortArray(long var1, short[] var3, int var4, int var5);

    public abstract void putIntArray(long var1, int[] var3, int var4, int var5);

    public abstract void getIntArray(long var1, int[] var3, int var4, int var5);

    public abstract void putLongArray(long var1, long[] var3, int var4, int var5);

    public abstract void getLongArray(long var1, long[] var3, int var4, int var5);

    public abstract void putFloatArray(long var1, float[] var3, int var4, int var5);

    public abstract void getFloatArray(long var1, float[] var3, int var4, int var5);

    public abstract void putDoubleArray(long var1, double[] var3, int var4, int var5);

    public abstract void getDoubleArray(long var1, double[] var3, int var4, int var5);

    public final long allocateMemory(long size2, boolean clear2) {
        return Foreign.allocateMemory(size2, clear2) & ADDRESS_MASK;
    }

    public final void freeMemory(long address) {
        Foreign.freeMemory(address);
    }

    public abstract long getStringLength(long var1);

    public abstract byte[] getZeroTerminatedByteArray(long var1);

    public abstract byte[] getZeroTerminatedByteArray(long var1, int var3);

    @Deprecated
    public final byte[] getZeroTerminatedByteArray(long address, long maxlen) {
        return this.getZeroTerminatedByteArray(address, (int)maxlen);
    }

    public abstract void putZeroTerminatedByteArray(long var1, byte[] var3, int var4, int var5);

    public final long indexOf(long address, byte value2) {
        long location = this.memchr(address, value2, Integer.MAX_VALUE);
        return location != 0L ? location - address : -1L;
    }

    public final long indexOf(long address, byte value2, int maxlen) {
        long location = this.memchr(address, value2, maxlen);
        return location != 0L ? location - address : -1L;
    }

    public final ByteBuffer newDirectByteBuffer(long address, int capacity) {
        return this.foreign.newDirectByteBuffer(address, capacity);
    }

    public final long getDirectBufferAddress(Buffer buffer) {
        return this.foreign.getDirectBufferAddress(buffer);
    }

    private static void verifyAccessor(Class unsafeClass, Class primitive) throws NoSuchMethodException {
        String primitiveName = primitive.getSimpleName();
        String typeName = primitiveName.substring(0, 1).toUpperCase() + primitiveName.substring(1);
        Method get2 = unsafeClass.getDeclaredMethod("get" + typeName, Long.TYPE);
        if (!get2.getReturnType().equals(primitive)) {
            throw new NoSuchMethodException("Incorrect return type for " + get2.getName());
        }
        unsafeClass.getDeclaredMethod("put" + typeName, Long.TYPE, primitive);
    }

    static boolean isUnsafeAvailable() {
        try {
            Class[] primitiveTypes;
            Class<?> sunClass = Class.forName("sun.misc.Unsafe");
            for (Class type : primitiveTypes = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
                MemoryIO.verifyAccessor(sunClass, type);
            }
            sunClass.getDeclaredMethod("getAddress", Long.TYPE);
            sunClass.getDeclaredMethod("putAddress", Long.TYPE, Long.TYPE);
            sunClass.getDeclaredMethod("allocateMemory", Long.TYPE);
            sunClass.getDeclaredMethod("freeMemory", Long.TYPE);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    static /* synthetic */ MemoryIO access$000() {
        return MemoryIO.newMemoryIO();
    }

    static /* synthetic */ MemoryIO access$100() {
        return MemoryIO.newNativeCheckedImpl();
    }

    private static class UnsafeImpl64
    extends UnsafeImpl {
        private UnsafeImpl64() {
        }

        @Override
        public final long getAddress(long address) {
            return unsafe.getLong(address);
        }

        @Override
        public final void putAddress(long address, long value2) {
            unsafe.putLong(address, value2);
        }
    }

    private static class UnsafeImpl32
    extends UnsafeImpl {
        private UnsafeImpl32() {
        }

        @Override
        public final long getAddress(long address) {
            return (long)unsafe.getInt(address) & ADDRESS_MASK;
        }

        @Override
        public final void putAddress(long address, long value2) {
            unsafe.putInt(address, (int)value2);
        }
    }

    private static abstract class UnsafeImpl
    extends MemoryIO {
        protected static Unsafe unsafe = (Unsafe)Unsafe.class.cast(UnsafeImpl.getUnsafe());

        private UnsafeImpl() {
        }

        private static Object getUnsafe() {
            try {
                Class<?> sunUnsafe = Class.forName("sun.misc.Unsafe");
                Field f = sunUnsafe.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                return f.get(sunUnsafe);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public final byte getByte(long address) {
            return unsafe.getByte(address);
        }

        @Override
        public final short getShort(long address) {
            return unsafe.getShort(address);
        }

        @Override
        public final int getInt(long address) {
            return unsafe.getInt(address);
        }

        @Override
        public final long getLong(long address) {
            return unsafe.getLong(address);
        }

        @Override
        public final float getFloat(long address) {
            return unsafe.getFloat(address);
        }

        @Override
        public final double getDouble(long address) {
            return unsafe.getDouble(address);
        }

        @Override
        public final void putByte(long address, byte value2) {
            unsafe.putByte(address, value2);
        }

        @Override
        public final void putShort(long address, short value2) {
            unsafe.putShort(address, value2);
        }

        @Override
        public final void putInt(long address, int value2) {
            unsafe.putInt(address, value2);
        }

        @Override
        public final void putLong(long address, long value2) {
            unsafe.putLong(address, value2);
        }

        @Override
        public final void putFloat(long address, float value2) {
            unsafe.putFloat(address, value2);
        }

        @Override
        public final void putDouble(long address, double value2) {
            unsafe.putDouble(address, value2);
        }

        @Override
        public final void _copyMemory(long src, long dst, long size2) {
            unsafe.copyMemory(src, dst, size2);
        }

        @Override
        public final void setMemory(long src, long size2, byte value2) {
            unsafe.setMemory(src, size2, value2);
        }

        @Override
        public final void memcpy(long dst, long src, long size2) {
            Foreign.memcpy(dst, src, size2);
        }

        @Override
        public final void memmove(long dst, long src, long size2) {
            Foreign.memmove(dst, src, size2);
        }

        @Override
        public final long memchr(long address, int value2, long size2) {
            return Foreign.memchr(address, value2, size2);
        }

        @Override
        public final void putByteArray(long address, byte[] data2, int offset, int length) {
            Foreign.putByteArray(address, data2, offset, length);
        }

        @Override
        public final void getByteArray(long address, byte[] data2, int offset, int length) {
            Foreign.getByteArray(address, data2, offset, length);
        }

        @Override
        public final void putCharArray(long address, char[] data2, int offset, int length) {
            Foreign.putCharArray(address, data2, offset, length);
        }

        @Override
        public final void getCharArray(long address, char[] data2, int offset, int length) {
            Foreign.getCharArray(address, data2, offset, length);
        }

        @Override
        public final void putShortArray(long address, short[] data2, int offset, int length) {
            Foreign.putShortArray(address, data2, offset, length);
        }

        @Override
        public final void getShortArray(long address, short[] data2, int offset, int length) {
            Foreign.getShortArray(address, data2, offset, length);
        }

        @Override
        public final void putIntArray(long address, int[] data2, int offset, int length) {
            Foreign.putIntArray(address, data2, offset, length);
        }

        @Override
        public final void getIntArray(long address, int[] data2, int offset, int length) {
            Foreign.getIntArray(address, data2, offset, length);
        }

        @Override
        public final void putLongArray(long address, long[] data2, int offset, int length) {
            Foreign.putLongArray(address, data2, offset, length);
        }

        @Override
        public final void getLongArray(long address, long[] data2, int offset, int length) {
            Foreign.getLongArray(address, data2, offset, length);
        }

        @Override
        public final void putFloatArray(long address, float[] data2, int offset, int length) {
            Foreign.putFloatArray(address, data2, offset, length);
        }

        @Override
        public final void getFloatArray(long address, float[] data2, int offset, int length) {
            Foreign.getFloatArray(address, data2, offset, length);
        }

        @Override
        public final void putDoubleArray(long address, double[] data2, int offset, int length) {
            Foreign.putDoubleArray(address, data2, offset, length);
        }

        @Override
        public final void getDoubleArray(long address, double[] data2, int offset, int length) {
            Foreign.getDoubleArray(address, data2, offset, length);
        }

        @Override
        public final long getStringLength(long address) {
            return Foreign.strlen(address);
        }

        @Override
        public final byte[] getZeroTerminatedByteArray(long address) {
            return Foreign.getZeroTerminatedByteArray(address);
        }

        @Override
        public final byte[] getZeroTerminatedByteArray(long address, int maxlen) {
            return Foreign.getZeroTerminatedByteArray(address, maxlen);
        }

        @Override
        public final void putZeroTerminatedByteArray(long address, byte[] data2, int offset, int length) {
            Foreign.putZeroTerminatedByteArray(address, data2, offset, length);
        }
    }

    private static final class NativeImpl64
    extends NativeImpl {
        private NativeImpl64() {
        }

        @Override
        public final long getAddress(long address) {
            return Foreign.getLong(address);
        }

        @Override
        public final void putAddress(long address, long value2) {
            Foreign.putLong(address, value2);
        }
    }

    private static final class CheckedNativeImpl
    extends MemoryIO {
        private CheckedNativeImpl() {
        }

        @Override
        public final byte getByte(long address) {
            return Foreign.getByteChecked(address);
        }

        @Override
        public final short getShort(long address) {
            return Foreign.getShortChecked(address);
        }

        @Override
        public final int getInt(long address) {
            return Foreign.getIntChecked(address);
        }

        @Override
        public final long getLong(long address) {
            return Foreign.getLongChecked(address);
        }

        @Override
        public final float getFloat(long address) {
            return Foreign.getFloatChecked(address);
        }

        @Override
        public final double getDouble(long address) {
            return Foreign.getDoubleChecked(address);
        }

        @Override
        public final void putByte(long address, byte value2) {
            Foreign.putByteChecked(address, value2);
        }

        @Override
        public final void putShort(long address, short value2) {
            Foreign.putShortChecked(address, value2);
        }

        @Override
        public final void putInt(long address, int value2) {
            Foreign.putIntChecked(address, value2);
        }

        @Override
        public final void putLong(long address, long value2) {
            Foreign.putLongChecked(address, value2);
        }

        @Override
        public final void putFloat(long address, float value2) {
            Foreign.putFloatChecked(address, value2);
        }

        @Override
        public final void putDouble(long address, double value2) {
            Foreign.putDoubleChecked(address, value2);
        }

        @Override
        public final void setMemory(long address, long size2, byte value2) {
            Foreign.setMemoryChecked(address, size2, value2);
        }

        @Override
        public final void _copyMemory(long src, long dst, long size2) {
            Foreign.copyMemoryChecked(src, dst, size2);
        }

        @Override
        public final long getAddress(long address) {
            return Foreign.getAddressChecked(address) & ADDRESS_MASK;
        }

        @Override
        public final void putAddress(long address, long value2) {
            Foreign.putAddressChecked(address, value2);
        }

        @Override
        public final void memcpy(long dst, long src, long size2) {
            Foreign.memcpyChecked(dst, src, size2);
        }

        @Override
        public final void memmove(long dst, long src, long size2) {
            Foreign.memmoveChecked(dst, src, size2);
        }

        @Override
        public final long memchr(long address, int value2, long size2) {
            return Foreign.memchrChecked(address, value2, size2);
        }

        @Override
        public final void putByteArray(long address, byte[] data2, int offset, int length) {
            Foreign.putByteArrayChecked(address, data2, offset, length);
        }

        @Override
        public final void getByteArray(long address, byte[] data2, int offset, int length) {
            Foreign.getByteArrayChecked(address, data2, offset, length);
        }

        @Override
        public final void putCharArray(long address, char[] data2, int offset, int length) {
            Foreign.putCharArrayChecked(address, data2, offset, length);
        }

        @Override
        public final void getCharArray(long address, char[] data2, int offset, int length) {
            Foreign.getCharArrayChecked(address, data2, offset, length);
        }

        @Override
        public final void putShortArray(long address, short[] data2, int offset, int length) {
            Foreign.putShortArrayChecked(address, data2, offset, length);
        }

        @Override
        public final void getShortArray(long address, short[] data2, int offset, int length) {
            Foreign.getShortArrayChecked(address, data2, offset, length);
        }

        @Override
        public final void putIntArray(long address, int[] data2, int offset, int length) {
            Foreign.putIntArrayChecked(address, data2, offset, length);
        }

        @Override
        public final void getIntArray(long address, int[] data2, int offset, int length) {
            Foreign.getIntArrayChecked(address, data2, offset, length);
        }

        @Override
        public final void putLongArray(long address, long[] data2, int offset, int length) {
            Foreign.putLongArrayChecked(address, data2, offset, length);
        }

        @Override
        public final void getLongArray(long address, long[] data2, int offset, int length) {
            Foreign.getLongArrayChecked(address, data2, offset, length);
        }

        @Override
        public final void putFloatArray(long address, float[] data2, int offset, int length) {
            Foreign.putFloatArrayChecked(address, data2, offset, length);
        }

        @Override
        public final void getFloatArray(long address, float[] data2, int offset, int length) {
            Foreign.getFloatArrayChecked(address, data2, offset, length);
        }

        @Override
        public final void putDoubleArray(long address, double[] data2, int offset, int length) {
            Foreign.putDoubleArrayChecked(address, data2, offset, length);
        }

        @Override
        public final void getDoubleArray(long address, double[] data2, int offset, int length) {
            Foreign.getDoubleArrayChecked(address, data2, offset, length);
        }

        @Override
        public final long getStringLength(long address) {
            return Foreign.strlenChecked(address);
        }

        @Override
        public final byte[] getZeroTerminatedByteArray(long address) {
            return Foreign.getZeroTerminatedByteArrayChecked(address);
        }

        @Override
        public final byte[] getZeroTerminatedByteArray(long address, int maxlen) {
            return Foreign.getZeroTerminatedByteArrayChecked(address, maxlen);
        }

        @Override
        public final void putZeroTerminatedByteArray(long address, byte[] data2, int offset, int length) {
            Foreign.putZeroTerminatedByteArrayChecked(address, data2, offset, length);
        }
    }

    private static final class NativeImpl32
    extends NativeImpl {
        private NativeImpl32() {
        }

        @Override
        public final long getAddress(long address) {
            return (long)Foreign.getInt(address) & ADDRESS_MASK;
        }

        @Override
        public final void putAddress(long address, long value2) {
            Foreign.putInt(address, (int)value2);
        }
    }

    private static abstract class NativeImpl
    extends MemoryIO {
        private NativeImpl() {
        }

        @Override
        public final byte getByte(long address) {
            return Foreign.getByte(address);
        }

        @Override
        public final short getShort(long address) {
            return Foreign.getShort(address);
        }

        @Override
        public final int getInt(long address) {
            return Foreign.getInt(address);
        }

        @Override
        public final long getLong(long address) {
            return Foreign.getLong(address);
        }

        @Override
        public final float getFloat(long address) {
            return Foreign.getFloat(address);
        }

        @Override
        public final double getDouble(long address) {
            return Foreign.getDouble(address);
        }

        @Override
        public final void putByte(long address, byte value2) {
            Foreign.putByte(address, value2);
        }

        @Override
        public final void putShort(long address, short value2) {
            Foreign.putShort(address, value2);
        }

        @Override
        public final void putInt(long address, int value2) {
            Foreign.putInt(address, value2);
        }

        @Override
        public final void putLong(long address, long value2) {
            Foreign.putLong(address, value2);
        }

        @Override
        public final void putFloat(long address, float value2) {
            Foreign.putFloat(address, value2);
        }

        @Override
        public final void putDouble(long address, double value2) {
            Foreign.putDouble(address, value2);
        }

        @Override
        public final void setMemory(long address, long size2, byte value2) {
            Foreign.setMemory(address, size2, value2);
        }

        @Override
        public final void _copyMemory(long src, long dst, long size2) {
            Foreign.copyMemory(src, dst, size2);
        }

        @Override
        public final void memcpy(long dst, long src, long size2) {
            Foreign.memcpy(dst, src, size2);
        }

        @Override
        public final void memmove(long dst, long src, long size2) {
            Foreign.memmove(dst, src, size2);
        }

        @Override
        public final long memchr(long address, int value2, long size2) {
            return Foreign.memchr(address, value2, size2);
        }

        @Override
        public final void putByteArray(long address, byte[] data2, int offset, int length) {
            Foreign.putByteArray(address, data2, offset, length);
        }

        @Override
        public final void getByteArray(long address, byte[] data2, int offset, int length) {
            Foreign.getByteArray(address, data2, offset, length);
        }

        @Override
        public final void putCharArray(long address, char[] data2, int offset, int length) {
            Foreign.putCharArray(address, data2, offset, length);
        }

        @Override
        public final void getCharArray(long address, char[] data2, int offset, int length) {
            Foreign.getCharArray(address, data2, offset, length);
        }

        @Override
        public final void putShortArray(long address, short[] data2, int offset, int length) {
            Foreign.putShortArray(address, data2, offset, length);
        }

        @Override
        public final void getShortArray(long address, short[] data2, int offset, int length) {
            Foreign.getShortArray(address, data2, offset, length);
        }

        @Override
        public final void putIntArray(long address, int[] data2, int offset, int length) {
            Foreign.putIntArray(address, data2, offset, length);
        }

        @Override
        public final void getIntArray(long address, int[] data2, int offset, int length) {
            Foreign.getIntArray(address, data2, offset, length);
        }

        @Override
        public final void putLongArray(long address, long[] data2, int offset, int length) {
            Foreign.putLongArray(address, data2, offset, length);
        }

        @Override
        public final void getLongArray(long address, long[] data2, int offset, int length) {
            Foreign.getLongArray(address, data2, offset, length);
        }

        @Override
        public final void putFloatArray(long address, float[] data2, int offset, int length) {
            Foreign.putFloatArray(address, data2, offset, length);
        }

        @Override
        public final void getFloatArray(long address, float[] data2, int offset, int length) {
            Foreign.getFloatArray(address, data2, offset, length);
        }

        @Override
        public final void putDoubleArray(long address, double[] data2, int offset, int length) {
            Foreign.putDoubleArray(address, data2, offset, length);
        }

        @Override
        public final void getDoubleArray(long address, double[] data2, int offset, int length) {
            Foreign.getDoubleArray(address, data2, offset, length);
        }

        @Override
        public final long getStringLength(long address) {
            return Foreign.strlen(address);
        }

        @Override
        public final byte[] getZeroTerminatedByteArray(long address) {
            return Foreign.getZeroTerminatedByteArray(address);
        }

        @Override
        public final byte[] getZeroTerminatedByteArray(long address, int maxlen) {
            return Foreign.getZeroTerminatedByteArray(address, maxlen);
        }

        @Override
        public final void putZeroTerminatedByteArray(long address, byte[] data2, int offset, int length) {
            Foreign.putZeroTerminatedByteArray(address, data2, offset, length);
        }
    }

    private static final class CheckedMemorySingletonHolder {
        private static final MemoryIO INSTANCE = MemoryIO.access$100();

        private CheckedMemorySingletonHolder() {
        }
    }

    private static final class SingletonHolder {
        private static final MemoryIO INSTANCE = MemoryIO.access$000();

        private SingletonHolder() {
        }
    }
}

