/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class BeanPropertyMap
implements Iterable<SettableBeanProperty>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Bucket[] _buckets;
    private final int _hashMask;
    private final int _size;
    private final boolean _caseInsensitive;
    private int _nextBucketIndex = 0;

    public BeanPropertyMap(Collection<SettableBeanProperty> properties, boolean caseInsensitivePropertyComparison) {
        this._caseInsensitive = caseInsensitivePropertyComparison;
        this._size = properties.size();
        int bucketCount = BeanPropertyMap.findSize(this._size);
        this._hashMask = bucketCount - 1;
        Bucket[] buckets = new Bucket[bucketCount];
        for (SettableBeanProperty property : properties) {
            String key = this.getPropertyName(property);
            int index2 = key.hashCode() & this._hashMask;
            buckets[index2] = new Bucket(buckets[index2], key, property, this._nextBucketIndex++);
        }
        this._buckets = buckets;
    }

    private BeanPropertyMap(Bucket[] buckets, int size2, int index2, boolean caseInsensitivePropertyComparison) {
        this._buckets = buckets;
        this._size = size2;
        this._hashMask = buckets.length - 1;
        this._nextBucketIndex = index2;
        this._caseInsensitive = caseInsensitivePropertyComparison;
    }

    public BeanPropertyMap withProperty(SettableBeanProperty newProperty) {
        int bcount = this._buckets.length;
        Bucket[] newBuckets = new Bucket[bcount];
        System.arraycopy(this._buckets, 0, newBuckets, 0, bcount);
        String propName = this.getPropertyName(newProperty);
        SettableBeanProperty oldProp = this.find(propName);
        if (oldProp == null) {
            int index2 = propName.hashCode() & this._hashMask;
            newBuckets[index2] = new Bucket(newBuckets[index2], propName, newProperty, this._nextBucketIndex++);
            return new BeanPropertyMap(newBuckets, this._size + 1, this._nextBucketIndex, this._caseInsensitive);
        }
        BeanPropertyMap newMap = new BeanPropertyMap(newBuckets, bcount, this._nextBucketIndex, this._caseInsensitive);
        newMap.replace(newProperty);
        return newMap;
    }

    public BeanPropertyMap renameAll(NameTransformer transformer) {
        if (transformer == null || transformer == NameTransformer.NOP) {
            return this;
        }
        Iterator<SettableBeanProperty> it = this.iterator();
        ArrayList<SettableBeanProperty> newProps = new ArrayList<SettableBeanProperty>();
        while (it.hasNext()) {
            JsonDeserializer<Object> newDeser;
            SettableBeanProperty prop = it.next();
            String newName = transformer.transform(prop.getName());
            JsonDeserializer<Object> deser = (prop = prop.withSimpleName(newName)).getValueDeserializer();
            if (deser != null && (newDeser = deser.unwrappingDeserializer(transformer)) != deser) {
                prop = prop.withValueDeserializer(newDeser);
            }
            newProps.add(prop);
        }
        return new BeanPropertyMap(newProps, this._caseInsensitive);
    }

    public BeanPropertyMap assignIndexes() {
        int index2 = 0;
        for (Bucket bucket : this._buckets) {
            while (bucket != null) {
                bucket.value.assignIndex(index2++);
                bucket = bucket.next;
            }
        }
        return this;
    }

    private static final int findSize(int size2) {
        int result2;
        int needed = size2 <= 32 ? size2 + size2 : size2 + (size2 >> 2);
        for (result2 = 2; result2 < needed; result2 += result2) {
        }
        return result2;
    }

    private String getPropertyName(SettableBeanProperty prop) {
        return this._caseInsensitive ? prop.getName().toLowerCase() : prop.getName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Properties=[");
        int count2 = 0;
        for (SettableBeanProperty prop : this.getPropertiesInInsertionOrder()) {
            if (prop == null) continue;
            if (count2++ > 0) {
                sb.append(", ");
            }
            sb.append(prop.getName());
            sb.append('(');
            sb.append(prop.getType());
            sb.append(')');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public Iterator<SettableBeanProperty> iterator() {
        return new IteratorImpl(this._buckets);
    }

    public SettableBeanProperty[] getPropertiesInInsertionOrder() {
        int len = this._nextBucketIndex;
        SettableBeanProperty[] result2 = new SettableBeanProperty[len];
        Bucket[] arr$ = this._buckets;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Bucket root2;
            Bucket bucket = root2 = arr$[i$];
            while (bucket != null) {
                result2[bucket.index] = bucket.value;
                bucket = bucket.next;
            }
        }
        return result2;
    }

    public int size() {
        return this._size;
    }

    public SettableBeanProperty find(String key) {
        int index2;
        Bucket bucket;
        if (key == null) {
            throw new IllegalArgumentException("Can not pass null property name");
        }
        if (this._caseInsensitive) {
            key = key.toLowerCase();
        }
        if ((bucket = this._buckets[index2 = key.hashCode() & this._hashMask]) == null) {
            return null;
        }
        if (bucket.key == key) {
            return bucket.value;
        }
        while ((bucket = bucket.next) != null) {
            if (bucket.key != key) continue;
            return bucket.value;
        }
        return this._findWithEquals(key, index2);
    }

    public boolean findDeserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean, String key) throws IOException {
        int index2;
        Bucket bucket;
        if (this._caseInsensitive) {
            key = key.toLowerCase();
        }
        if ((bucket = this._buckets[index2 = key.hashCode() & this._hashMask]) == null) {
            return false;
        }
        if (bucket.key == key) {
            try {
                bucket.value.deserializeAndSet(p, ctxt, bean);
            }
            catch (Exception e) {
                this.wrapAndThrow(e, bean, key, ctxt);
            }
            return true;
        }
        return this._findDeserializeAndSet2(p, ctxt, bean, key, index2);
    }

    private final boolean _findDeserializeAndSet2(JsonParser p, DeserializationContext ctxt, Object bean, String key, int index2) throws IOException {
        SettableBeanProperty prop;
        block4: {
            prop = null;
            Bucket bucket = this._buckets[index2];
            do {
                if ((bucket = bucket.next) != null) continue;
                prop = this._findWithEquals(key, index2);
                if (prop == null) {
                    return false;
                }
                break block4;
            } while (bucket.key != key);
            prop = bucket.value;
        }
        try {
            prop.deserializeAndSet(p, ctxt, bean);
        }
        catch (Exception e) {
            this.wrapAndThrow(e, bean, key, ctxt);
        }
        return true;
    }

    public SettableBeanProperty find(int propertyIndex) {
        for (Bucket bucket : this._buckets) {
            while (bucket != null) {
                if (bucket.index == propertyIndex) {
                    return bucket.value;
                }
                bucket = bucket.next;
            }
        }
        return null;
    }

    public void replace(SettableBeanProperty property) {
        String name = this.getPropertyName(property);
        int index2 = name.hashCode() & this._buckets.length - 1;
        Bucket tail = null;
        int foundIndex = -1;
        Bucket bucket = this._buckets[index2];
        while (bucket != null) {
            if (foundIndex < 0 && bucket.key.equals(name)) {
                foundIndex = bucket.index;
            } else {
                tail = new Bucket(tail, bucket.key, bucket.value, bucket.index);
            }
            bucket = bucket.next;
        }
        if (foundIndex < 0) {
            throw new NoSuchElementException("No entry '" + property + "' found, can't replace");
        }
        this._buckets[index2] = new Bucket(tail, name, property, foundIndex);
    }

    public void remove(SettableBeanProperty property) {
        String name = this.getPropertyName(property);
        int index2 = name.hashCode() & this._buckets.length - 1;
        Bucket tail = null;
        boolean found = false;
        Bucket bucket = this._buckets[index2];
        while (bucket != null) {
            if (!found && bucket.key.equals(name)) {
                found = true;
            } else {
                tail = new Bucket(tail, bucket.key, bucket.value, bucket.index);
            }
            bucket = bucket.next;
        }
        if (!found) {
            throw new NoSuchElementException("No entry '" + property + "' found, can't remove");
        }
        this._buckets[index2] = tail;
    }

    private SettableBeanProperty _findWithEquals(String key, int index2) {
        Bucket bucket = this._buckets[index2];
        while (bucket != null) {
            if (key.equals(bucket.key)) {
                return bucket.value;
            }
            bucket = bucket.next;
        }
        return null;
    }

    protected void wrapAndThrow(Throwable t, Object bean, String fieldName, DeserializationContext ctxt) throws IOException {
        boolean wrap2;
        while (t instanceof InvocationTargetException && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        boolean bl = wrap2 = ctxt == null || ctxt.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
        if (t instanceof IOException) {
            if (!wrap2 || !(t instanceof JsonProcessingException)) {
                throw (IOException)t;
            }
        } else if (!wrap2 && t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw JsonMappingException.wrapWithPath(t, bean, fieldName);
    }

    private static final class IteratorImpl
    implements Iterator<SettableBeanProperty> {
        private final Bucket[] _buckets;
        private Bucket _currentBucket;
        private int _nextBucketIndex;

        public IteratorImpl(Bucket[] buckets) {
            this._buckets = buckets;
            int i = 0;
            int len = this._buckets.length;
            while (i < len) {
                Bucket b;
                if ((b = this._buckets[i++]) == null) continue;
                this._currentBucket = b;
                break;
            }
            this._nextBucketIndex = i;
        }

        @Override
        public boolean hasNext() {
            return this._currentBucket != null;
        }

        @Override
        public SettableBeanProperty next() {
            Bucket curr = this._currentBucket;
            if (curr == null) {
                throw new NoSuchElementException();
            }
            Bucket b = curr.next;
            while (b == null && this._nextBucketIndex < this._buckets.length) {
                b = this._buckets[this._nextBucketIndex++];
            }
            this._currentBucket = b;
            return curr.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class Bucket
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Bucket next;
        public final String key;
        public final SettableBeanProperty value;
        public final int index;

        public Bucket(Bucket next2, String key, SettableBeanProperty value2, int index2) {
            this.next = next2;
            this.key = key;
            this.value = value2;
            this.index = index2;
        }
    }
}

